/* ------------------ */
/* --- nralloc3.h --- */
/* ------------------ */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
* 
*/


#ifndef __NRALLOC3_H__
#define __NRALLOC3_H__

#include "nrc_os_config.h"

//double*** d3tensor(long nrl, long nrh, long ncl, long nch, long ndl, long ndh);
//void free_d3tensor(double  ***t,long nrl,long nrh,long ncl,long nch,long ndl,long ndh);

#define type_cube(t) \
t *** short_name(t,,cube)(int32_t ndl, int32_t ndh, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch) \


type_cube(int8_t);
type_cube(uint8_t);
type_cube(int16_t);
type_cube(uint16_t);
type_cube(int32_t);
type_cube(uint32_t);
type_cube(int64_t);
type_cube(uint64_t);
type_cube(float);
type_cube(double);
type_cube(rgb8);
type_cube(rgbx8);

#define free_type_cube(t) \
void short_name(t,free_,cube)(t *** c, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, int32_t ndl, int32_t ndh) \

free_type_cube(int8_t);
free_type_cube(uint8_t);
free_type_cube(int16_t);
free_type_cube(uint16_t);
free_type_cube(int32_t);
free_type_cube(uint32_t);
free_type_cube(int64_t);
free_type_cube(uint64_t);
free_type_cube(float);
free_type_cube(double);
free_type_cube(rgb8);
free_type_cube(rgbx8);


#endif /* __NRALLOC3_H__ */

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:

// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

