/* ------------------ */
/* --- nrarith1.h --- */
/* ------------------ */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
*/

#ifndef _NRARITH1_H_
#define _NRARITH1_H_

/*
 * ------------------
 * --- sum_vector ---
 * ------------------
 */

#define sum_type_vector(t,r) \
r short_name(t,sum_,vector)(t * v, int32_t nl, int32_t nh)

sum_type_vector(int8_t, int32_t);
sum_type_vector(uint8_t, uint32_t);
sum_type_vector(int16_t, int32_t);
sum_type_vector(uint16_t, uint32_t);
sum_type_vector(int32_t, int32_t);
sum_type_vector(uint32_t, uint32_t);
sum_type_vector(float, float);
sum_type_vector(double, double);

/*
 * ------------------
 * --- min_vector ---
 * ------------------
 */

#define min_type_vector(t) \
t short_name(t,min_,vector)(t * v, int32_t nl, int32_t nh)

min_type_vector(int8_t);
min_type_vector(uint8_t);
min_type_vector(int16_t);
min_type_vector(uint16_t);
min_type_vector(int32_t);
min_type_vector(uint32_t);
min_type_vector(float);
min_type_vector(double);


/*
 * ------------------
 * --- max_vector ---
 * ------------------
 */

#define max_type_vector(t) \
t short_name(t,max_,vector)(t * v, int32_t nl, int32_t nh)

max_type_vector(int8_t);
max_type_vector(uint8_t);
max_type_vector(int16_t);
max_type_vector(uint16_t);
max_type_vector(int32_t);
max_type_vector(uint32_t);
max_type_vector(float);
max_type_vector(double);


/*
 * ----------------------
 * --- min_vector_pos ---
 * ----------------------
 */


#define min_type_vector_pos(t) \
t short_name(t,min_,vector_pos)(t * v, int32_t nl, int32_t nh, int32_t * pos)

min_type_vector_pos(int8_t);
min_type_vector_pos(uint8_t);
min_type_vector_pos(int16_t);
min_type_vector_pos(uint16_t);
min_type_vector_pos(int32_t);
min_type_vector_pos(uint32_t);
min_type_vector_pos(float);
min_type_vector_pos(double);


/*
 * ----------------------
 * --- max_vector_pos ---
 * ----------------------
 */

#define max_type_vector_pos(t) \
t short_name(t,max_,vector_pos)(t * v, int32_t nl, int32_t nh, int32_t * pos)

max_type_vector_pos(int8_t);
max_type_vector_pos(uint8_t);
max_type_vector_pos(int16_t);
max_type_vector_pos(uint16_t);
max_type_vector_pos(int32_t);
max_type_vector_pos(uint32_t);
max_type_vector_pos(float);
max_type_vector_pos(double);


// =============
// === other ===
// =============

#define add_type_vector(t) \
void short_name(t,add_,vector)(t * S1, int32_t nl, int32_t nh, t * S2, t * D)

add_type_vector(int8_t);
add_type_vector(uint8_t);
add_type_vector(int16_t);
add_type_vector(uint16_t);
add_type_vector(int32_t);
add_type_vector(uint32_t);
add_type_vector(float);
add_type_vector(double);

#define sub_type_vector(t) \
void short_name(t,sub_,vector)(t * S1, int32_t nl, int32_t nh, t * S2, t * D)

sub_type_vector(int8_t);
sub_type_vector(uint8_t);
sub_type_vector(int16_t);
sub_type_vector(uint16_t);
sub_type_vector(int32_t);
sub_type_vector(uint32_t);
sub_type_vector(float);
sub_type_vector(double);

#define mulc_type_vector(t) \
void short_name(t,mulc_,vector)(t * S, int32_t nl, int32_t nh, int32_t c, t * D)

mulc_type_vector(int8_t);
mulc_type_vector(uint8_t);
mulc_type_vector(int16_t);
mulc_type_vector(uint16_t);
mulc_type_vector(int32_t);
mulc_type_vector(uint32_t);
mulc_type_vector(float);
mulc_type_vector(double);

#define divc_type_vector(t) \
void short_name(t,divc_,vector)(t * S, int32_t nl, int32_t nh, int32_t c, t * D)

divc_type_vector(int8_t);
divc_type_vector(uint8_t);
divc_type_vector(int16_t);
divc_type_vector(uint16_t);
divc_type_vector(int32_t);
divc_type_vector(uint32_t);
divc_type_vector(float);
divc_type_vector(double);


#define cumulleft_type_vector(t) \
void short_name(t,cumulleft_,vector)(t * S, int32_t nl, int32_t nh, int32_t * D)

cumulleft_type_vector(int8_t);
cumulleft_type_vector(uint8_t);
cumulleft_type_vector(int16_t);
cumulleft_type_vector(uint16_t);
cumulleft_type_vector(int32_t);
cumulleft_type_vector(uint32_t);
cumulleft_type_vector(float);
cumulleft_type_vector(double);

#define cumulright_type_vector(t) \
void short_name(t,cumulright_,vector)(t * S, int32_t nl, int32_t nh, int32_t * D)

cumulright_type_vector(int8_t);
cumulright_type_vector(uint8_t);
cumulright_type_vector(int16_t);
cumulright_type_vector(uint16_t);
cumulright_type_vector(int32_t);
cumulright_type_vector(uint32_t);
cumulright_type_vector(float);
cumulright_type_vector(double);


#define mulfrac_type_vector(t) \
void short_name(t,mulfrac_,vector)(t * S, int32_t nl, int32_t nh, int32_t a, int32_t b, t * D)

mulfrac_type_vector(int8_t);
mulfrac_type_vector(uint8_t);
mulfrac_type_vector(int16_t);
mulfrac_type_vector(uint16_t);
mulfrac_type_vector(int32_t);
mulfrac_type_vector(uint32_t);
mulfrac_type_vector(float);
mulfrac_type_vector(double);



void beta_sum_rgb32vector    (rgb32 * S, int32_t nl, int32_t nh, rgb32 * D);
void beta_average_rgb32vector(rgb32 * S, int32_t nl, int32_t nh, rgb32 * D);
void cumulleft_rgb32vector   (rgb32 * S, int32_t nl, int32_t nh, rgb32 * D);
void cumulright_rgb32vector  (rgb32 * S, int32_t nl, int32_t nh, rgb32 * D);
void mulc_rgb32vector        (rgb32 * S, int32_t nl, int32_t nh, int32 c, rgb32 * D);
void divc_rgb32vector        (rgb32 * S, int32_t nl, int32_t nh, int32 c, rgb32 * D);
void mulfrac_rgb32vector     (rgb32 * S, int32_t nl, int32_t nh, int32 a, int32 b, rgb32 * D);


#endif /* _NRARITH1_H_ */

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:

// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

