/* ----------------- */
/* -- nrarith2.h --- */
/* ----------------- */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
*/

#ifndef _NRARITH2_H_
#define _NRARITH2_H_

#include "nrc_os_config.h"

/* ------------------ */
/* --- Min_matrix --- */
/* ------------------ */

#define min_type_matrix(t) \
t short_name(t,min_,matrix)(t ** m, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch)

min_type_matrix(int8_t);
min_type_matrix(uint8_t);
min_type_matrix(int16_t);
min_type_matrix(uint16_t);
min_type_matrix(int32_t);
min_type_matrix(uint32_t);
min_type_matrix(int64_t);
min_type_matrix(uint64_t);
min_type_matrix(float);
min_type_matrix(double);


/* ------------------ */
/* --- Max_matrix --- */
/* ------------------ */

#define max_type_matrix(t) \
t short_name(t,max_,matrix)(t ** m, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch)

max_type_matrix(int8_t);
max_type_matrix(uint8_t);
max_type_matrix(int16_t);
max_type_matrix(uint16_t);
max_type_matrix(int32_t);
max_type_matrix(uint32_t);
max_type_matrix(int64_t);
max_type_matrix(uint64_t);
max_type_matrix(float);
max_type_matrix(double);


/* ------------------ */
/* --- Add Matrix --- */
/* ------------------ */

#define add_type_matrix(t) \
void short_name(t,add_,matrix)(t ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, t ** Y, t ** Z)

add_type_matrix(int8_t);
add_type_matrix(uint8_t);
add_type_matrix(int16_t);
add_type_matrix(uint16_t);
add_type_matrix(int32_t);
add_type_matrix(uint32_t);
add_type_matrix(int64_t);
add_type_matrix(uint64_t);
add_type_matrix(float);
add_type_matrix(double);

void add_rgb8matrix (rgb8  ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, rgb8  ** Y, rgb8  ** Z);
void add_rgbx8matrix(rgbx8 ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, rgbx8 ** Y, rgbx8 ** Z);


/* -------------------- */
/* --- Add constant --- */
/* -------------------- */

#define addc_type_matrix(t) \
void short_name(t,addc_,matrix)(t ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, t y, t ** Z)

addc_type_matrix(int8_t);
addc_type_matrix(uint8_t);
addc_type_matrix(int16_t);
addc_type_matrix(uint16_t);
addc_type_matrix(int32_t);
addc_type_matrix(uint32_t);
addc_type_matrix(int64_t);
addc_type_matrix(uint64_t);
addc_type_matrix(float);
addc_type_matrix(double);

void addc_rgb8matrix (rgb8  ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, rgb8  y, rgb8  ** Z);
void addc_rgbx8matrix(rgbx8 ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, rgbx8 y, rgbx8 ** Z);


/* ----------- */
/* --- Sub --- */
/* ----------- */

#define sub_type_matrix(t) \
void short_name(t,sub_,matrix)(t ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, t ** Y, t ** Z)

sub_type_matrix(int8_t);
sub_type_matrix(uint8_t);
sub_type_matrix(int16_t);
sub_type_matrix(uint16_t);
sub_type_matrix(int32_t);
sub_type_matrix(uint32_t);
sub_type_matrix(int64_t);
sub_type_matrix(uint64_t);
sub_type_matrix(float);
sub_type_matrix(double);

void sub_rgb8matrix (rgb8  ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, rgb8  ** Y, rgb8  ** Z);
void sub_rgbx8matrix(rgbx8 ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, rgbx8 ** Y, rgbx8 ** Z);


/* --------------------- */
/* --- Sub constante --- */
/* --------------------- */

#define subc_type_matrix(t) \
void short_name(t,subc_,matrix)(t ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, t y, t ** Z)

subc_type_matrix(int8_t);
subc_type_matrix(uint8_t);
subc_type_matrix(int16_t);
subc_type_matrix(uint16_t);
subc_type_matrix(int32_t);
subc_type_matrix(uint32_t);
subc_type_matrix(int64_t);
subc_type_matrix(uint64_t);
subc_type_matrix(float);
subc_type_matrix(double);

void subc_rgb8matrix (rgb8  ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, rgb8  y, rgb8  ** Z);
void subc_rgbx8matrix(rgbx8 ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, rgbx8 y, rgbx8 ** Z);

/* --------------------- */
/* --- Mul constante --- */
/* --------------------- */

// Z = X * y

#define mulc_type_matrix(t) \
void short_name(t,mulc_,matrix)(t ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, t y, t ** Z)

mulc_type_matrix(int8_t);
mulc_type_matrix(uint8_t);
mulc_type_matrix(int16_t);
mulc_type_matrix(uint16_t);
mulc_type_matrix(int32_t);
mulc_type_matrix(uint32_t);
mulc_type_matrix(int64_t);
mulc_type_matrix(uint64_t);
mulc_type_matrix(float);
mulc_type_matrix(double);

void mulc_rgb8matrix (rgb8  ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, rgb8  y, rgb8  ** Z);
void mulc_rgbx8matrix(rgbx8 ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, rgbx8 y, rgbx8 ** Z);


/* --------------- */
/* --- MulFrac --- */
/* --------------- */

// m2 = (a * m1) / b

#define mulfrac_type_matrix(t) \
void short_name(t,mulfrac_,matrix)(t ** X, int32_t nrl, int32_t nrh, \
        int32_t ncl, int32_t nch, int32_t a, int32_t b, t ** Y)

mulfrac_type_matrix(int8_t);
mulfrac_type_matrix(uint8_t);
mulfrac_type_matrix(int16_t);
mulfrac_type_matrix(uint16_t);
mulfrac_type_matrix(int32_t);
mulfrac_type_matrix(uint32_t);
mulfrac_type_matrix(int64_t);
mulfrac_type_matrix(uint64_t);
mulfrac_type_matrix(float);
mulfrac_type_matrix(double);

void mulfrack_rgb8matrix (rgb8  ** m1, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, int32 a, int32 b, rgb8  ** m2);
void mulfrack_rgbx8matrix(rgbx8 ** m1, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, int32 a, int32 b, rgbx8 ** m2);


/* ---------------- */
/* --- MulShift --- */
/* ---------------- */
// m3 = (a * m1) >> s

#define mulshift_type_matrix(t) \
void short_name(t,mulshift_,matrix)(t ** X, int32_t nrl, int32_t nrh, \
        int32_t ncl, int32_t nch, int32_t a, int32_t s, t ** Y)

mulshift_type_matrix(int8_t);
mulshift_type_matrix(uint8_t);
mulshift_type_matrix(int16_t);
mulshift_type_matrix(uint16_t);
mulshift_type_matrix(int32_t);
mulshift_type_matrix(uint32_t);
mulshift_type_matrix(int64_t);
mulshift_type_matrix(uint64_t);
mulshift_type_matrix(float);
mulshift_type_matrix(double);

void mulshift_rgb8matrix (rgb8  **m1, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, rgb32  a, rgb32  s, rgb8  ** m2);
void mulshift_rgbx8matrix(rgbx8 **m1, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, rgbx32 a, rgbx32 s, rgbx8 ** m2);

void mulshiftk_rgb8matrix (rgb8  ** m1, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, int32 a, int32 s, rgb8  ** m2);
void mulshiftk_rgbx8matrix(rgbx8 ** m1, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, int32 a, int32 s, rgbx8 ** m2);

void quadratic_error_si16matrix(sint16 ** m1, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, sint16 ** m2, sint16 ** m3);


#endif /* _NRARITH2_H_ */

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:

// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

