/* ------------------ */
/* --- nralloc1.c --- */
/* ------------------ */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
 * Distributed under the Boost Software License, Version 1.0
 * see accompanying file LICENSE.txt or copy it at
 * http://www.boost.org/LICENSE_1_0.txt
*/

/* 
 * History:
 *2002/06/11 ajout des fonctions endline
*/
#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>
#include <malloc.h>
#include <math.h> // fabs

#include "nrc_os_config.h"
#include "mypredef.h"
#include "nrtype.h"
#include "nrdef.h"
#include "nrmacro.h"
#include "nrkernel.h"

#include "nrarith1.h"

/*
 * ------------------
 * --- sum_vector ---
 * ------------------
 */

#undef sum_type_vector
#define sum_type_vector(t,r)                                     \
r short_name(t,sum_,vector)(t * v, int32_t nl, int32_t nh)       \
{                                                                \
    r s = 0;                                                     \
    for (int32_t i = nl; i <= nh; i++) {                         \
        s += v[i];                                               \
    }                                                            \
    return s;                                                    \
}

sum_type_vector(int8_t, int32_t);
sum_type_vector(uint8_t, uint32_t);
sum_type_vector(int16_t, int32_t);
sum_type_vector(uint16_t, uint32_t);
sum_type_vector(int32_t, int32_t);
sum_type_vector(uint32_t, uint32_t);
sum_type_vector(float, float);
sum_type_vector(double, double);

/*
 * ------------------
 * --- min_vector ---
 * ------------------
 */

#undef min_type_vector
#define min_type_vector(t)                                 \
t short_name(t,min_,vector)(t * v, int32_t nl, int32_t nh) \
{                                                          \
    t m = v[nl];                                           \
    for (int32_t i = nl + 1; i <= nh; i++) {               \
        if (v[i] < m) {                                    \
            m = v[i];                                      \
        }                                                  \
    }                                                      \
    return m;                                              \
}


min_type_vector(int8_t);
min_type_vector(uint8_t);
min_type_vector(int16_t);
min_type_vector(uint16_t);
min_type_vector(int32_t);
min_type_vector(uint32_t);
min_type_vector(float);
min_type_vector(double);


/*
 * ------------------
 * --- max_vector ---
 * ------------------
 */

#undef max_type_vector
#define max_type_vector(t)                                 \
t short_name(t,max_,vector)(t * v, int32_t nl, int32_t nh) \
{                                                          \
    t m = v[nl];                                           \
    for (int32_t i = nl + 1; i <= nh; i++) {               \
        if (v[i] > m) {                                    \
            m = v[i];                                      \
        }                                                  \
    }                                                      \
    return m;                                              \
}


max_type_vector(int8_t);
max_type_vector(uint8_t);
max_type_vector(int16_t);
max_type_vector(uint16_t);
max_type_vector(int32_t);
max_type_vector(uint32_t);
max_type_vector(float);
max_type_vector(double);


/*
 * ----------------------
 * --- min_vector_pos ---
 * ----------------------
 */


#undef min_type_vector_pos
#define min_type_vector_pos(t)                                                \
t short_name(t,min_,vector_pos)(t * v, int32_t nl, int32_t nh, int32_t * pos) \
{                                                                             \
    t m = v[nl];                                                              \
    int32_t p = nl;                                                           \
    for (int32_t i = nl + 1; i <= nh; i++) {                                  \
        if (v[i] < m) {                                                       \
            m = v[i];                                                         \
            p = i;                                                            \
        }                                                                     \
    }                                                                         \
    *pos = p;                                                                 \
    return m;                                                                 \
}


min_type_vector_pos(int8_t);
min_type_vector_pos(uint8_t);
min_type_vector_pos(int16_t);
min_type_vector_pos(uint16_t);
min_type_vector_pos(int32_t);
min_type_vector_pos(uint32_t);
min_type_vector_pos(float);
min_type_vector_pos(double);


/*
 * ----------------------
 * --- max_vector_pos ---
 * ----------------------
 */


#undef max_type_vector_pos
#define max_type_vector_pos(t)                                                \
t short_name(t,max_,vector_pos)(t * v, int32_t nl, int32_t nh, int32_t * pos) \
{                                                                             \
    t m = v[nl];                                                              \
    int32_t p = nl;                                                           \
    for (int32_t i = nl + 1; i <= nh; i++) {                                  \
        if (v[i] > m) {                                                       \
            m = v[i];                                                         \
            p = i;                                                            \
        }                                                                     \
    }                                                                         \
    *pos = p;                                                                 \
    return m;                                                                 \
}


max_type_vector_pos(int8_t);
max_type_vector_pos(uint8_t);
max_type_vector_pos(int16_t);
max_type_vector_pos(uint16_t);
max_type_vector_pos(int32_t);
max_type_vector_pos(uint32_t);
max_type_vector_pos(float);
max_type_vector_pos(double);


#undef add_type_vector
#define add_type_vector(t) \
void short_name(t,add_,vector)(t * S1, int32_t nl, int32_t nh, t * S2, t * D) \
{                                                                             \
    for (int32_t i = nl; i <= nh; i++) {                                      \
        D[i] = S1[i] + S2[i];                                                 \
    }                                                                         \
}

add_type_vector(int8_t);
add_type_vector(uint8_t);
add_type_vector(int16_t);
add_type_vector(uint16_t);
add_type_vector(int32_t);
add_type_vector(uint32_t);
add_type_vector(float);
add_type_vector(double);


#undef sub_type_vector
#define sub_type_vector(t) \
void short_name(t,sub_,vector)(t * S1, int32_t nl, int32_t nh, t * S2, t * D) \
{                                                                             \
    for (int32_t i = nl; i <= nh; i++) {                                      \
        D[i] = S1[i] - S2[i];                                                 \
    }                                                                         \
}

sub_type_vector(int8_t);
sub_type_vector(uint8_t);
sub_type_vector(int16_t);
sub_type_vector(uint16_t);
sub_type_vector(int32_t);
sub_type_vector(uint32_t);
sub_type_vector(float);
sub_type_vector(double);


#undef mulc_type_vector
#define mulc_type_vector(t) \
void short_name(t,mulc_,vector)(t * S, int32_t nl, int32_t nh, int32_t c, t * D)  \
{                                                                                 \
    for (int32_t i = nl; i <= nh; i++) {                                          \
        D[i] = S[i] * c;                                                          \
    }                                                                             \
}

mulc_type_vector(int8_t);
mulc_type_vector(uint8_t);
mulc_type_vector(int16_t);
mulc_type_vector(uint16_t);
mulc_type_vector(int32_t);
mulc_type_vector(uint32_t);
mulc_type_vector(float);
mulc_type_vector(double);


#undef divc_type_vector
#define divc_type_vector(t) \
void short_name(t,divc_,vector)(t * S, int32_t nl, int32_t nh, int32_t c, t * D)  \
{                                                                                 \
    for (int32_t i = nl; i <= nh; i++) {                                          \
        D[i] = S[i] / c;                                                          \
    }                                                                             \
}

divc_type_vector(int8_t);
divc_type_vector(uint8_t);
divc_type_vector(int16_t);
divc_type_vector(uint16_t);
divc_type_vector(int32_t);
divc_type_vector(uint32_t);
divc_type_vector(float);
divc_type_vector(double);


#undef cumulleft_type_vector
#define cumulleft_type_vector(t) \
void short_name(t,cumulleft_,vector)(t * S, int32_t nl, int32_t nh, int32_t * D) \
{                                                                                \
    for (int32_t i = nh - 1; i >= nl; i--) {                                     \
        D[i] += S[i + 1];                                                        \
    }                                                                            \
}

cumulleft_type_vector(int8_t);
cumulleft_type_vector(uint8_t);
cumulleft_type_vector(int16_t);
cumulleft_type_vector(uint16_t);
cumulleft_type_vector(int32_t);
cumulleft_type_vector(uint32_t);
cumulleft_type_vector(float);
cumulleft_type_vector(double);


#undef cumulright_type_vector
#define cumulright_type_vector(t) \
void short_name(t,cumulright_,vector)(t * S, int32_t nl, int32_t nh, int32_t * D) \
{                                                                                 \
    for (int32_t i = nl + 1; i <= nh; i++) {                                      \
        D[i] += S[i - 1];                                                         \
    }                                                                             \
}

cumulright_type_vector(int8_t);
cumulright_type_vector(uint8_t);
cumulright_type_vector(int16_t);
cumulright_type_vector(uint16_t);
cumulright_type_vector(int32_t);
cumulright_type_vector(uint32_t);
cumulright_type_vector(float);
cumulright_type_vector(double);


#undef mulfrac_type_vector
#define mulfrac_type_vector(t) \
void short_name(t,mulfrac_,vector)(t * S, int32_t nl, int32_t nh, int32_t a, int32_t b, t * D) \
{                                                                                              \
    for (int32_t i = nl; i <= nh; i++) {                                                       \
        D[i] = (a * S[i]) / b;                                                                 \
    }                                                                                          \
}


mulfrac_type_vector(int8_t);
mulfrac_type_vector(uint8_t);
mulfrac_type_vector(int16_t);
mulfrac_type_vector(uint16_t);
mulfrac_type_vector(int32_t);
mulfrac_type_vector(uint32_t);
mulfrac_type_vector(float);
mulfrac_type_vector(double);


/* --------------------------------------------------------------------- */
void beta_sum_rgb32vector(rgb32 * S, int32_t nl, int32_t nh, rgb32 * D)
/* --------------------------------------------------------------------- */
{
    int32_t r, g, b;
    int32_t s;
    for (int32_t i = nl; i <= nh; i++) {
        r = S[i].r;
        g = S[i].g;
        b = S[i].b;
        s = r + g + b;
        D[i].r = s;
        D[i].g = s;
        D[i].b = s;
    }
}

/* ----------------------------------------------------------------------- */
void beta_average_rgb32vector(rgb32 * S, int32_t nl, int32_t nh, rgb32 * D)
/* ----------------------------------------------------------------------- */
{
    int32_t r, g, b;
    int32_t s;
    for (int32_t i = nl; i <= nh; i++) {
        r = S[i].r;
        g = S[i].g;
        b = S[i].b;
        s = (r + g + b) / 3;
        D[i].r = s;
        D[i].g = s;
        D[i].b = s;
    }
}

/* ------------------------------------------------------------------------ */
void mulc_rgb32vector(rgb32 * S, int32_t nl, int32_t nh, int32_t c, rgb32 * D)
/* ------------------------------------------------------------------------ */
{
    for (int32_t i = nl; i <= nh; i++) {
        D[i].r = c * S[i].r;
        D[i].g = c * S[i].g;
        D[i].b = c * S[i].b;
    }
}

/* --------------------------------------------------------------------- */
void divc_rgb32vector(rgb32 * S, int32_t nl, int32_t nh, int32_t c, rgb32 * D)
/* --------------------------------------------------------------------- */
{
    for (int32_t i = nl; i <= nh; i++) {
        D[i].r = S[i].r / c;
        D[i].g = S[i].g / c;
        D[i].b = S[i].b / c;
    }
}

/* --------------------------------------------------------------------- */
void cumulleft_rgb32vector(rgb32 * S, int32_t nl, int32_t nh, rgb32 * D)
/* --------------------------------------------------------------------- */
{
    // for histogram
    for (int32_t i = nh - 1; i >= nl; i--) {
        D[i].r += S[i + 1].r;
        D[i].g += S[i + 1].g;
        D[i].b += S[i + 1].b;
    }
}

    
/* --------------------------------------------------------------------- */
void cumulright_rgb32vector(rgb32 * S, int32_t nl, int32_t nh, rgb32 * D)
/* --------------------------------------------------------------------- */
{
    // for histogram
    for (int32_t i = nl + 1; i <= nh; i++) {
        D[i].r += S[i - 1].r;
        D[i].g += S[i - 1].g;
        D[i].b += S[i - 1].b;
    }
}


/* ------------------------------------------------------------------------------------- */
void mulfrac_rgb32vector(rgb32 * S, int32_t nl, int32_t nh, int32_t a, int32_t b, rgb32 * D)
/* ------------------------------------------------------------------------------------- */
{
    for (int32_t i = nl; i <= nh; i++) {
        D[i].r = (a * S[i].r) / b;
        D[i].g = (a * S[i].g) / b;
        D[i].b = (a * S[i].b) / b;
    }
}

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:

// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

