// --------------- //
// -- str_ext.c -- //
// --------------- //

// string extensions
// Copyright (c) 2014 Lionel Lacassagne, All Rights Reserved
// LRI, Univ Paris-Sud XI, CNRS

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "nrc_os_config.h"

// ----------------------------------------------
void str_remove_ext(const char * src, char * dst)
// ----------------------------------------------
{
    int len;
    char * ptr = NULL; // ptr to the position of the '.'
    
    if (src == NULL) {
        printf("########################################");
        printf("### str_remove_ext ERROR: src = NULL ###");
        printf("########################################");
        giet_pthread_exit("exit(-1)");
    }
    if (dst == NULL) {
        printf("########################################");
        printf("### str_remove_ext ERROR: dst = NULL ###");
        printf("########################################");
        giet_pthread_exit("exit(-1)");
    }
    
    ptr = strchr(src, '.');
    if (ptr != NULL) {
        len = ptr - src;
    }
    else {
        len = strlen(src);
    }
    // safe copy min(len, dst)
    if (len < strlen(dst)) {
        len = strlen(dst);
    }
    strncpy(dst, src, len);
    dst[len] = '\0'; // do not forget to add null char, otherwise
}


// -------------------
int str_len(char * str)
// -------------------
{
    char * ptr = str;
    while (*ptr) {
        ptr++;
    }
    return ptr - str;
}
// ------------------------
void str_toupper(char * str)
// ------------------------
{
    // convert -in situ- all alpha char toupper
    
    int i, len;
    //char c;
    len = strlen(str);
    
    for (i = 0; i < len; i++) {
        /*if(isalpha(str[i])) {
            str[i] = toupper(str[i]);
        }*/
        /*c = str[i];
        if(isalpha(c)) {
            str[i] = toupper(c);
        }*/
    }
}
// ---------------------------
void test_str_remove_ext(void)
// ---------------------------
{
    char * str1 = "toto.txt";
    char * str2 = "toto";
    char * str3 = "";
    char * str4 =".txt";
    char * str5 =".";
    char * str6 = NULL;
    
    char string[1024];
    
    printf("---------------------------");
    printf("-- test_str_remove_ext() --");
    printf("---------------------------");
    
    printf("display\n");
    printf("str1 = %s\n", str1);
    printf("str2 = %s\n", str2);
    printf("str3 = %s\n", str3);
    printf("str4 = %s\n", str4);
    
    printf("\nstr_remove\n");
    str_remove_ext(str1, string); printf("'%s' -> '%s'\n", str1, string);
    str_remove_ext(str2, string); printf("'%s' -> '%s'\n", str2, string);
    str_remove_ext(str3, string); printf("'%s' -> '%s'\n", str3, string);
    str_remove_ext(str4, string); printf("'%s' -> '%s'\n", str4, string);
    str_remove_ext(str5, string); printf("'%s' -> '%s'\n", str5, string);
    str_remove_ext(str6, string); printf("'%s' -> '%s'\n", str6, string); // plante
}
