/* ----------------- */
/* --- nrbool1.h --- */
/* ----------------- */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
*/

#ifndef _NR_BOOL1_H_
#define _NR_BOOL1_H_


/* ========================== */
/* === Logical operations === */
/* ========================== */

/* ----------- */
/* --- Not --- */
/* ----------- */
/* Y = ! Y */

#define not_type_vector(t) \
void short_name(t,not_,vector)(t * X, int32_t ncl, int32_t nch, t * Y)

not_type_vector(int8_t);
not_type_vector(uint8_t);
not_type_vector(int16_t);
not_type_vector(uint16_t);
not_type_vector(int32_t);
not_type_vector(uint32_t);
not_type_vector(int64_t);
not_type_vector(uint64_t);
not_type_vector(rgb8);
not_type_vector(rgbx8);


/* ---------- */
/* --- Or --- */
/* ---------- */
/* Z = X | Y */

#define or_type_vector(t) \
void short_name(t,or_,vector)(t * X, int32_t ncl, int32_t nch, t * Y, t * Z); \
void short_name(t,orc_,vector)(t * X, int32_t ncl, int32_t nch, t y, t * Z)

or_type_vector(int8_t);
or_type_vector(uint8_t);
or_type_vector(int16_t);
or_type_vector(uint16_t);
or_type_vector(int32_t);
or_type_vector(uint32_t);
or_type_vector(int64_t);
or_type_vector(uint64_t);
or_type_vector(rgb8);
or_type_vector(rgbx8);


/* ----------- */
/* --- Xor --- */
/* ----------- */
/* Z = X ^ Y */

#define xor_type_vector(t) \
void short_name(t,xor_,vector)(t * X, int32_t ncl, int32_t nch, t * Y, t * Z); \
void short_name(t,xorc_,vector)(t * X, int32_t ncl, int32_t nch, t y, t * Z)

xor_type_vector(int8_t);
xor_type_vector(uint8_t);
xor_type_vector(int16_t);
xor_type_vector(uint16_t);
xor_type_vector(int32_t);
xor_type_vector(uint32_t);
xor_type_vector(int64_t);
xor_type_vector(uint64_t);
xor_type_vector(rgb8);
xor_type_vector(rgbx8);


/* ----------- */
/* --- And --- */
/* ----------- */
/* Z = X & Y */

#define and_type_vector(t) \
void short_name(t,and_,vector)(t * X, int32_t ncl, int32_t nch, t * Y, t * Z); \
void short_name(t,andc_,vector)(t * X, int32_t ncl, int32_t nch, t y, t * Z)

and_type_vector(int8_t);
and_type_vector(uint8_t);
and_type_vector(int16_t);
and_type_vector(uint16_t);
and_type_vector(int32_t);
and_type_vector(uint32_t);
and_type_vector(int64_t);
and_type_vector(uint64_t);
and_type_vector(rgb8);
and_type_vector(rgbx8);


#endif // _NR_BOOL1_H_

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:

// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

