/* ---------------- */
/* --- nrtype.h --- */
/* ---------------- */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
 *
 * Modif : 15/01/2001 : rgb16, rgb32 are now signed (int16, int32)
 * modif : 22/02/2001 : new types : float32 & float64
 * modif : 15/02/2004 : clean-up previous definition for mac-OSX port
 * modif:  1/06/2010 : split of def.h into nrtype.h nrdefine.h ...
 */

#ifndef _NRTYPE_H_
#define _NRTYPE_H_

#include <stdint.h>


#include "mypredef.h"
    

// Short names

#define sn_int8_t(p,s)      p##i8##s
#define sn_int16_t(p,s)     p##i16##s
#define sn_int32_t(p,s)     p##i32##s
#define sn_int64_t(p,s)     p##i64##s
#define sn_uint8_t(p,s)     p##ui8##s
#define sn_uint16_t(p,s)    p##ui16##s
#define sn_uint32_t(p,s)    p##ui32##s
#define sn_uint64_t(p,s)    p##ui64##s
#define sn_float(p,s)       p##f32##s
#define sn_double(p,s)      p##f64##s
#define sn_void_p(p,s)      p##v##s
#define sn_rgb8(p,s)        p##rgb8##s
#define sn_rgbx8(p,s)       p##rgbx8##s
#define sn_rgb32(p,s)       p##rgb32##s
#define sn_rgbx32(p,s)      p##rgbx32##s
#define sn_complex32(p,s)   p##c32##s
#define sn_complex64(p,s)   p##c64##s
#define sn_si16Point(p,s)   p##si16P##s
#define sn_ui16Point(p,s)   p##ui16P##s
#define sn_si32Point(p,s)   p##si32P##s
#define sn_ui32Point(p,s)   p##ui32P##s
#define sn_f32Point(p,s)    p##f32P##s
#define sn_si16Triplet(p,s) p##si16T##s
#define sn_ui16Triplet(p,s) p##ui16T##s
#define sn_si32Triplet(p,s) p##si32T##s
#define sn_ui32Triplet(p,s) p##ui32T##s
#define sn_f32Triplet(p,s)  p##f32T##s

#define short_name(t,p,s) sn_##t(p,s)

#define NR_END 0
#define FREE_ARG char*




/* ------------------------------- */
/* --- 8, 16, 32, 64 bit types --- */
/* ------------------------------- */

typedef void * void_p;
typedef char    byte;

typedef int8_t  int8;
typedef int16_t int16;
typedef int32_t int32;
typedef int64_t int64;
    

// full-typed types
typedef int8_t   sint8;
typedef uint8_t  uint8;

typedef int16_t  sint16;
typedef uint16_t uint16;

typedef int32_t  sint32;
typedef uint32_t uint32;

typedef int64_t  sint64;
typedef uint64_t uint64;

typedef float    float32;
typedef double   float64;


/* -------------------- */
/* --- complex type --- */
/* -------------------- */

typedef struct { float32 x; float32 y;} complex32;
typedef struct { float64 x; float64 y;} complex64;

/* --------------------- */
/* --- RGB, BGR type --- */
/* --------------------- */
//typedef struct { byte  r; byte  g; byte  b; } rgb8;

typedef struct { uint8   r; uint8   g; uint8   b; } rgb8;
typedef struct { sint16  r; sint16  g; sint16  b; } rgb16;
typedef struct { sint32  r; sint32  g; sint32  b; } rgb32;
typedef struct { float32 r; float32 g; float32 b; } rgbf32;

typedef struct { uint8   b; uint8   g; uint8   r; } bgr8;
typedef struct { sint16  b; sint16  g; sint16  r; } bgr16;
typedef struct { sint32  b; sint32  g; sint32  r; } bgr32;
typedef struct { float32 b; float32 g; float32 r; } bgrf32;

typedef struct { uint8   r; uint8   g; uint8   b; uint8   x; } rgbx8;
typedef struct { int16   r; int16   g; int16   b; int16   x; } rgbx16;
typedef struct { int32   r; int32   g; int32   b; int32   x; } rgbx32;
typedef struct { float32 r; float32 g; float32 b; float32 x; } rgbxf32;

typedef struct { uint8   x; uint8   b; uint8   g; uint8   r; } bgrx8;
typedef struct { int16   x; int16   b; int16   g; int16   r; } bgrx16;
typedef struct { int32   x; int32   b; int32   g; int32   r; } bgrx32;
typedef struct { float32 x; float32 b; float32 g; float32 r; } bgrxf32;

/* ---------------- */
/* --- bitfield --- */
/* ---------------- */
typedef struct {
    unsigned int b0  : 1;
    unsigned int b1  : 1;
    unsigned int b2  : 1;
    unsigned int b3  : 1;
    unsigned int b4  : 1;
    unsigned int b5  : 1;
    unsigned int b6  : 1;
    unsigned int b7  : 1;
    unsigned int b8  : 1;
    unsigned int b9  : 1;
    unsigned int b10 : 1;
    unsigned int b11 : 1;
    unsigned int b12 : 1;
    unsigned int b13 : 1;
    unsigned int b14 : 1;
    unsigned int b15 : 1;
    unsigned int b16 : 1;
    unsigned int b17 : 1;
    unsigned int b18 : 1;
    unsigned int b19 : 1;
    unsigned int b20 : 1;
    unsigned int b21 : 1;
    unsigned int b22 : 1;
    unsigned int b23 : 1;
    unsigned int b24 : 1;
    unsigned int b25 : 1;
    unsigned int b26 : 1;
    unsigned int b27 : 1;
    unsigned int b28 : 1;
    unsigned int b29 : 1;
    unsigned int b30 : 1;
    unsigned int b31 : 1;
} bitfield32;

typedef struct {
    unsigned int b0  : 1;
    unsigned int b1  : 1;
    unsigned int b2  : 1;
    unsigned int b3  : 1;
    unsigned int b4  : 1;
    unsigned int b5  : 1;
    unsigned int b6  : 1;
    unsigned int b7  : 1;
    unsigned int b8  : 1;
    unsigned int b9  : 1;
    unsigned int b10 : 1;
    unsigned int b11 : 1;
    unsigned int b12 : 1;
    unsigned int b13 : 1;
    unsigned int b14 : 1;
    unsigned int b15 : 1;
} bitfield16;

typedef struct {
    unsigned int b0  : 1;
    unsigned int b1  : 1;
    unsigned int b2  : 1;
    unsigned int b3  : 1;
    unsigned int b4  : 1;
    unsigned int b5  : 1;
    unsigned int b6  : 1;
    unsigned int b7  : 1;
} bitfield8;


#endif // _NR_TYPE_H_

