/* ------------------ */
/* --- nralloc1.c --- */
/* ------------------ */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
 * 
 * Distributed under the Boost Software License, Version 1.0
 * see accompanying file LICENSE.txt or copy it at
 * http://www.boost.org/LICENSE_1_0.txt
 */

/*
 * this code is based on the "Numerical Recipes in C 2nd edition" nrutil.c nrutil.h files from
 * William H. Press, Saul A. Teukolsky, William T. Vetterling, Brian P. Flannery
 *
 * The original code is not-copyrighted.
 * The original routines are placed into the public domain
 * (see Appendix B: utility routines, pp 964)
 * for more information, visit http://www.nr.com
*/

/* 
* 2002/06/11 ajout des fonctions endline
*/
#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>
#include <malloc.h>
#include <stdint.h>

#include "nrc_os_config.h"
#include "mypredef.h"
#include "nrtype.h"
#include "nrdef.h"
#include "nrmacro.h"
#include "nrkernel.h"

#include "nralloc1.h"



#undef type_vector
#define type_vector(t)                                              \
t * short_name(t,,vector)(int32_t nl, int32_t nh)                   \
{                                                                   \
    t * v;                                                          \
    v = malloc((nh - nl + 1 + NR_END) * sizeof(t));                 \
    if (v == NULL) {                                                \
        nrerror("*** Error: allocation failure in %s\n", __func__); \
    }                                                               \
    return v - nl + NR_END;                                         \
}

type_vector(int8_t);
type_vector(uint8_t);
type_vector(int16_t);
type_vector(uint16_t);
type_vector(int32_t);
type_vector(uint32_t);
type_vector(int64_t);
type_vector(uint64_t);
type_vector(float);
type_vector(double);
type_vector(void_p);
type_vector(rgb8);
type_vector(rgbx8);
type_vector(rgb32);



#undef type_vector0
#define type_vector0(t)                                             \
t * short_name(t,,vector0)(int32_t nl, int32_t nh)                  \
{                                                                   \
    t * v;                                                          \
    v = calloc((nh - nl + 1 + NR_END), sizeof(t));                  \
    if (v == NULL) {                                                \
        nrerror("*** Error: allocation failure in %s\n", __func__); \
    }                                                               \
    return v - nl + NR_END;                                         \
}

type_vector0(int8_t);
type_vector0(uint8_t);
type_vector0(int16_t);
type_vector0(uint16_t);
type_vector0(int32_t);
type_vector0(uint32_t);
type_vector0(int64_t);
type_vector0(uint64_t);
type_vector0(float);
type_vector0(double);
type_vector0(void_p);
type_vector0(rgb8);
type_vector0(rgbx8);
type_vector0(rgb32);


#undef realloc_type_vector
#define realloc_type_vector(t)                                      \
t * short_name(t,realloc_,vector)(t * v, int32_t nl, int32_t nh)    \
{                                                                   \
    v += nl;                                                        \
    v -= NR_END;                                                    \
    v = realloc(v, (nh - nl + 1 + NR_END) * sizeof(t));             \
    if (v == NULL) {                                                \
        nrerror("*** Error: allocation failure in %s\n", __func__); \
    }                                                               \
    return v - nl + NR_END;                                         \
}


realloc_type_vector(int8_t);
realloc_type_vector(uint8_t);
realloc_type_vector(int16_t);
realloc_type_vector(uint16_t);
realloc_type_vector(int32_t);
realloc_type_vector(uint32_t);
realloc_type_vector(int64_t);
realloc_type_vector(uint64_t);
realloc_type_vector(float);
realloc_type_vector(double);
realloc_type_vector(void_p);
realloc_type_vector(rgb8);
realloc_type_vector(rgbx8);
realloc_type_vector(rgb32);


#undef free_type_vector
#define free_type_vector(t)                               \
void short_name(t,free_,vector)(t * v, long nl, long nh)  \
{                                                         \
    free((FREE_ARG) (v + nl - NR_END));                   \
}

free_type_vector(int8_t);
free_type_vector(uint8_t);
free_type_vector(int16_t);
free_type_vector(uint16_t);
free_type_vector(int32_t);
free_type_vector(uint32_t);
free_type_vector(int64_t);
free_type_vector(uint64_t);
free_type_vector(float);
free_type_vector(double);
free_type_vector(void_p);
free_type_vector(rgb8);
free_type_vector(rgbx8);
free_type_vector(rgb32);




#if TARGET_OS == GIETVM
#undef remote_type_vector
#define remote_type_vector(t)                                                   \
t * short_name(t,remote_,vector)(int32_t nl, int32_t nh, int32_t x, int32_t y)  \
{                                                                               \
    t * v;                                                                      \
    v = remote_malloc((nh - nl + 1 + NR_END) * sizeof(t), x, y);                \
    if (v == NULL) {                                                            \
        nrerror("*** Error: allocation failure in %s\n", __func__);             \
    }                                                                           \
    return v - nl + NR_END;                                                     \
}

remote_type_vector(int8_t);
remote_type_vector(uint8_t);
remote_type_vector(int16_t);
remote_type_vector(uint16_t);
remote_type_vector(int32_t);
remote_type_vector(uint32_t);
remote_type_vector(int64_t);
remote_type_vector(uint64_t);
remote_type_vector(float);
remote_type_vector(double);
remote_type_vector(void_p);
remote_type_vector(rgb8);
remote_type_vector(rgbx8);
remote_type_vector(rgb32);

#endif

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:

// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

