/* --------------- */
/* --- nrio2.c --- */
/* --------------- */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
 * 
 * Distributed under the Boost Software License, Version 1.0
 * see accompanying file LICENSE.txt or copy it at
 * http://www.boost.org/LICENSE_1_0.txt
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "nrc_os_config.h"

#if TARGET_OS == LINUX
    #include <sys/types.h>
    #include <sys/stat.h>
    #include <fcntl.h>
    #include <unistd.h>
#endif


#include "mypredef.h"
#include "nrtype.h"
#include "nrdef.h"
#include "nrmacro.h"
#include "nrkernel.h"

#include "nralloc1.h"
#include "nralloc2.h"
#include "nrio0.h"
#include "nrio1.h"
#include "nrio2.h"

#define isalnum(x) (((x) >= 0x30 && (x) <= 0x39) \
                 || ((x) >= 0x41 && (x) <= 0x5A) \
                 || ((x) >= 0x61 && (x) <= 0x7A))


/*
 * ----------------------
 * --- display_matrix ---
 * ----------------------
 */


#undef display_type_matrix
#define display_type_matrix(t) \
void short_name(t,display_,matrix)(t ** m, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, char * format, char * name) \
{                                              \
    if (name != NULL) {                        \
        printf("%s\n", name);                  \
    }                                          \
                                               \
    for (int32_t i = nrl; i <= nrh; i++) {     \
        for (int32_t j = ncl; j <= nch; j++) { \
            printf(format, m[i][j]);           \
        }                                      \
        printf("\n");                          \
    }                                          \
}

display_type_matrix(int8_t);
display_type_matrix(uint8_t);
display_type_matrix(int16_t);
display_type_matrix(uint16_t);
display_type_matrix(int32_t);
display_type_matrix(uint32_t);
display_type_matrix(int64_t);
display_type_matrix(uint64_t);
display_type_matrix(float);
display_type_matrix(double);


/* -------------------------------------------------------------------------------------------------------- */
void display_rgb8matrix(rgb8 ** m, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, char * format, char * name)
/* -------------------------------------------------------------------------------------------------------- */
{
    if (name != NULL) {
        printf(name);
    }
    
    for (int32_t i = nrl; i <= nrh; i++) {
        for (int32_t j = ncl; j <= nch; j++) {
            printf(format, m[i][j].r, m[i][j].g, m[i][j].b);
        }
        printf("\n");
    }
}

/* ---------------------------------------------------------------------------------------------------------- */
void display_rgbx8matrix(rgbx8 ** m,int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, char * format, char * name)
/* ---------------------------------------------------------------------------------------------------------- */
{
    if (name != NULL) {
        printf(name);
    }
    
    for (int32_t i = nrl; i <= nrh; i++) {
        for (int32_t j = ncl; j <= nch; j++) {
            printf(format, m[i][j].r, m[i][j].g, m[i][j].b, m[i][j].x);
        }
        printf("\n");
    }
}


/*
 * ------------------------
 * --- display_matrix_T ---
 * ------------------------
 */

#undef display_type_matrix_T
#define display_type_matrix_T(t) \
void short_name(t,display_,matrix_T)(t ** m, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, char * format, char * name) \
{                                              \
    if (name != NULL) {                        \
        printf("%s\n", name);                  \
    }                                          \
                                               \
    for (int32_t j = ncl; j <= nch; j++) {     \
        for (int32_t i = nrl; i <= nrh; i++) { \
            printf(format, m[i][j]);           \
        }                                      \
        printf("\n");                          \
    }                                          \
}

display_type_matrix_T(int8_t);
display_type_matrix_T(uint8_t);
display_type_matrix_T(int16_t);
display_type_matrix_T(uint16_t);
display_type_matrix_T(int32_t);
display_type_matrix_T(uint32_t);
display_type_matrix_T(int64_t);
display_type_matrix_T(uint64_t);
display_type_matrix_T(float);
display_type_matrix_T(double);


/* -------------------------------------------------------------------------------------------------------- */
void display_rgb8matrix_T(rgb8 ** m, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, char * format, char * name)
/* -------------------------------------------------------------------------------------------------------- */
{
    if (name != NULL) {
        printf(name);
    }
    
    for (int32_t j = ncl; j <= nch; j++) {
        for (int32_t i = nrl; i <= nrh; i++) {
            printf(format, m[i][j].r, m[i][j].g, m[i][j].b);
        }
        printf("\n");
    }
}

/* ---------------------------------------------------------------------------------------------------------- */
void display_rgbx8matrix_T(rgbx8 ** m,int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, char * format, char * name)
/* ---------------------------------------------------------------------------------------------------------- */
{
    if (name != NULL) {
        printf(name);
    }
    
    for (int32_t j = ncl; j <= nch; j++) {
        for (int32_t i = nrl; i <= nrh; i++) {
            printf(format, m[i][j].r, m[i][j].g, m[i][j].b, m[i][j].x);
        }
        printf("\n");
    }
}



/*
 * -----------------------------
 * --- display_matrix_number ---
 * -----------------------------
 */

#undef display_type_matrix_number
#define display_type_matrix_number(t) \
void short_name(t,display_,matrix_number)(t ** m, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, char * format, char * name) \
{                                              \
    if (name != NULL) {                        \
        printf("%s\n", name);                  \
    }                                          \
    printf("%5c", '#');                        \
    for (int32_t j = ncl; j <= nch; j++) {     \
        printf(format, j);                     \
    }                                          \
    printf("\n");                              \
    for (int32_t i = nrl; i <= nrh; i++) {     \
        printf("[%3d]", i);                    \
        for (int32_t j = ncl; j <= nch; j++) { \
            printf(format, m[i][j]);           \
        }                                      \
        printf("\n");                          \
    }                                          \
    printf("\n");                              \
}

display_type_matrix_number(int8_t);
display_type_matrix_number(uint8_t);
display_type_matrix_number(int16_t);
display_type_matrix_number(uint16_t);
display_type_matrix_number(int32_t);
display_type_matrix_number(uint32_t);
display_type_matrix_number(int64_t);
display_type_matrix_number(uint64_t);
display_type_matrix_number(float);
display_type_matrix_number(double);


/* --------------------------------------------------------------------------------------------------------------- */
void display_rgb8matrix_number(rgb8 ** m, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, char * format, char * name)
/* --------------------------------------------------------------------------------------------------------------- */
{
    if (name != NULL) {
        printf(name);
    }
    // 1ere ligne
    printf("%5c", '#');
    for (int32_t j = ncl; j <= nch; j++) {
        printf(format, j);
    }
    printf("\n");
    for (int32_t i = nrl; i <= nrh; i++) {
        printf("[%3d]", i);
        for (int32_t j = ncl; j <= nch; j++) {
            printf(format, m[i][j].r, m[i][j].g, m[i][j].b);
        }
        printf("\n");
    }
    printf("\n");
}

/* ----------------------------------------------------------------------------------------------------------------- */
void display_rgbx8matrix_number(rgbx8 **m,int32_t nrl,int32_t nrh,int32_t ncl, int32_t nch, char *format, char *name)
/* ----------------------------------------------------------------------------------------------------------------- */
{
    if (name != NULL) {
        printf(name);
    }
    // 1ere ligne
    printf("%5c", '#');
    for (int32_t j = ncl; j <= nch; j++) {
        printf(format, j);
    }
    printf("\n");
    for (int32_t i = nrl; i <= nrh; i++) {
        printf("[%3d]", i);
        for (int32_t j = ncl; j <= nch; j++) {
            printf(format, m[i][j].r, m[i][j].g, m[i][j].b, m[i][j].x);
        }
        printf("\n");
    }
    printf("\n");
}



/*
 * -------------------------------
 * --- display_matrix_positive ---
 * -------------------------------
 */

#if TARGET_OS != GIETVM

#undef display_type_matrix_positive
#define display_type_matrix_positive(t) \
void short_name(t,display_,matrix_positive)(t ** m, int32_t i0, int32_t i1, int32_t j0, int32_t j1, int32_t iformat, char * name) \
{                                                               \
    char * format;                                              \
    char * str;                                                 \
    select_display_positive_parameters(iformat, &format, &str); \
    if (name != NULL) {                                         \
        printf("%s\n", name);                                   \
    }                                                           \
    for (int32_t i = i0; i <= i1; i++) {                        \
        for (int32_t j = j0; j <= j1; j++) {                    \
            if (m[i][j] != 0) {                                 \
                printf(format, m[i][j]);                        \
            }                                                   \
            else {                                              \
                printf("%s", str);                              \
            }                                                   \
        }                                                       \
        printf("\n");                                           \
    }                                                           \
    printf("\n");                                               \
}

#else

#undef display_type_matrix_positive
#define display_type_matrix_positive(t) \
void short_name(t,display_,matrix_positive)(t ** m, int32_t i0, int32_t i1, int32_t j0, int32_t j1, int32_t iformat, char * name) \
{                                                               \
    char * format;                                              \
    char * str;                                                 \
    select_display_positive_parameters(iformat, &format, &str); \
    if (name != NULL) {                                         \
        printf("%s\n", name);                                   \
    }                                                           \
    for (int32_t i = i0; i <= i1; i++) {                        \
        for (int32_t j = j0; j <= j1; j++) {                    \
            if (m[i][j] != 0) {                                 \
                int32_t a = m[i][j];                            \
                int32_t len = 0;                                \
                if (a == 0) {                                   \
                    len = 1;                                    \
                }                                               \
                else {                                          \
                    while (a != 0) {                            \
                        a = a / 10;                             \
                        len++;                                  \
                    }                                           \
                }                                               \
                for (int32_t k = len; k < iformat; k++) {       \
                    printf(" ");                                \
                }                                               \
                printf(format, m[i][j]);                        \
            }                                                   \
            else {                                              \
                printf("%s", str);                              \
            }                                                   \
        }                                                       \
        printf("\n");                                           \
    }                                                           \
    printf("\n");                                               \
}

#endif


display_type_matrix_positive(int8_t);
display_type_matrix_positive(uint8_t);
display_type_matrix_positive(int16_t);
display_type_matrix_positive(uint16_t);
display_type_matrix_positive(int32_t);
display_type_matrix_positive(uint32_t);
display_type_matrix_positive(int64_t);
display_type_matrix_positive(uint64_t);
display_type_matrix_positive(float);
display_type_matrix_positive(double);


/* --------------------------------------- */
static char * readitem(int fd, char * buffer)
/* --------------------------------------- */
{
    char * aux;
    int k;
    int n;
    
    k = 0;
    aux = buffer;
    while (1) {
        n = read(fd, aux, 1);
        if (n == 0) {
            break;
        }
        switch (k) {
            case 0:
                if (*aux == '#') {
                    k = 1;
                }
                if (isalnum(*aux)) {
                    k = 2;
                    aux++;
                }
                break;
            case 1:
                if (*aux == 0xA) {
                    k = 0;
                }
                break;
            case 2:
                if (!isalnum(*aux)) {
                    *aux = 0;
                    return buffer;
                }
                aux++;
                break;
        }
    }
    *aux = 0;
    return buffer;
}


/* ------------------------------------------------- */
static void ReadPGMrow(int32_t fd, int32_t width, uint8 * line)
/* ------------------------------------------------- */
{
    read(fd, &line[0], sizeof(uint8_t) * width);
}


/* -------------------------------------------------- */
static void WritePGMrow(uint8_t * line, int32_t width, int32_t fd)
/* -------------------------------------------------- */
{
    write(fd, &line[0], sizeof(uint8_t) * width);
}


/* ----------------------------------------------------------------------------------------------- */
uint8_t ** LoadPGM_ui8matrix(char * filename, int * nrl, int * nrh, int * ncl, int * nch)
/* ----------------------------------------------------------------------------------------------- */
{
    // only for P5 binary type, not for text type
    
    int32_t height, width, gris;
    uint8_t ** m;
    int32_t fd;
    
    char buffer[80];
    (void) gris;
    
    // open file
    fd = open(filename, O_RDONLY);
    if (fd < 0) {
        printf("\n*** Error: Can't open file %s in %s.\n", filename, __func__);
        exit(1);
    }
    
    // read PGM header
    readitem(fd, &buffer[0]);
    if (strcmp(&buffer[0], "P5") != 0) {
        printf("*** Error: Invalid file header in file %s\n", filename);
    }
    
    width  = atoi(readitem(fd, &buffer[0]));
    height = atoi(readitem(fd, &buffer[0]));
    gris   = atoi(readitem(fd, &buffer[0]));
    
    *nrl = 0;
    *nrh = height - 1;
    *ncl = 0;
    *nch = width - 1;
    m = ui8matrix(*nrl, *nrh, *ncl, *nch);
    
    for (int32_t i = 0; i < height; i++) {
        ReadPGMrow(fd, width, m[i]);
    }
    
    close(fd);
    
    return m;
}


/* ----------------------------------------------------------------------------------------------- */
void SavePGM_ui8matrix(uint8 ** m, int nrl, int nrh, int ncl, int nch, char * filename)
/* ----------------------------------------------------------------------------------------------- */
{
    int32_t nrow = nrh - nrl + 1;
    int32_t ncol = nch - ncl + 1;
    
    char buffer[80];
    
    int32_t fd;
    
    //fd = open(filename, O_WRONLY | O_TRUNC | O_CREAT);
    fd = open(filename, O_TRUNC | O_CREAT);
    if (fd < 0) {
        printf("\n*** Error: Impossible to open file %s in %s\n", filename, __func__);
        return;
    }
    
    /* enregistrement de l'image au format rpgm */
    snprintf(buffer, 80, "P5\n%d %d\n255\n", ncol, nrow);
    write(fd, buffer, strlen(buffer));
    for (int32_t i = nrl; i <= nrh; i++) {
        WritePGMrow(m[i], ncol, fd);
    }
    
    /* fermeture du fichier */
    close(fd);
}



// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:

// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

