#!/dsk/l1/misc/meunier/tools/bin/python3
# -*- coding: utf-8 -*-

# Note:
# This code requires python 3, and I haven't found
# a proper way of mixing python 2 and 3 without using
# the she/bang line at the top, which includes a local
# path...

from __future__ import print_function
import os
import sys
import re
import subprocess
import shutil
import filecmp
import random

from stack import Stack

from common import *


use_rand_images = True
with_features = True

threads = [1, 2, 4]
nb_step = 0
use_dsk = True
img_size = 1024
granularity = 1
rand_seed = 7

top_path = os.path.abspath(os.path.join(os.path.dirname(os.path.realpath(__file__)), ".."))
scripts_path  = os.path.join(top_path, 'scripts')
pyconf_file   = os.path.join(scripts_path, "config.py")

base_data_dir  = "data"    # For timing information extracted
base_graph_dir = "graphes" # For storing generated graphes


# Each of these configuration must have been run with both features activated and deactivated
configs = [
        {'SLOW':'1', 'FAST':'0', 'PARMERGE':'0', 'ARSP':'0'},
        {'SLOW':'0', 'FAST':'1', 'PARMERGE':'0', 'ARSP':'0'},
        #{'SLOW':'1', 'FAST':'0', 'PARMERGE':'0', 'ARSP':'0'},
        #{'SLOW':'0', 'FAST':'1', 'PARMERGE':'0', 'ARSP':'0'},
        #{'SLOW':'0', 'FAST':'1', 'PARMERGE':'1', 'ARSP':'0'},
        #{'SLOW':'0', 'FAST':'1', 'PARMERGE':'1', 'ARSP':'1'},
]


# Loading config file
with open(pyconf_file) as f:
    code = compile(f.read(), pyconf_file, 'exec')
    exec(code)

if use_dsk:
    try:
        dsk_dir
        if not os.path.exists(dsk_dir):
            print("*** Warning: variable dsk_dir is not defined in %s file; using current directory for reading data files" % (short_path(pyconf_file)))
            use_dsk = False
    except OSError:
        print("*** Warning: directory %s does not exist; using current directory for reading data files" % (dsk_dir))
        use_dsk = False

# Updating output directories
if use_dsk:
    data_dir     = os.path.join(dsk_dir, base_data_dir)
    graph_dir    = os.path.join(dsk_dir, base_graph_dir)
else:
    data_dir   = os.path.join(scripts_path, base_data_dir)
    graph_dir  = os.path.join(scripts_path, base_graph_dir)



if not os.path.exists(graph_dir):
    my_mkdir(graph_dir)



if with_features:
    features = ["FT", "NF"] # Features and No-Features
else:
    features = ["NF"] # No features only


exec_time = {}
for config in configs:
    fconfig = frozenset(config.items())
    exec_time[fconfig] = {}
    for thread in threads:
        exec_time[fconfig][thread] = {}
        for ftrs in features: # Features or No features
            exec_time[fconfig][thread][ftrs] = {}
            for density in range(0, 101):
                exec_time[fconfig][thread][ftrs][density] = {}
                random_img_file = get_random_img_file(density, img_size, img_size, granularity, rand_seed)
                img_basename = os.path.splitext(random_img_file)[0]
                log_file = get_filename(data_dir, thread, config, ftrs == "FT", img_basename)
                lines = open(log_file, 'r')
                for line in lines:
                    tokens = line.split()
                    if len(tokens) == 0:
                        continue
                    tag = tokens[0]
                    pattern = re.compile('\[STEP_([0-9]+)\]')
                    match = pattern.match(tag)
                    if match:
                        step = int(match.group(1))
                        nb_step = max(int(step) + 1, nb_step)
                        value = tokens[len(tokens) - 1]
                        exec_time[fconfig][thread][ftrs][density][step] = value
                        #print("exec_time[fconfig][%d][%s][%d][%s] = %s" % (thread, ftrs, density, step, exec_time[fconfig][thread][ftrs][density][step]))

                    


for config in configs:
    fconfig = frozenset(config.items())
    for thread in threads:
        plotter = Stack(["red", "blue", "#CAFE01", "#CA01FE", "#01CAFE"], "Légende", "X", "Y")
        X = [x for x in range(0, 101)]
        plotter.add_x(X)
        assert(nb_step == 4)
        YPAR1 = [float(exec_time[fconfig][thread]["NF"][density][0]) for density in range(0, 101)] # Parallel Labeling
        YPAR2 = [float(exec_time[fconfig][thread]["NF"][density][1]) for density in range(0, 101)] # Merging (Parallel or Pyramidal)
        YPTC2 = [float(exec_time[fconfig][thread]["NF"][density][2]) for density in range(0, 101)] # Parallel Transitive Closure
        YPAR3 = [float(exec_time[fconfig][thread]["NF"][density][3]) for density in range(0, 101)] # Parallel Relabeling

        plotter.add_y(YPAR1)
        plotter.add_y(YPAR2)
        plotter.add_y(YPTC2)
        # Not displaying PAR3

        if with_features:
            YPAR1f = [float(exec_time[fconfig][thread]["FT"][density][0]) for density in range(0, 101)] # Parallel Labeling
            YPAR2f = [float(exec_time[fconfig][thread]["FT"][density][1]) for density in range(0, 101)] # Merging (Parallel or Pyramidal)
            deltaYPAR1 = [max(0, x - y) for x, y in zip (YPAR1f, YPAR1)]
            deltaYPAR2 = [max(0, x - y) for x, y in zip (YPAR2f, YPAR2)]
            YFTC = [x + y for x, y in zip (deltaYPAR1, deltaYPAR2)] # Features Computation
            plotter.add_y(YFTC)

        plotter.plot()
        graph_name = get_graph_filename(graph_dir, thread, config, ".pdf")
        print("# Creating graph %s" % short_path(graph_name))
        plotter.save(graph_name)






