/* ----------------- */
/* --- nrbool2.c --- */
/* ----------------- */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
 *
 * Distributed under the Boost Software License, Version 1.0
 * see accompanying file LICENSE.txt or copy it at
 * http://www.boost.org/LICENSE_1_0.txt
 */


#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>
#include <math.h>
#include <stdbool.h>

#include "nrc_os_config.h"
#include "mypredef.h"
#include "nrtype.h"
#include "nrdef.h"
#include "nrmacro.h"
#include "nrkernel.h"

#include "nrbool1.h"
#include "nrbool2.h"


#undef cmpeq_type_matrix
#define cmpeq_type_matrix(t) \
int32_t short_name(t,cmpeq_,matrix)(t ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, t ** Y) \
{                                              \
    for (int32_t i = nrl; i <= nrh; i++) {     \
        for (int32_t j = ncl; j <= nch; j++) { \
            if (X[i][j] != Y[i][j]) {          \
                return 1;                      \
            }                                  \
        }                                      \
    }                                          \
    return 0;                                  \
}

cmpeq_type_matrix(int8_t);
cmpeq_type_matrix(uint8_t);
cmpeq_type_matrix(int16_t);
cmpeq_type_matrix(uint16_t);
cmpeq_type_matrix(int32_t);
cmpeq_type_matrix(uint32_t);
cmpeq_type_matrix(int64_t);
cmpeq_type_matrix(uint64_t);



/*
 * -----------
 * --- Not ---
 * -----------
 */

#undef not_type_matrix
#define not_type_matrix(t) \
void short_name(t,not_,matrix)(t ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, t ** Y) \
{                                                        \
    for (int32_t i = nrl; i <= nrh; i++) {               \
        short_name(t,not_,vector)(X[i], ncl, nch, Y[i]); \
    }                                                    \
}

not_type_matrix(int8_t);
not_type_matrix(uint8_t);
not_type_matrix(int16_t);
not_type_matrix(uint16_t);
not_type_matrix(int32_t);
not_type_matrix(uint32_t);
not_type_matrix(int64_t);
not_type_matrix(uint64_t);
not_type_matrix(rgb8);
not_type_matrix(rgbx8);



/*
 * ----------
 * --- Or ---
 * ----------
 */

#undef or_type_matrix
#define or_type_matrix(t) \
void short_name(t,or_,matrix)(t ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, t ** Y, t ** Z) \
{                                                             \
    for (int32_t i = nrl; i <= nrh; i++) {                    \
        short_name(t,or_,vector)(X[i], ncl, nch, Y[i], Z[i]); \
    }                                                         \
}                                                             \
void short_name(t,orc_,matrix)(t ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, t y, t ** Z) \
{                                                             \
    for (int32_t i = nrl; i <= nrh; i++) {                    \
        short_name(t,orc_,vector)(X[i], ncl, nch, y, Z[i]);   \
    }                                                         \
}

or_type_matrix(int8_t);
or_type_matrix(uint8_t);
or_type_matrix(int16_t);
or_type_matrix(uint16_t);
or_type_matrix(int32_t);
or_type_matrix(uint32_t);
or_type_matrix(int64_t);
or_type_matrix(uint64_t);
or_type_matrix(rgb8);
or_type_matrix(rgbx8);


/*
 * -----------
 * --- Xor ---
 * -----------
 */

#undef xor_type_matrix
#define xor_type_matrix(t) \
void short_name(t,xor_,matrix)(t ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, t ** Y, t ** Z) \
{                                                              \
    for (int32_t i = nrl; i <= nrh; i++) {                     \
        short_name(t,xor_,vector)(X[i], ncl, nch, Y[i], Z[i]); \
    }                                                          \
}                                                              \
void short_name(t,xorc_,matrix)(t ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, t y, t ** Z) \
{                                                              \
    for (int32_t i = nrl; i <= nrh; i++) {                     \
        short_name(t,xorc_,vector)(X[i], ncl, nch, y, Z[i]);   \
    }                                                          \
}

xor_type_matrix(int8_t);
xor_type_matrix(uint8_t);
xor_type_matrix(int16_t);
xor_type_matrix(uint16_t);
xor_type_matrix(int32_t);
xor_type_matrix(uint32_t);
xor_type_matrix(int64_t);
xor_type_matrix(uint64_t);
xor_type_matrix(rgb8);
xor_type_matrix(rgbx8);


/*
 * ----------
 * --- And ---
 * ----------
 */

#undef and_type_matrix
#define and_type_matrix(t) \
void short_name(t,and_,matrix)(t ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, t ** Y, t ** Z) \
{                                                              \
    for (int32_t i = nrl; i <= nrh; i++) {                     \
        short_name(t,and_,vector)(X[i], ncl, nch, Y[i], Z[i]); \
    }                                                          \
}                                                              \
void short_name(t,andc_,matrix)(t ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, t y, t ** Z) \
{                                                              \
    for (int32_t i = nrl; i <= nrh; i++) {                     \
        short_name(t,andc_,vector)(X[i], ncl, nch, y, Z[i]);   \
    }                                                          \
}

and_type_matrix(int8_t);
and_type_matrix(uint8_t);
and_type_matrix(int16_t);
and_type_matrix(uint16_t);
and_type_matrix(int32_t);
and_type_matrix(uint32_t);
and_type_matrix(int64_t);
and_type_matrix(uint64_t);
and_type_matrix(rgb8);
and_type_matrix(rgbx8);


// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:

// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

