/* ---------------- */
/* --- nrio1x.c --- */
/* ---------------- */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
 */

#include <stdlib.h>
#include <stdio.h>

#include "nrc_os_config.h"
#include "mypredef.h"
#include "nrtype.h"
#include "nrdef.h"
#include "nrkernel.h"
#include "nrmacro.h"

#include "nralloc1.h"
#include "nrio1x.h"

#undef display_type_vector_circular
#define display_type_vector_circular(t) \
void short_name(t,display_,vector_circular)(t * v, int32_t nl, int32_t nh, int32_t c0, int32_t c1, char * format, char * name) \
{                                        \
    int32_t n = nh - nl + 1;             \
    if (name != NULL) {                  \
        printf("%s\n", name);            \
    }                                    \
    for (int32_t i = c0; i <= c1; i++) { \
        printf(format, v[i % n + nl]);   \
    }                                    \
    printf("\n");                        \
}


display_type_vector_circular(int8_t);
display_type_vector_circular(uint8_t);
display_type_vector_circular(int16_t);
display_type_vector_circular(uint16_t);
display_type_vector_circular(int32_t);
display_type_vector_circular(uint32_t);
display_type_vector_circular(int64_t);
display_type_vector_circular(uint64_t);
display_type_vector_circular(float);
display_type_vector_circular(double);



#undef display_type_vector_circular_number
#define display_type_vector_circular_number(t) \
void short_name(t,display_,vector_circular_number)(t * v, int32_t nl, int32_t nh, int32_t c0, int32_t c1, char * format, char * name) \
{                                        \
    int32_t n = nh - nl + 1;             \
    if (name != NULL) {                  \
        printf("%s", name);              \
    }                                    \
    printf("#");                         \
    for (int32_t i = c0; i <= c1; i++) { \
        printf(format, i % n + nl);      \
    }                                    \
    printf("\n ");                       \
    for (int32_t i = c0; i <= c1; i++) { \
        printf(format, v[i % n + nl]);   \
    }                                    \
    printf("\n");                        \
}


display_type_vector_circular_number(int8_t);
display_type_vector_circular_number(uint8_t);
display_type_vector_circular_number(int16_t);
display_type_vector_circular_number(uint16_t);
display_type_vector_circular_number(int32_t);
display_type_vector_circular_number(uint32_t);
display_type_vector_circular_number(int64_t);
display_type_vector_circular_number(uint64_t);
display_type_vector_circular_number(float);
display_type_vector_circular_number(double);



#undef display_type_vector_cycle
#define display_type_vector_cycle(t) \
void short_name(t,display_,vector_cycle)(t * v, int32_t nl, int32_t nh, char * format, char * name) \
{                                        \
    uint8_t first;                       \
    uint8_t next;                        \
    uint8_t * displayed;                 \
                                         \
    if (name != NULL) {                  \
        printf("%s", name);              \
    }                                    \
    displayed = ui8vector0(nl, nh);      \
    for (int32_t i = nl; i <= nh; i++) { \
        if (!displayed[i]) {             \
            displayed[i] = 1;            \
            printf(format, i);           \
            first = (t) i;               \
            next = v[i];                 \
            while (first != next) {      \
                displayed[next] = 1;     \
                printf(format, next);    \
                next = v[next];          \
            }                            \
            printf("\n");                \
        }                                \
    }                                    \
    printf("\n");                        \
    free_ui8vector(displayed, nl, nh);   \
}


display_type_vector_cycle(int8_t);
display_type_vector_cycle(uint8_t);
display_type_vector_cycle(int16_t);
display_type_vector_cycle(uint16_t);
display_type_vector_cycle(int32_t);
display_type_vector_cycle(uint32_t);
display_type_vector_cycle(int64_t);
display_type_vector_cycle(uint64_t);
display_type_vector_cycle(float);
display_type_vector_cycle(double);


// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:

// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

