/* --------------- */
/* --- nrio1.h --- */
/* --------------- */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
*/

#ifndef _NR_IO1_H_
#define _NR_IO1_H_

/*
 * -----------------------------------------------------------------------------------
 * --- display_vector + display_vector_number + display_vector_T + vector_number_T ---
 * -----------------------------------------------------------------------------------
 */

#define display_type_vector(t) \
void short_name(t,display_,vector)(t * v, int32_t nl, int32_t nh, char * format, char * name); \
void short_name(t,display_,vector_number)(t * v, int32_t nl, int32_t nh, char * format, char * name); \
void short_name(t,display_,vector_T)(t * v, int32_t i0, int32_t i1, char * format, char * name); \
void short_name(t,display_,vector_number_T)(t * v, int32_t i0, int32_t i1, char * format, char * name)

display_type_vector(int8_t);
display_type_vector(uint8_t);
display_type_vector(int16_t);
display_type_vector(uint16_t);
display_type_vector(int32_t);
display_type_vector(uint32_t);
display_type_vector(int64_t);
display_type_vector(uint64_t);
display_type_vector(float);
display_type_vector(double);
display_type_vector(rgb8);
display_type_vector(rgbx8);


/*
 * -------------------------------
 * --- display_vector_positive ---
 * -------------------------------
 */

#undef display_type_vector_positive
#define display_type_vector_positive(t) \
void short_name(t,display_,vector_positive)(t * v, int32_t j0, int32_t j1, int32_t iformat, char * name)

display_type_vector_positive(int8_t);
display_type_vector_positive(uint8_t);
display_type_vector_positive(int16_t);
display_type_vector_positive(uint16_t);
display_type_vector_positive(int32_t);
display_type_vector_positive(uint32_t);
display_type_vector_positive(int64_t);
display_type_vector_positive(uint64_t);
display_type_vector_positive(float);
display_type_vector_positive(double);

 
/*
 * --------------------
 * --- write_vector ---
 * --- write_vector_T ---
 * --- write_vector_number ---
 * --- write_vector_T_number ---
 * --- fread_vector ---
 * --- fwrite_vector ---
 * --------------------
 */

#define write_type_vector(t) \
void short_name(t,write_,vector)(t * v, int32_t nl, int32_t nh, char * format, char * filename); \
void short_name(t,write_,vector_T)(t * v, int32_t nl, int32_t nh, char * format, char * filename); \
void short_name(t,write_,vector_number)(t * v, int32_t nl, int32_t nh, char * format, char * filename); \
void short_name(t,write_,vector_T_number)(t * v, int32_t nl, int32_t nh, char * format, char * filename); \
void short_name(t,fread_,vector)(char * filename, t * v, int32_t nl, int32_t nh); \
void short_name(t,fwrite_,vector)(t * v, int32_t nl, int32_t nh, char * filename) \

write_type_vector(int8_t);
write_type_vector(uint8_t);
write_type_vector(int16_t);
write_type_vector(uint16_t);
write_type_vector(int32_t);
write_type_vector(uint32_t);
write_type_vector(int64_t);
write_type_vector(uint64_t);
write_type_vector(float);
write_type_vector(double);
write_type_vector(rgb8);
write_type_vector(rgbx8);


#endif // _NR_IO1_H_

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:

// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

