/* ----------------- */
/* --- nrio1fx.c --- */
/* ----------------- */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
 */

#include <stdlib.h>
#include <stdio.h>

#include "nrc_os_config.h"
#include "mypredef.h"
#include "nrtype.h"
#include "nrdef.h"
#include "nrkernel.h"
#include "nrmacro.h"

#include "nralloc1.h"
#include "nrio1x.h"


/* --------------------------- */
/* -- write_vector_circular -- */
/* --------------------------- */

#undef write_type_vector_circular
#define write_type_vector_circular(t) \
void short_name(t,write_,vector_circular)(t * v, int32_t nl, int32_t nh, int32_t c0, int32_t c1, char * format, char * filename) \
{                                                                  \
    int32_t n = nh - nl + 1;                                       \
    FILE * f = fopen(filename, "wt");                              \
    if (f == NULL) {                                               \
        nrerror("Can't open file %s in %s\n", filename, __func__); \
    }                                                              \
    for (int32_t i = c0; i <= c1; i++) {                           \
        fprintf(f, format, v[i % n + nl]);                         \
    }                                                              \
    fprintf(f, "\n");                                              \
    fclose(f);                                                     \
}

write_type_vector_circular(int8_t);
write_type_vector_circular(uint8_t);
write_type_vector_circular(int16_t);
write_type_vector_circular(uint16_t);
write_type_vector_circular(int32_t);
write_type_vector_circular(uint32_t);
write_type_vector_circular(int64_t);
write_type_vector_circular(uint64_t);
write_type_vector_circular(float);
write_type_vector_circular(double);



// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:

// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

