#!/dsk/l1/misc/meunier/tools/bin/python3
# -*- coding: utf-8 -*-

import matplotlib
matplotlib.use('PDF')
import matplotlib.pyplot as plt
from matplotlib.ticker import MultipleLocator

class Stack:
    def __init__(self, couleurs, title, label_X, label_Y):
        self.xlabel = label_X
        self.ylabel = label_Y
        self.title = title
        self.couleurs = couleurs
        self.actual_colors = []
        self.color_index = 0
        self.dataset = []
        self.X = []
        #self.clear()
        self.init_picture()

    def add_y(self, data):
        self.dataset.append(data)
        self.actual_colors.append(self.couleurs[self.get_color()])

    def add_x(self, data):
        self.X = data


    def init_picture(self):
        plt.clf() # Clear previous figure
        textcolor = '#000000'
        plt.rcParams['font.family'] = 'serif'
        plt.rcParams['font.size'] = 10

        plt.rcParams['mathtext.fontset'] = 'cm'
        plt.rcParams['mathtext.fallback_to_cm'] = True
        plt.rcParams['mathtext.default'] = 'regular'
        plt.rcParams['mathtext.default'] = 'sf'
        
        plt.rcParams['lines.linewidth'] = '1'
        plt.rcParams['lines.antialiased'] = True

        plt.rcParams['text.latex.unicode'] = True
        plt.rcParams['text.color'] = textcolor
        plt.rcParams['text.hinting'] = 'auto'
        plt.rcParams['axes.labelcolor'] = textcolor
        plt.rcParams['axes.edgecolor'] = textcolor # couleur du cadre
        plt.rcParams['axes.facecolor'] = '#FFFFFF' # couleur du fond
        plt.rcParams['axes.linewidth'] = '0.1'
        #plt.rcParams['ytick.major.pad'] = 8

        plt.rcParams['grid.color'] = textcolor
        plt.rcParams['grid.alpha'] = '0.1'
        plt.rcParams['grid.linestyle'] = ':'
        plt.rcParams['grid.linewidth'] = '0.1'
        plt.rcParams['xtick.direction'] = 'in'
        plt.rcParams['ytick.direction'] = 'in'
        plt.rcParams['xtick.color'] = textcolor
        plt.rcParams['ytick.color'] = textcolor
        plt.rcParams['xtick.major.size'] = 6
        plt.rcParams['ytick.major.size'] = 6
        plt.rcParams['xtick.minor.size'] = 3
        plt.rcParams['ytick.minor.size'] = 3
        plt.rcParams['legend.fancybox'] = True
        plt.rcParams['xtick.major.pad'] = 4
        plt.rcParams['ytick.major.pad'] = 12
        plt.rcParams['figure.figsize'] = 7,4
        
        axes = plt.gca()
        axes.set_xlim([0, 100])
        plt.axes().xaxis.set_tick_params(width = 0.1)
        plt.axes().yaxis.set_tick_params(width = 0.1)
        
        plt.grid(True)
        self.draw_labels()


    def draw_labels(self):
        plt.xlabel(self.xlabel)
        plt.ylabel(self.ylabel)
        pass

    def draw_title(self):
        plt.title(self.title)
        pass

    def plot(self):
        plt.stackplot(self.X, self.dataset, colors = self.actual_colors)

    def save(self, filename):
        plt.savefig(filename, bbox_inches = 'tight')

    def get_color(self):
        color_index = self.color_index
        self.color_index = (self.color_index + 1) % len(self.couleurs)
        return color_index

    def clear(self):
        # Other options to explore
        #plt.clf()
        #self.color_index = 0
        #yminorLocator   = MultipleLocator(5)
        #xmajorLocator   = MultipleLocator(10)
        #xminorLocator   = MultipleLocator(1)

        #plt.axes().yaxis.set_minor_locator(yminorLocator)
        #plt.axes().yaxis.set_label_position('left')
        #plt.axes().xaxis.set_minor_locator(xminorLocator)
        #plt.axes().xaxis.set_major_locator(xmajorLocator)
        #ylabel = plt.axes().yaxis.get_label()
        #ylabel.set_va('baseline')
        #ylabel.set_ha('center')
        #plt.grid(True)
        #self.draw_labels()
        #self.draw_title()    
        pass
