/* ----------------- */
/* --- nrbool2.h --- */
/* ----------------- */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
*/

#ifndef _NR_BOOL2_H_
#define _NR_BOOL2_H_

#include "nrc_os_config.h"


#define cmpeq_type_matrix(t) \
int32_t short_name(t,cmpeq_,matrix)(t ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, t ** Y)

cmpeq_type_matrix(int8_t);
cmpeq_type_matrix(uint8_t);
cmpeq_type_matrix(int16_t);
cmpeq_type_matrix(uint16_t);
cmpeq_type_matrix(int32_t);
cmpeq_type_matrix(uint32_t);
cmpeq_type_matrix(int64_t);
cmpeq_type_matrix(uint64_t);


/*
 * -----------
 * --- Not ---
 * -----------
 */

#define not_type_matrix(t) \
void short_name(t,not_,matrix)(t ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, t ** Y)

not_type_matrix(int8_t);
not_type_matrix(uint8_t);
not_type_matrix(int16_t);
not_type_matrix(uint16_t);
not_type_matrix(int32_t);
not_type_matrix(uint32_t);
not_type_matrix(int64_t);
not_type_matrix(uint64_t);
not_type_matrix(rgb8);
not_type_matrix(rgbx8);


/*
 * ----------
 * --- Or ---
 * ----------
 */

#define or_type_matrix(t) \
void short_name(t,or_,matrix)(t ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, t ** Y, t ** Z); \
void short_name(t,orc_,matrix)(t ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, t y, t ** Z)

or_type_matrix(int8_t);
or_type_matrix(uint8_t);
or_type_matrix(int16_t);
or_type_matrix(uint16_t);
or_type_matrix(int32_t);
or_type_matrix(uint32_t);
or_type_matrix(int64_t);
or_type_matrix(uint64_t);
or_type_matrix(rgb8);
or_type_matrix(rgbx8);


/*
 * -----------
 * --- Xor ---
 * -----------
 */

#define xor_type_matrix(t) \
void short_name(t,xor_,matrix)(t ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, t ** Y, t ** Z); \
void short_name(t,xorc_,matrix)(t ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, t y, t ** Z)

xor_type_matrix(int8_t);
xor_type_matrix(uint8_t);
xor_type_matrix(int16_t);
xor_type_matrix(uint16_t);
xor_type_matrix(int32_t);
xor_type_matrix(uint32_t);
xor_type_matrix(int64_t);
xor_type_matrix(uint64_t);
xor_type_matrix(rgb8);
xor_type_matrix(rgbx8);


/*
 * ----------
 * --- And ---
 * ----------
 */

#define and_type_matrix(t) \
void short_name(t,and_,matrix)(t ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, t ** Y, t ** Z); \
void short_name(t,andc_,matrix)(t ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, t y, t ** Z)

and_type_matrix(int8_t);
and_type_matrix(uint8_t);
and_type_matrix(int16_t);
and_type_matrix(uint16_t);
and_type_matrix(int32_t);
and_type_matrix(uint32_t);
and_type_matrix(int64_t);
and_type_matrix(uint64_t);
and_type_matrix(rgb8);
and_type_matrix(rgbx8);


#endif // _NR_BOOL2_H_

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:

// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

