/* --------------- */
/* --- nrio2.h --- */
/* --------------- */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
*/

#ifndef _NR_IO2_H_
#define _NR_IO2_H_


/*
 * ----------------------
 * --- display_matrix ---
 * --- display_matrix_T ---
 * --- display_matrix_number ---
 * --- display_matrix_positive ---
 * ----------------------
 */

#define display_type_matrix(t) \
void short_name(t,display_,matrix)(t ** m, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, char * format, char * name); \
void short_name(t,display_,matrix_T)(t ** m, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, char * format, char * name); \
void short_name(t,display_,matrix_number)(t ** m, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, char * format, char * name); \
void short_name(t,display_,matrix_positive)(t ** m, int32_t i0, int32_t i1, int32_t j0, int32_t j1, int32_t iformat, char * name)


display_type_matrix(int8_t);
display_type_matrix(uint8_t);
display_type_matrix(int16_t);
display_type_matrix(uint16_t);
display_type_matrix(int32_t);
display_type_matrix(uint32_t);
display_type_matrix(int64_t);
display_type_matrix(uint64_t);
display_type_matrix(float);
display_type_matrix(double);
display_type_matrix(rgb8);
display_type_matrix(rgbx8);


/*
 * --------------------
 * --- write_matrix ---
 * --- write_matrix_T ---
 * --- write_matrix_number ---
 * --- write_matrix_T_number ---
 * --- fwrite_matrix ---
 * --- fread_matrix ---
 * --------------------
 */

#define write_type_matrix(t) \
void short_name(t,write_,matrix)(t ** m, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, char * format, char * filename); \
void short_name(t,write_,matrix_T)(t ** m, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, char * format, char * filename); \
void short_name(t,write_,matrix_number)(t ** m, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, char * format, char * filename); \
void short_name(t,write_,matrix_T_number)(t ** m, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, char * format, char * filename); \
void short_name(t,fwrite_,matrix)(t ** m, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, char * filename); \
void short_name(t,fread_,matrix)(char * filename, t ** m, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch)  \

write_type_matrix(int8_t);
write_type_matrix(uint8_t);
write_type_matrix(int16_t);
write_type_matrix(uint16_t);
write_type_matrix(int32_t);
write_type_matrix(uint32_t);
write_type_matrix(int64_t);
write_type_matrix(uint64_t);
write_type_matrix(float);
write_type_matrix(double);
write_type_matrix(rgb8);
write_type_matrix(rgbx8);


// -------------------------------
// --- write_matrix_positive ---
// -------------------------------

#define write_type_matrix_positive(t) \
void short_name(t,write_,matrix_positive)(t ** m, int32_t i0, int32_t i1, int32_t j0, int32_t j1, int32_t iformat, char * filename)

write_type_matrix_positive(uint8_t);
write_type_matrix_positive(uint16_t);
write_type_matrix_positive(uint32_t);

/* ------------------------ */
/* -- PGM IO for bmatrix -- */
/* ------------------------ */

uint8_t ** LoadPGM_ui8matrix  (char * filename, int32_t * nrl, int32_t * nrh, int32_t * ncl, int32_t * nch);
void       LoadPGM_ui8matrix2 (char * filename, int32_t * nrl, int32_t * nrh, int32_t * ncl, int32_t * nch, uint8_t ** m);
rgb8 **    LoadPPM_rgb8matrix (char * filename, int32_t * nrl, int32_t * nrh, int32_t * ncl, int32_t * nch);
void       LoadPPM_rgb8matrix2(char * filename, int32_t * nrl, int32_t * nrh, int32_t * ncl, int32_t * nch, rgb8 ** m);

void MLoadPGM_ui8matrix(char * filename, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, uint8 ** m);
void SavePGM_ui8matrix    (uint8_t ** m, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, char * filename);
void SavePPM_rgb8matrix      (rgb8 ** m, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, char * filename);



#endif // _NR_IO2_H_

