/* ----------------- */
/* --- nrbool1.c --- */
/* ----------------- */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
 *
 * Distributed under the Boost Software License, Version 1.0
 * see accompanying file LICENSE.txt or copy it at
 * http://www.boost.org/LICENSE_1_0.txt
 */

#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>
#include <math.h> // fabs

#include "nrc_os_config.h"
#include "mypredef.h"
#include "nrtype.h"
#include "nrdef.h"
#include "nrmacro.h"
#include "nrkernel.h"

#include "nrbool1.h"

/*
 * -----------
 * --- Not ---
 * -----------
 */

#undef not_type_vector
#define not_type_vector(t) \
void short_name(t,not_,vector)(t * X, int32_t ncl, int32_t nch, t * Y) \
{                                          \
	for (int32_t j = ncl; j <= nch; j++) { \
		Y[j] = ~X[j];                      \
	}                                      \
}

not_type_vector(int8_t);
not_type_vector(uint8_t);
not_type_vector(int16_t);
not_type_vector(uint16_t);
not_type_vector(int32_t);
not_type_vector(uint32_t);
not_type_vector(int64_t);
not_type_vector(uint64_t);


/* ----------------------------------------------------------------- */
void not_rgb8vector(rgb8 * X, int32_t ncl, int32_t nch, rgb8 * Y)
/* ----------------------------------------------------------------- */
{
	for (int32_t j = ncl; j <= nch; j++) {
        RGB8_NOT(X[j], Y[j]);
	}
}

/* -------------------------------------------------------------------- */
void not_rgbx8vector(rgbx8 * X, int32_t ncl, int32_t nch, rgbx8 * Y)
/* -------------------------------------------------------------------- */
{
	for (int32_t j = ncl; j <= nch; j++) {
        RGBX8_NOT(X[j], Y[j]);
	}
}

/*
 * -----------
 * --- Or ---
 * -----------
 */

#undef or_type_vector
#define or_type_vector(t) \
void short_name(t,or_,vector)(t * X, int32_t ncl, int32_t nch, t * Y, t * Z) \
{                                          \
	for (int32_t j = ncl; j <= nch; j++) { \
		Z[j] = X[j] | Y[j];                \
	}                                      \
}

or_type_vector(int8_t);
or_type_vector(uint8_t);
or_type_vector(int16_t);
or_type_vector(uint16_t);
or_type_vector(int32_t);
or_type_vector(uint32_t);
or_type_vector(int64_t);
or_type_vector(uint64_t);


/* ------------------------------------------------------------------------- */
void or_rgb8vector(rgb8 * X, int32_t ncl, int32_t nch, rgb8 * Y, rgb8 * Z)
/* ------------------------------------------------------------------------- */
{
	for (int32_t j = ncl; j <= nch; j++) {
        RGB8_OR(X[j], Y[j], Z[j]);
	}
}
/* ----------------------------------------------------------------------------- */
void or_rgbx8vector(rgbx8 * X, int32_t ncl, int32_t nch, rgbx8 * Y, rgbx8 * Z)
/* ----------------------------------------------------------------------------- */
{
	for (int32_t j = ncl; j <= nch; j++) {
        RGBX8_OR(X[j], Y[j], Z[j]);
	}
}


#undef orc_type_vector
#define orc_type_vector(t) \
void short_name(t,orc_,vector)(t * X, int32_t ncl, int32_t nch, t y, t * Z) \
{                                          \
	for (int32_t j = ncl; j <= nch; j++) { \
		Z[j] = X[j] | y;                   \
	}                                      \
}

orc_type_vector(int8_t);
orc_type_vector(uint8_t);
orc_type_vector(int16_t);
orc_type_vector(uint16_t);
orc_type_vector(int32_t);
orc_type_vector(uint32_t);
orc_type_vector(int64_t);
orc_type_vector(uint64_t);


/* ------------------------------------------------------------------------- */
void orc_rgb8vector(rgb8 * X, int32_t ncl, int32_t nch, rgb8 y, rgb8 * Z)
/* ------------------------------------------------------------------------- */
{
	for (int32_t j = ncl; j <= nch; j++) {
        RGB8_OR(X[j], y, Z[j]);
	}
}

/* ----------------------------------------------------------------------------- */
void orc_rgbx8vector(rgbx8 * X, int32_t ncl, int32_t nch, rgbx8 y, rgbx8 * Z)
/* ----------------------------------------------------------------------------- */
{
	for (int32_t j = ncl; j <= nch; j++) {
        RGBX8_OR(X[j], y, Z[j]);
	}
}


/*
 * -----------
 * --- XOR ---
 * -----------
 */

#undef xor_type_vector
#define xor_type_vector(t) \
void short_name(t,xor_,vector)(t * X, int32_t ncl, int32_t nch, t * Y, t * Z) \
{                                          \
	for (int32_t j = ncl; j <= nch; j++) { \
		Z[j] = X[j] ^ Y[j];                \
	}                                      \
}

xor_type_vector(int8_t);
xor_type_vector(uint8_t);
xor_type_vector(int16_t);
xor_type_vector(uint16_t);
xor_type_vector(int32_t);
xor_type_vector(uint32_t);
xor_type_vector(int64_t);
xor_type_vector(uint64_t);


/* -------------------------------------------------------------------------- */
void xor_rgb8vector(rgb8 * X, int32_t ncl, int32_t nch, rgb8 * Y, rgb8 * Z)
/* -------------------------------------------------------------------------- */
{
	for (int32_t j = ncl; j <= nch; j++) {
        RGB8_XOR(X[j], Y[j], Z[j]);
	}
}

/* ------------------------------------------------------------------------------ */
void xor_rgbx8vector(rgbx8 * X, int32_t ncl, int32_t nch, rgbx8 * Y, rgbx8 * Z)
/* ------------------------------------------------------------------------------ */
{
	for (int32_t j = ncl; j <= nch; j++) {
        RGBX8_XOR(X[j], Y[j], Z[j]);
	}
}


#undef xorc_type_vector
#define xorc_type_vector(t) \
void short_name(t,xorc_,vector)(t * X, int32_t ncl, int32_t nch, t y, t * Z) \
{                                          \
	for (int32_t j = ncl; j <= nch; j++) { \
		Z[j] = X[j] ^ y;                   \
	}                                      \
}

xorc_type_vector(int8_t);
xorc_type_vector(uint8_t);
xorc_type_vector(int16_t);
xorc_type_vector(uint16_t);
xorc_type_vector(int32_t);
xorc_type_vector(uint32_t);
xorc_type_vector(int64_t);
xorc_type_vector(uint64_t);


/* -------------------------------------------------------------------------- */
void xorc_rgb8vector(rgb8 * X, int32_t ncl, int32_t nch, rgb8 y, rgb8 * Z)
/* -------------------------------------------------------------------------- */
{
	for (int32_t j = ncl; j <= nch; j++) {
        RGB8_XOR(X[j], y, Z[j]);
	}
}

/* ------------------------------------------------------------------------------ */
void xorc_rgbx8vector(rgbx8 * X, int32_t ncl, int32_t nch, rgbx8 y, rgbx8 * Z)
/* ------------------------------------------------------------------------------ */
{
	for (int32_t j = ncl; j <= nch; j++) {
        RGBX8_XOR(X[j], y, Z[j]);
	}
}


/*
 * -----------
 * --- AND ---
 * -----------
 */


#undef and_type_vector
#define and_type_vector(t) \
void short_name(t,and_,vector)(t * X, int32_t ncl, int32_t nch, t * Y, t * Z) \
{                                          \
	for (int32_t j = ncl; j <= nch; j++) { \
		Z[j] = X[j] & Y[j];                \
	}                                      \
}

and_type_vector(int8_t);
and_type_vector(uint8_t);
and_type_vector(int16_t);
and_type_vector(uint16_t);
and_type_vector(int32_t);
and_type_vector(uint32_t);
and_type_vector(int64_t);
and_type_vector(uint64_t);


/* -------------------------------------------------------------------------- */
void and_rgb8vector(rgb8 * X, int32_t ncl, int32_t nch, rgb8 * Y, rgb8 * Z)
/* -------------------------------------------------------------------------- */
{
	for (int32_t j = ncl; j <= nch; j++) {
        RGB8_AND(X[j], Y[j], Z[j]);
	}
}

/* ------------------------------------------------------------------------------ */
void and_rgbx8vector(rgbx8 * X, int32_t ncl, int32_t nch, rgbx8 * Y, rgbx8 * Z)
/* ------------------------------------------------------------------------------ */
{
	for (int32_t j = ncl; j <= nch; j++) {
        RGBX8_AND(X[j], Y[j], Z[j]);
	}
}


#undef andc_type_vector
#define andc_type_vector(t) \
void short_name(t,andc_,vector)(t * X, int32_t ncl, int32_t nch, t y, t * Z) \
{                                          \
	for (int32_t j = ncl; j <= nch; j++) { \
		Z[j] = X[j] ^ y;                   \
	}                                      \
}

andc_type_vector(int8_t);
andc_type_vector(uint8_t);
andc_type_vector(int16_t);
andc_type_vector(uint16_t);
andc_type_vector(int32_t);
andc_type_vector(uint32_t);
andc_type_vector(int64_t);
andc_type_vector(uint64_t);


/* -------------------------------------------------------------------------- */
void andc_rgb8vector(rgb8 * X, int32_t ncl, int32_t nch, rgb8 y, rgb8 * Z)
/* -------------------------------------------------------------------------- */
{
	for (int32_t j = ncl; j <= nch; j++) {
        RGB8_AND(X[j], y, Z[j]);
	}
}

/* ------------------------------------------------------------------------------ */
void andc_rgbx8vector(rgbx8 * X, int32_t ncl, int32_t nch, rgbx8 y, rgbx8 * Z)
/* ------------------------------------------------------------------------------ */
{
	for (int32_t j = ncl; j <= nch; j++) {
        RGBX8_AND(X[j], y, Z[j]);
	}
}


// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:

// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

