/* --------------- */
/* --- nrio1.c --- */
/* --------------- */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
 * 
 * Distributed under the Boost Software License, Version 1.0
 * see accompanying file LICENSE.txt or copy it at
 * http://www.boost.org/LICENSE_1_0.txt
 */

#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>

#include "nrc_os_config.h"
#include "mypredef.h"
#include "nrtype.h"
#include "nrdef.h"
#include "nrmacro.h"
#include "nrkernel.h"

#include "nralloc1.h"
#include "nrio0.h"
#include "nrio1.h"

/*
 * ----------------------
 * --- display_vector ---
 * ----------------------
 */

#undef display_type_vector
#define display_type_vector(t) \
void short_name(t,display_,vector)(t * v, int32_t nl, int32_t nh, char * format, char * name) \
{                                        \
    if (name != NULL) {                  \
        printf("%s", name);              \
    }                                    \
    for (int32_t i = nl; i <= nh; i++) { \
        printf(format, v[i]);            \
    }                                    \
    printf("\n");                        \
}

display_type_vector(int8_t);
display_type_vector(uint8_t);
display_type_vector(int16_t);
display_type_vector(uint16_t);
display_type_vector(int32_t);
display_type_vector(uint32_t);
display_type_vector(int64_t);
display_type_vector(uint64_t);
display_type_vector(float);
display_type_vector(double);
display_type_vector(rgb8);
display_type_vector(rgbx8);


/*
 * -----------------------------
 * --- display_vector_number ---
 * -----------------------------
 */

#undef display_type_vector_number
#define display_type_vector_number(t) \
void short_name(t,display_,vector_number)(t * v, int32_t nl, int32_t nh, char * format, char * name) \
{                                        \
    if (name != NULL) {                  \
        printf("%s\n", name);            \
    }                                    \
    for (int32_t i = nl; i <= nh; i++) { \
        printf(format, i);               \
    }                                    \
    printf("\n");                        \
    for (int32_t i = nl; i <= nh; i++) { \
        printf(format, v[i]);            \
    }                                    \
    printf("\n");                        \
}


display_type_vector_number(int8_t);
display_type_vector_number(uint8_t);
display_type_vector_number(int16_t);
display_type_vector_number(uint16_t);
display_type_vector_number(int32_t);
display_type_vector_number(uint32_t);
display_type_vector_number(int64_t);
display_type_vector_number(uint64_t);
display_type_vector_number(float);
display_type_vector_number(double);
display_type_vector_number(rgb8);
display_type_vector_number(rgbx8);


/*
 * ------------------------
 * --- display_vector_T ---
 * ------------------------
 */


#undef display_type_vector_T
#define display_type_vector_T(t) \
void short_name(t,display_,vector_T)(t * v, int32_t i0, int32_t i1, char * format, char * name) \
{                                        \
    if (name != NULL) {                  \
        printf("%s", name);              \
    }                                    \
    for (int32_t i = i0; i <= i1; i++) { \
        printf(format, v[i]);            \
        printf("\n");                    \
    }                                    \
    printf("\n");                        \
}

display_type_vector_T(int8_t);
display_type_vector_T(uint8_t);
display_type_vector_T(int16_t);
display_type_vector_T(uint16_t);
display_type_vector_T(int32_t);
display_type_vector_T(uint32_t);
display_type_vector_T(int64_t);
display_type_vector_T(uint64_t);
display_type_vector_T(float);
display_type_vector_T(double);
display_type_vector_T(rgb8);
display_type_vector_T(rgbx8);


/*
 * -------------------------------
 * --- display_vector_number_T ---
 * -------------------------------
 */


#undef display_type_vector_number_T
#define display_type_vector_number_T(t) \
void short_name(t,display_,vector_number_T)(t * v, int32_t i0, int32_t i1, char * format, char * name) \
{                                        \
    if (name != NULL) {                  \
        printf("%s", name);              \
    }                                    \
    for (int32_t i = i0; i <= i1; i++) { \
        printf("%8d ", i);               \
        printf(format, v[i]);            \
        printf("\n");                    \
    }                                    \
    printf("\n");                        \
}

display_type_vector_number_T(int8_t);
display_type_vector_number_T(uint8_t);
display_type_vector_number_T(int16_t);
display_type_vector_number_T(uint16_t);
display_type_vector_number_T(int32_t);
display_type_vector_number_T(uint32_t);
display_type_vector_number_T(int64_t);
display_type_vector_number_T(uint64_t);
display_type_vector_number_T(float);
display_type_vector_number_T(double);
display_type_vector_number_T(rgb8);
display_type_vector_number_T(rgbx8);


/*
 * -------------------------------
 * --- display_vector_positive ---
 * -------------------------------
 */

#undef display_type_vector_positive
#define display_type_vector_positive(t) \
void short_name(t,display_,vector_positive)(t * v, int32_t j0, int32_t j1, int32_t iformat, char * name) \
{                                                               \
    char * format;                                              \
    char * str;                                                 \
    select_display_positive_parameters(iformat, &format, &str); \
    if (name != NULL) {                                         \
        printf(name);                                           \
    }                                                           \
    for (int32_t j = j0; j <= j1; j++) {                        \
        if (v[j] != 0) {                                        \
            printf(format, v[j]);                               \
        }                                                       \
        else {                                                  \
            printf("%s", str);                                  \
        }                                                       \
    }                                                           \
    printf("\n");                                               \
}


display_type_vector_positive(int8_t);
display_type_vector_positive(uint8_t);
display_type_vector_positive(int16_t);
display_type_vector_positive(uint16_t);
display_type_vector_positive(int32_t);
display_type_vector_positive(uint32_t);
display_type_vector_positive(int64_t);
display_type_vector_positive(uint64_t);
display_type_vector_positive(float);
display_type_vector_positive(double);

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:

// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

