/* ---------------- */
/* --- nriof1.c --- */
/* ---------------- */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
 * 
 * Distributed under the Boost Software License, Version 1.0
 * see accompanying file LICENSE.txt or copy it at
 * http://www.boost.org/LICENSE_1_0.txt
 */

#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>

#include "nrc_os_config.h"
#include "mypredef.h"
#include "nrtype.h"
#include "nrdef.h"
#include "nrmacro.h"
#include "nrkernel.h"

#include "nralloc1.h"
#include "nrio0.h"
#include "nrio1.h"

/*
 * --------------------
 * --- write_vector ---
 * --------------------
 */

#undef write_type_vector
#define write_type_vector(t) \
void short_name(t,write_,vector)(t * v, int32_t nl, int32_t nh, char * format, char * filename) \
{                                                                  \
    FILE * f = fopen(filename, "wt");                              \
    if (f == NULL) {                                               \
        nrerror("Can't open file %s in %s\n", filename, __func__); \
    }                                                              \
    for (int32_t k = nl; k <= nh; k++) {                           \
        fprintf(f, format, v[k]);                                  \
    }                                                              \
    fprintf(f, "\n");                                              \
    fclose(f);                                                     \
}

write_type_vector(int8_t);
write_type_vector(uint8_t);
write_type_vector(int16_t);
write_type_vector(uint16_t);
write_type_vector(int32_t);
write_type_vector(uint32_t);
write_type_vector(int64_t);
write_type_vector(uint64_t);
write_type_vector(float);
write_type_vector(double);


/* ---------------------------------------------------------------------------------- */
void write_rgb8vector(rgb8 * v,int32_t nl, int32_t nh, char * format, char * filename)
/* ---------------------------------------------------------------------------------- */
{
    FILE * f = fopen(filename, "wt");
    if (f == NULL) {
        nrerror("Can't open file %s in %s\n", filename, __func__); \
    }
    for (int32_t k = nl; k <= nh; k++) {
        fprintf(f, format, v[k].r, v[k].g, v[k].b);
    }
    fprintf(f, "\n");
    fclose(f);
}

/* -------------------------------------------------------------------------------------- */
void write_rgbx8vector(rgbx8 * v, int32_t nl, int32_t nh, char * format, char * filename)
/* -------------------------------------------------------------------------------------- */
{
    FILE * f = fopen(filename, "wt");
    if (f == NULL) {
        nrerror("Can't open file %s in %s\n", filename, __func__); \
    }
    for (int32_t k = nl; k <= nh; k++) {
        fprintf(f, format, v[k].r, v[k].g, v[k].b);
    }
    fprintf(f, "\n");
    fclose(f);
}


/*
 * ----------------------
 * --- write_vector_T ---
 * ----------------------
 */

#undef write_type_vector_T
#define write_type_vector_T(t) \
void short_name(t,write_,vector_T)(t * v, int32_t nl, int32_t nh, char * format, char * filename) \
{                                                                  \
    FILE * f = fopen(filename, "wt");                              \
    if (f == NULL) {                                               \
        nrerror("Can't open file %s in %s\n", filename, __func__); \
    }                                                              \
    for (int32_t k = nl; k <= nh; k++) {                           \
        fprintf(f, format, v[k]);                                  \
        fprintf(f, "\n");                                          \
    }                                                              \
    fclose(f);                                                     \
}

write_type_vector_T(int8_t);
write_type_vector_T(uint8_t);
write_type_vector_T(int16_t);
write_type_vector_T(uint16_t);
write_type_vector_T(int32_t);
write_type_vector_T(uint32_t);
write_type_vector_T(int64_t);
write_type_vector_T(uint64_t);
write_type_vector_T(float);
write_type_vector_T(double);


/* ---------------------------------------------------------------------------------- */
void write_rgb8vector_T(rgb8 * v,int32_t nl, int32_t nh, char * format, char * filename)
/* ---------------------------------------------------------------------------------- */
{
    FILE * f = fopen(filename, "wt");
    if (f == NULL) {
        nrerror("Can't open file %s in %s\n", filename, __func__); \
    }
    for (int32_t k = nl; k <= nh; k++) {
        fprintf(f, format, v[k].r, v[k].g, v[k].b);
        fprintf(f, "\n");
    }
    fclose(f);
}

/* -------------------------------------------------------------------------------------- */
void write_rgbx8vector_T(rgbx8 * v, int32_t nl, int32_t nh, char * format, char * filename)
/* -------------------------------------------------------------------------------------- */
{
    FILE * f = fopen(filename, "wt");
    if (f == NULL) {
        nrerror("Can't open file %s in %s\n", filename, __func__); \
    }
    for (int32_t k = nl; k <= nh; k++) {
        fprintf(f, format, v[k].r, v[k].g, v[k].b);
        fprintf(f, "\n");
    }
    fclose(f);
}


/*
 * ---------------------------
 * --- write_vector_number ---
 * ---------------------------
 */

// @QM : fprintf(f, format, k, k, k); ?
#undef write_type_vector_number
#define write_type_vector_number(t) \
void short_name(t,write_,vector_number)(t * v, int32_t nl, int32_t nh, char * format, char * filename) \
{                                                                  \
    FILE * f = fopen(filename, "wt");                              \
    if (f == NULL) {                                               \
        nrerror("Can't open file %s in %s\n", filename, __func__); \
    }                                                              \
    for (int32_t k = nl; k <= nh; k++) {                           \
        fprintf(f, format, k);                                     \
    }                                                              \
    fprintf(f, "\n");                                              \
    for (int32_t k = nl; k <= nh; k++) {                           \
        fprintf(f, format, v[k]);                                  \
    }                                                              \
    fprintf(f, "\n");                                              \
    fclose(f);                                                     \
}

write_type_vector_number(int8_t);
write_type_vector_number(uint8_t);
write_type_vector_number(int16_t);
write_type_vector_number(uint16_t);
write_type_vector_number(int32_t);
write_type_vector_number(uint32_t);
write_type_vector_number(int64_t);
write_type_vector_number(uint64_t);
write_type_vector_number(float);
write_type_vector_number(double);


/* ------------------------------------------------------------------------------------------- */
void write_rgb8vector_number(rgb8 * v, int32_t nl, int32_t nh, char * format, char * filename)
/* ------------------------------------------------------------------------------------------- */
{
    FILE * f = fopen(filename, "wt");
    if (f == NULL) {
        nrerror("Can't open file %s in %s\n", filename, __func__);
    }
    for (int32_t k = nl; k <= nh; k++) {
        fprintf(f, "%3d", k);
    }
    fprintf(f, "\n");
    for (int32_t k = nl; k <= nh; k++) {
        fprintf(f, format, v[k].r, v[k].g, v[k].b);
    }
    fprintf(f, "\n");
    fclose(f);
}


/* --------------------------------------------------------------------------------------------- */
void write_rgbx8vector_number(rgbx8 * v, int32_t nl, int32_t nh, char * format, char * filename)
/* --------------------------------------------------------------------------------------------- */
{
    FILE * f = fopen(filename, "wt");
    if (f == NULL) {
        nrerror("Can't open file %s in %s\n", filename, __func__);
    }
    for (int32_t k = nl; k <= nh; k++) {
        fprintf(f, "%3d", k);
    }
    fprintf(f, "\n");
    for (int32_t k = nl; k <= nh; k++) {
        fprintf(f, format, v[k].r, v[k].g, v[k].b);
    }
    fprintf(f, "\n");
    fclose(f);
}


/*
 * -----------------------------
 * --- write_vector_T_number ---
 * -----------------------------
 */

#undef write_type_vector_T_number
#define write_type_vector_T_number(t) \
void short_name(t,write_,vector_T_number)(t * v, int32_t nl, int32_t nh, char * format, char * filename) \
{                                                                  \
    FILE * f = fopen(filename, "wt");                              \
    if (f == NULL) {                                               \
        nrerror("Can't open file %s in %s\n", filename, __func__); \
    }                                                              \
    for (int32_t k = nl; k <= nh; k++) {                           \
        fprintf(f, "%3d", k);                                      \
        fprintf(f, format, v[k]);                                  \
        fprintf(f, "\n");                                          \
    }                                                              \
    fclose(f);                                                     \
}

write_type_vector_T_number(int8_t);
write_type_vector_T_number(uint8_t);
write_type_vector_T_number(int16_t);
write_type_vector_T_number(uint16_t);
write_type_vector_T_number(int32_t);
write_type_vector_T_number(uint32_t);
write_type_vector_T_number(int64_t);
write_type_vector_T_number(uint64_t);
write_type_vector_T_number(float);
write_type_vector_T_number(double);


/* ------------------------------------------------------------------------------------------- */
void write_rgb8vector_T_number(rgb8 * v, int32_t nl, int32_t nh, char * format, char * filename)
/* ------------------------------------------------------------------------------------------- */
{
    FILE * f = fopen(filename, "wt");
    if (f == NULL) {
        nrerror("Can't open file %s in %s\n", filename, __func__);
    }
    for (int32_t k = nl; k <= nh; k++) {
        fprintf(f, "%3d", k);
        fprintf(f, format, v[k].r, v[k].g, v[k].b);
        fprintf(f, "\n");
    }
    fclose(f);
}


/* --------------------------------------------------------------------------------------------- */
void write_rgbx8vector_T_number(rgbx8 * v, int32_t nl, int32_t nh, char * format, char * filename)
/* --------------------------------------------------------------------------------------------- */
{
    FILE * f = fopen(filename, "wt");
    if (f == NULL) {
        nrerror("Can't open file %s in %s\n", filename, __func__);
    }
    for (int32_t k = nl; k <= nh; k++) {
        fprintf(f, "%3d", k);
        fprintf(f, format, v[k].r, v[k].g, v[k].b);
        fprintf(f, "\n");
    }
    fclose(f);
}



/*
 * --------------------
 * --- fread_vector ---
 * --------------------
 */

#undef fread_type_vector
#define fread_type_vector(t) \
void short_name(t,fread_,vector)(char * filename, t * v, int32_t nl, int32_t nh) \
{                                                                  \
    int32_t ncol = nh - nl + 1;                                    \
    int32_t nread;                                                 \
    FILE * f = fopen(filename, "rb");                              \
    if (f == NULL) {                                               \
        nrerror("Can't open file %s in %s\n", filename, __func__); \
    }                                                              \
                                                                   \
    nread = fread(v + nl, sizeof(t), ncol, f);                     \
    if (nread != ncol) {                                           \
        nrerror("%s can't read the whole vector", __func__);       \
    }                                                              \
    fclose(f);                                                     \
}

fread_type_vector(int8_t);
fread_type_vector(uint8_t);
fread_type_vector(int16_t);
fread_type_vector(uint16_t);
fread_type_vector(int32_t);
fread_type_vector(uint32_t);
fread_type_vector(int64_t);
fread_type_vector(uint64_t);
fread_type_vector(float);
fread_type_vector(double);
fread_type_vector(rgb8);
fread_type_vector(rgbx8);


/* ------------------- */
/* -- fwrite_vector -- */
/* ------------------- */

#undef fwrite_type_vector
#define fwrite_type_vector(t) \
void short_name(t,fwrite_,vector)(t * v, int32_t nl, int32_t nh, char * filename) \
{                                                                  \
    int32_t ncol = nh - nl + 1;                                    \
    FILE * f = fopen(filename, "rb");                              \
    if (f == NULL) {                                               \
        nrerror("Can't open file %s in %s\n", filename, __func__); \
    }                                                              \
    fwrite(v + nl, sizeof(t), ncol, f);                            \
    fclose(f);                                                     \
}

fwrite_type_vector(int8_t);
fwrite_type_vector(uint8_t);
fwrite_type_vector(int16_t);
fwrite_type_vector(uint16_t);
fwrite_type_vector(int32_t);
fwrite_type_vector(uint32_t);
fwrite_type_vector(int64_t);
fwrite_type_vector(uint64_t);
fwrite_type_vector(float);
fwrite_type_vector(double);
fwrite_type_vector(rgb8);
fwrite_type_vector(rgbx8);



// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:

// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

