/* ------------- */
/* --- nrlut --- */
/* ------------- */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
 */

#ifndef _NRLUT_H_
#define _NRLUT_H_

#define init_type_lut(t) \
void short_name(t,init_,lut)(t * v, int32_t nl, int32_t nh, int32_t n0, int32_t n1, t k); \
void short_name(t,lut_,matrix)(t ** S, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, t * L, t ** D);

init_type_lut(int8_t);
init_type_lut(uint8_t);
init_type_lut(int16_t);
init_type_lut(uint16_t);
init_type_lut(int32_t);
init_type_lut(uint32_t);
init_type_lut(rgb8);


void lut_si16matrix_si8matrix(int16_t ** S, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, int8_t * L, int8_t ** D);
void lut_ui16matrix_ui8matrix(uint16_t ** S, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, uint8_t * L, uint8_t ** D);
void lut_si32matrix_si16matrix(int32_t ** S, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, int16_t * L, int16_t ** D);
void lut_ui32matrix_ui16matrix(uint32_t ** S, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, uint16_t * L, uint16_t ** D);


#define histogram_type_matrix(t) \
void short_name(t,histogram_,matrix)(t ** S, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, t * H);

histogram_type_matrix(int8_t);
histogram_type_matrix(uint8_t);
histogram_type_matrix(int16_t);
histogram_type_matrix(uint16_t);
histogram_type_matrix(int32_t);
histogram_type_matrix(uint32_t);
void histogram_rgb8matrix(rgb8 ** S, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, rgb32 * H);


#endif /* _NRLUT_H_ */

