/* ---------------- */
/* --- nrio2x.c --- */
/* ---------------- */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
 */

#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>

#include "mypredef.h"
#include "nrtype.h"
#include "nrdef.h"
#include "nrmacro.h"
#include "nrkernel.h"

#include "nrio0.h"
#include "nralloc1.h"
#include "nralloc2.h"
#include "nrio1.h"
#include "nrio2.h"
#include "nrio2x.h"

/* ----------------------- */
/* --- write_trimatrix --- */
/* ----------------------- */

#undef write_type_trimatrix
#define write_type_trimatrix(t) \
void short_name(t,write_,trimatrix)(t ** m, int32_t i0, int32_t i1, int32_t j0, int32_t j1, int32_t step, char * format, char * filename) \
{                                                                \
    FILE * f = fopen(filename, "wt");                            \
    if (f == NULL) {                                             \
        nrerror("Can't open file %s in %s", filename, __func__); \
    }                                                            \
    for (int32_t i = i0; i <= i1; i++) {                         \
        for (int32_t j = j0; j <= j1; j++) {                     \
            fprintf(f, format, m[i][j]);                         \
        }                                                        \
        fprintf(f, "\n");                                        \
        j1 += step;                                              \
    }                                                            \
    fprintf(f, "\n");                                            \
    fclose(f);                                                   \
}

write_type_trimatrix(int8_t);
write_type_trimatrix(uint8_t);
write_type_trimatrix(int16_t);
write_type_trimatrix(uint16_t);
write_type_trimatrix(int32_t);
write_type_trimatrix(uint32_t);
write_type_trimatrix(int64_t);
write_type_trimatrix(uint64_t);
write_type_trimatrix(float);
write_type_trimatrix(double);


/* ---------------------------- */
/* --- write_matrix_endline --- */
/* ---------------------------- */

#undef write_type_matrix_endline
#define write_type_matrix_endline(t) \
void short_name(t,write_,matrix_endline)(t ** m, int32_t i0, int32_t i1, int32_t j0, int32_t j1, char * format, char * filename) \
{                                                                \
    t * p = &m[i0][j0];                                          \
    FILE * f = fopen(filename, "wt");                            \
    if (f == NULL) {                                             \
        nrerror("Can't open file %s in %s", filename, __func__); \
    }                                                            \
    for (int32_t i = i0; i <= i1; i++) {                         \
        for (int32_t j = j0; j <= j1; j++) {                     \
            fprintf(f, format, *p++);                            \
        }                                                        \
        fprintf(f, "\n");                                        \
    }                                                            \
    fprintf(f, "\n");                                            \
    fclose(f);                                                   \
}

write_type_matrix_endline(int8_t);
write_type_matrix_endline(uint8_t);
write_type_matrix_endline(int16_t);
write_type_matrix_endline(uint16_t);
write_type_matrix_endline(int32_t);
write_type_matrix_endline(uint32_t);
write_type_matrix_endline(int64_t);
write_type_matrix_endline(uint64_t);
write_type_matrix_endline(float);
write_type_matrix_endline(double);


/* ------------------------------ */
/* --- write_imatrix_endline0 --- */
/* ------------------------------ */

#undef write_type_matrix_endline0
#define write_type_matrix_endline0(t) \
void short_name(t,write_,matrix_endline0)(t ** m, int32_t i0, int32_t i1, int32_t j0, int32_t j1, char * format, char * filename) \
{                                                                \
    FILE * f = fopen(filename, "wt");                            \
    if (f == NULL) {                                             \
        nrerror("Can't open file %s in %s", filename, __func__); \
    }                                                            \
    for (int32_t i = i0; i <= i1; i++) {                         \
        int32_t n = (int32_t) m[i][j0];                          \
        for (int32_t j = j0; j <= j0 + n; j++) {                 \
            fprintf(f, format, m[i][j]);                         \
        }                                                        \
        fprintf(f, "\n");                                        \
    }                                                            \
    fprintf(f, "\n");                                            \
    fclose(f);                                                   \
}

write_type_matrix_endline0(int8_t);
write_type_matrix_endline0(uint8_t);
write_type_matrix_endline0(int16_t);
write_type_matrix_endline0(uint16_t);
write_type_matrix_endline0(int32_t);
write_type_matrix_endline0(uint32_t);
write_type_matrix_endline0(int64_t);
write_type_matrix_endline0(uint64_t);
write_type_matrix_endline0(float);
write_type_matrix_endline0(double);



/* ------------------------------ */
/* --- write_imatrix_endline1 --- */
/* ------------------------------ */

#undef write_type_matrix_endline1
#define write_type_matrix_endline1(t) \
void short_name(t,write_,matrix_endline1)(t ** m, int32_t i0, int32_t i1, int32_t j0, int32_t j1, char * format, char * filename) \
{                                                                \
    FILE * f = fopen(filename, "wt");                            \
    if (f == NULL) {                                             \
        nrerror("Can't open file %s in %s", filename, __func__); \
    }                                                            \
    for (int32_t i = i0; i <= i1; i++) {                         \
        int32_t n = (int32_t) m[i][j0 - 1];                      \
        for (int32_t j = j0; j <= j0 + n - 1; j++) {             \
            fprintf(f, format, m[i][j]);                         \
        }                                                        \
        fprintf(f, "\n");                                        \
    }                                                            \
    fprintf(f, "\n");                                            \
    fclose(f);                                                   \
}

write_type_matrix_endline1(int8_t);
write_type_matrix_endline1(uint8_t);
write_type_matrix_endline1(int16_t);
write_type_matrix_endline1(uint16_t);
write_type_matrix_endline1(int32_t);
write_type_matrix_endline1(uint32_t);
write_type_matrix_endline1(int64_t);
write_type_matrix_endline1(uint64_t);
write_type_matrix_endline1(float);
write_type_matrix_endline1(double);


/* ------------------------------------- */
/* --- write_imatrix_number_endline0 --- */
/* ------------------------------------- */

#undef write_type_matrix_number_endline0
#define write_type_matrix_number_endline0(t) \
void short_name(t,write_,matrix_number_endline0)(t ** m, int32_t i0, int32_t i1, int32_t j0, int32_t j1, char * format, char * filename) \
{                                                                \
    FILE * f = fopen(filename, "wt");                            \
    if (f == NULL) {                                             \
        nrerror("Can't open file %s in %s", filename, __func__); \
    }                                                            \
    for (int32_t i = i0; i <= i1; i++) {                         \
        fprintf(f, "[%3d] ", i);                                 \
        int32_t n = (int32_t) m[i][j0];                          \
        for (int32_t j = j0; j <= j0 + n; j++) {                 \
            fprintf(f, format, m[i][j]);                         \
        }                                                        \
        fprintf(f, "\n");                                        \
    }                                                            \
    fprintf(f, "\n");                                            \
    fclose(f);                                                   \
}

write_type_matrix_number_endline0(int8_t);
write_type_matrix_number_endline0(uint8_t);
write_type_matrix_number_endline0(int16_t);
write_type_matrix_number_endline0(uint16_t);
write_type_matrix_number_endline0(int32_t);
write_type_matrix_number_endline0(uint32_t);
write_type_matrix_number_endline0(int64_t);
write_type_matrix_number_endline0(uint64_t);
write_type_matrix_number_endline0(float);
write_type_matrix_number_endline0(double);


/* ------------------------------------- */
/* --- write_imatrix_number_endline1 --- */
/* ------------------------------------- */

#undef write_type_matrix_number_endline1
#define write_type_matrix_number_endline1(t) \
void short_name(t,write_,matrix_number_endline1)(t ** m, int32_t i0, int32_t i1, int32_t j0, int32_t j1, char * format, char * filename) \
{                                                                \
    FILE * f = fopen(filename, "wt");                            \
    if (f == NULL) {                                             \
        nrerror("Can't open file %s in %s", filename, __func__); \
    }                                                            \
    for (int32_t i = i0; i <= i1; i++) {                         \
        fprintf(f, "[%3d] ", i);                                 \
        int32_t n = (int32_t) m[i][j0 - 1];                      \
        for (int32_t j = j0; j <= j0 + n - 1; j++) {             \
            fprintf(f, format, m[i][j]);                         \
        }                                                        \
        fprintf(f, "\n");                                        \
    }                                                            \
    fprintf(f, "\n");                                            \
    fclose(f);                                                   \
}

write_type_matrix_number_endline1(int8_t);
write_type_matrix_number_endline1(uint8_t);
write_type_matrix_number_endline1(int16_t);
write_type_matrix_number_endline1(uint16_t);
write_type_matrix_number_endline1(int32_t);
write_type_matrix_number_endline1(uint32_t);
write_type_matrix_number_endline1(int64_t);
write_type_matrix_number_endline1(uint64_t);
write_type_matrix_number_endline1(float);
write_type_matrix_number_endline1(double);


/* ---------------------- */
/* -- fwrite_trimatrix -- */
/* ---------------------- */

#undef fwrite_type_trimatrix
#define fwrite_type_trimatrix(t) \
void short_name(t,fwrite_,trimatrix)(t ** m, int32_t i0, int32_t i1, int32_t j0, int32_t j1, int32_t step, char * filename) \
{                                                                \
    int32_t ncol = j1 - j0 + 1;                                  \
    FILE * f = fopen(filename, "wb");                            \
    if (f == NULL) {                                             \
        nrerror("Can't open file %s in %s", filename, __func__); \
    }                                                            \
    for (int32_t i = i0; i <= i1; i++) {                         \
        fwrite(m[i] + j0, sizeof(t), ncol, f);                   \
        ncol += step;                                            \
    }                                                            \
    fclose(f);                                                   \
}

fwrite_type_trimatrix(int8_t);
fwrite_type_trimatrix(uint8_t);
fwrite_type_trimatrix(int16_t);
fwrite_type_trimatrix(uint16_t);
fwrite_type_trimatrix(int32_t);
fwrite_type_trimatrix(uint32_t);
fwrite_type_trimatrix(int64_t);
fwrite_type_trimatrix(uint64_t);
fwrite_type_trimatrix(float);
fwrite_type_trimatrix(double);




/* --------------------- */
/* -- fread_trimatrix -- */
/* --------------------- */

#undef fread_type_trimatrix
#define fread_type_trimatrix(t) \
void short_name(t,fread_,trimatrix)(char * filename, t ** m, int32_t i0, int32_t i1, int32_t j0, int32_t j1, int32_t step) \
{                                                                \
    int32_t ncol = j1 - j0 + 1;                                  \
    FILE * f = fopen(filename, "rb");                            \
    if (f == NULL) {                                             \
        nrerror("Can't open file %s in %s", filename, __func__); \
    }                                                            \
    for (int32_t i = i0; i <= i1; i++) {                         \
        fread(m[i] + j0, sizeof(t), ncol, f);    \
        ncol += step;                                            \
    }                                                            \
    fclose(f);                                                   \
}

fread_type_trimatrix(int8_t);
fread_type_trimatrix(uint8_t);
fread_type_trimatrix(int16_t);
fread_type_trimatrix(uint16_t);
fread_type_trimatrix(int32_t);
fread_type_trimatrix(uint32_t);
fread_type_trimatrix(int64_t);
fread_type_trimatrix(uint64_t);
fread_type_trimatrix(float);
fread_type_trimatrix(double);


// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:

// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

