/* --------------- */
/* --- nrlut.c --- */
/* --------------- */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
 *
 * Distributed under the Boost Software License, Version 1.0
 * see accompanying file LICENSE.txt or copy it at
 * http://www.boost.org/LICENSE_1_0.txt
 */

/* 
 * 2002/06/11 ajout des fonctions endline
 */
#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>
#include <math.h> // fabs

#include "mypredef.h"
#include "nrtype.h"
#include "nrdef.h"
#include "nrmacro.h"
#include "nrkernel.h"

#include "nrlut.h"


#undef init_type_lut
#define init_type_lut(t) \
void short_name(t,init_,lut)(t * v, int32_t nl, int32_t nh, int32_t n0, int32_t n1, t k) \
{                                                \
    if (nl <= nh) {                              \
        for (int32_t i = nl; i < n0; i++) {      \
            v[i] = 0;                            \
        }                                        \
        for (int32_t i = n0; i <= n1; i++) {     \
            v[i] = k;                            \
        }                                        \
        for (int32_t i = n1 + 1; i <= nh; i++) { \
            v[i] = 0;                            \
        }                                        \
    }                                            \
    else {                                       \
        for (int32_t i = nl; i < n1; i++) {      \
            v[i] = k;                            \
        }                                        \
        for (int32_t i = n1; i <= n0; i++) {     \
            v[i] = 0;                            \
        }                                        \
        for (int32_t i = n1 + 1; i <= nh; i++) { \
            v[i] = k;                            \
        }                                        \
    }                                            \
}


init_type_lut(int8_t);
init_type_lut(uint8_t);
init_type_lut(int16_t);
init_type_lut(uint16_t);
init_type_lut(int32_t);
init_type_lut(uint32_t);



void init_rgb8lut(rgb8 * v, int32_t nl, int32_t nh, int32_t n0, int32_t n1, rgb8 k)
{
    if (nl <= nh) {
        // normal case 
        for (int32_t i = nl; i < n0; i++) {
            v[i].r = 0;
            v[i].g = 0;
            v[i].b = 0;
        }
        for (int32_t i = n0; i <= n1; i++) {
            v[i].r = k.r;
            v[i].g = k.g;
            v[i].b = k.b;
        }
        for (int32_t i = n1 + 1; i <= nh; i++) {
            v[i].r = 0;
            v[i].g = 0;
            v[i].b = 0;
        }
    }
    else {
        for (int32_t i = nl; i < n1; i++) {
            v[i].r = k.r;
            v[i].g = k.g;
            v[i].b = k.b;
        }
        for (int32_t i = n1; i <= n0; i++) {
            v[i].r = 0;
            v[i].g = 0;
            v[i].b = 0;
        }
        for (int32_t i = n1 + 1; i <= nh; i++) {
            v[i].r = k.r;
            v[i].g = k.g;
            v[i].b = k.b;
        }
    }
}


#undef lut_type_matrix
#define lut_type_matrix(t) \
void short_name(t,lut_,matrix)(t ** S, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, t * L, t ** D) \
{                                              \
    for (int32_t i = nrl; i <= nrh; i++) {     \
        for (int32_t j = ncl; j <= nch; j++) { \
            D[i][j] = L[(int32_t) S[i][j]];    \
        }                                      \
    }                                          \
}

lut_type_matrix(int8_t);
lut_type_matrix(uint8_t);
lut_type_matrix(int16_t);
lut_type_matrix(uint16_t);
lut_type_matrix(int32_t);
lut_type_matrix(uint32_t);



void lut_rgb8matrix(rgb8 ** S, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, rgb8 * L, rgb8 ** D)
{
    for (int32_t i = nrl; i <= nrh; i++) {
        for (int32_t j = ncl; j <= nch; j++) {
            D[i][j].r = L[S[i][j].r].r;
            D[i][j].g = L[S[i][j].g].g;
            D[i][j].b = L[S[i][j].b].b;
        }
    }
}


void lut_ui16matrix_ui8matrix(uint16_t ** S, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, uint8_t * L, uint8_t ** D)
{
    for (int32_t i = nrl; i <= nrh; i++) {
        for (int32_t j = ncl; j <= nch; j++) {
            D[i][j] = L[(int32_t) S[i][j]];
        }
    }
}

void lut_i16matrix_i8matrix(int16_t ** S, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, uint8_t * L, int8_t ** D)
{
    for (int32_t i = nrl; i <= nrh; i++) {
        for (int32_t j = ncl; j <= nch; j++) {
            D[i][j] = L[(int32_t) S[i][j]];
        }
    }
}

void lut_ui32matrix_ui16matrix(uint32_t ** S, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, uint16_t * L, uint16_t ** D)
{
    for (int32_t i = nrl; i <= nrh; i++) {
        for (int32_t j = ncl; j <= nch; j++) {
            D[i][j] = L[(int32_t) S[i][j]];
        }
    }
}

void lut_i32matrix_i16matrix(int32_t ** S, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, uint16_t * L, int16_t ** D)
{
    for (int32_t i = nrl; i <= nrh; i++) {
        for (int32_t j = ncl; j <= nch; j++) {
            D[i][j] = L[(int32_t) S[i][j]];
        }
    }
}


#undef histogram_type_matrix
#define histogram_type_matrix(t) \
void short_name(t,histogram_,matrix)(t ** S, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, t * H) \
{                                              \
    t * Si;                                    \
    for (int32_t i = nrl; i <= nrh; i++) {     \
        Si = S[i];                             \
        for (int32_t j = ncl; j <= nch; j++) { \
            H[(int32_t) Si[j]]++;              \
        }                                      \
    }                                          \
}

histogram_type_matrix(int8_t);
histogram_type_matrix(uint8_t);
histogram_type_matrix(int16_t);
histogram_type_matrix(uint16_t);
histogram_type_matrix(int32_t);
histogram_type_matrix(uint32_t);



void histogram_rgb8matrix(rgb8 ** S, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, rgb32 * H)
{
    rgb8 * Si;
    int r, b, g;
    (void) Si;


    for (int32_t i = nrl; i <= nrh; i++) {
        Si = S[i];
        for (int32_t j = ncl; j <= nch; j++) {
            r = S[i][j].r;
            g = S[i][j].g;
            b = S[i][j].b;

            H[r].r++;
            H[g].g++;
            H[b].b++;
        }
    }
    return;
}

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:

// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

