/* ---------------- */
/* --- nrmem1.h --- */
/* ---------------- */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
 * 
*/

#ifndef __NRMEM1_H__
#define __NRMEM1_H__


#define dup_type_vector(t) \
void short_name(t,dup_,vector)(t * X, int32_t nl, int32_t nh, t * Y);

dup_type_vector(int8_t);
dup_type_vector(uint8_t);
dup_type_vector(int16_t);
dup_type_vector(uint16_t);
dup_type_vector(int32_t);
dup_type_vector(uint32_t);
dup_type_vector(int64_t);
dup_type_vector(uint64_t);
dup_type_vector(float);
dup_type_vector(double);
dup_type_vector(rgb8);
dup_type_vector(rgbx8);

/* --------------------- */
/* --- split & merge --- */
/* --------------------- */

void split_rgb8vector(rgb8 * X, int32_t nl, int32_t nh,  uint8_t * R,  uint8_t * G,  uint8_t * B);
void split_rgb32vector(rgb32 * X, int32_t nl, int32_t nh, uint32_t * R, uint32_t * G, uint32_t * B);

void merge_rgb8vector(uint8_t * R, uint8_t * G, uint8_t * B, int32_t nl, int32_t nh, rgb8 * X);
void merge_rgb32vector(uint32_t * R, uint32_t * G, uint32_t * B, int32_t nl, int32_t nh, rgb32 * X);



/* ---------------- */
/* -- Conversion -- */
/* ---------------- */

#define convert_type1_vector_type2_vector(t1, t2) \
void short_name(t1,convert_,short_name(t2,vector_,vector))(t1 * X, int32_t nl, int32_t nh, t2 * Y);

convert_type1_vector_type2_vector(int8_t,int16_t);
convert_type1_vector_type2_vector(int8_t,int32_t);
convert_type1_vector_type2_vector(int8_t,float);
convert_type1_vector_type2_vector(int8_t,double);
convert_type1_vector_type2_vector(uint8_t,uint16_t);
convert_type1_vector_type2_vector(uint8_t,uint32_t);
convert_type1_vector_type2_vector(uint8_t,float);
convert_type1_vector_type2_vector(uint8_t,double);
convert_type1_vector_type2_vector(int16_t,int32_t);
convert_type1_vector_type2_vector(int16_t,float);
convert_type1_vector_type2_vector(int16_t,double);
convert_type1_vector_type2_vector(uint16_t,uint32_t);
convert_type1_vector_type2_vector(uint16_t,float);
convert_type1_vector_type2_vector(uint16_t,double);
convert_type1_vector_type2_vector(int32_t,float);
convert_type1_vector_type2_vector(int32_t,double);
convert_type1_vector_type2_vector(uint32_t,float);
convert_type1_vector_type2_vector(uint32_t,double);
convert_type1_vector_type2_vector(int16_t,int8_t);
convert_type1_vector_type2_vector(uint16_t,uint8_t);
convert_type1_vector_type2_vector(int32_t,int8_t);
convert_type1_vector_type2_vector(int32_t,int16_t);
convert_type1_vector_type2_vector(uint32_t,uint8_t);
convert_type1_vector_type2_vector(uint32_t,uint16_t);
convert_type1_vector_type2_vector(float,int8_t);
convert_type1_vector_type2_vector(float,uint8_t);
convert_type1_vector_type2_vector(float,int16_t);
convert_type1_vector_type2_vector(float,uint16_t);
convert_type1_vector_type2_vector(float,int32_t);
convert_type1_vector_type2_vector(float,uint32_t);
convert_type1_vector_type2_vector(double,int8_t);
convert_type1_vector_type2_vector(double,uint8_t);
convert_type1_vector_type2_vector(double,int16_t);
convert_type1_vector_type2_vector(double,uint16_t);
convert_type1_vector_type2_vector(double,int32_t);
convert_type1_vector_type2_vector(double,uint32_t);
convert_type1_vector_type2_vector(double,float);
convert_type1_vector_type2_vector(uint8_t,rgb8);
convert_type1_vector_type2_vector(uint8_t,rgbx8);
convert_type1_vector_type2_vector(rgb8,uint8_t);
convert_type1_vector_type2_vector(rgbx8,uint8_t);


/*
 * ---------------
 * --- LowPart ---
 * ---------------
 */

void lowpart_ui16vector_ui8vector(uint16_t * X, int32_t nl, int32_t nh, uint8_t * Y);
void lowpart_ui32vector_ui8vector(uint32_t * X, int32_t nl, int32_t nh, uint8_t * Y);

#endif /* __NRMEM1_H__ */

