/* ---------------- */
/* --- nrio2x.h --- */
/* ---------------- */

/*
* Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
* Univ Paris Sud XI, CNRS
*/

#ifndef __NRIO2X_H__
#define __NRIO2X_H__


/* ------------------------------ */
/* --- display_matrix_endline --- */
/* --- display_matrix_endline0 --- */
/* --- display_matrix_endline1 --- */
/* --- display_matrix_number_endline0 --- */
/* --- display_matrix_number_endline1 --- */
/* ------------------------------ */

#define display_type_matrix_endline(t) \
void short_name(t,display_,matrix_endline)(t ** m, int32_t i0, int32_t i1, int32_t j0, int32_t j1, char * format, char * name); \
void short_name(t,display_,matrix_endline0)(t ** m, int32_t i0, int32_t i1, int32_t j0, int32_t j1, char * format, char * name); \
void short_name(t,display_,matrix_endline1)(t ** m, int32_t i0, int32_t i1, int32_t j0, int32_t j1, char * format, char * name); \
void short_name(t,display_,matrix_number_endline0)(t ** m, int32_t i0, int32_t i1, int32_t j0, int32_t j1, char * format, char * name); \
void short_name(t,display_,matrix_number_endline1)(t ** m, int32_t i0, int32_t i1, int32_t j0, int32_t j1, char * format, char * name);

display_type_matrix_endline(int8_t);
display_type_matrix_endline(uint8_t);
display_type_matrix_endline(int16_t);
display_type_matrix_endline(uint16_t);
display_type_matrix_endline(int32_t);
display_type_matrix_endline(uint32_t);
display_type_matrix_endline(int64_t);
display_type_matrix_endline(uint64_t);


/* ------------------------- */
/* --- display_trimatrix --- */
/* ------------------------- */

#define display_type_trimatrix(t) \
void short_name(t,display_,trimatrix)(t ** m, int32_t i0, int32_t i1, int32_t j0, int32_t j1, int32_t step, char * format, char * name);

display_type_trimatrix(int8_t);
display_type_trimatrix(uint8_t);
display_type_trimatrix(int16_t);
display_type_trimatrix(uint16_t);
display_type_trimatrix(int32_t);
display_type_trimatrix(uint32_t);
display_type_trimatrix(int64_t);
display_type_trimatrix(uint64_t);
display_type_trimatrix(float);
display_type_trimatrix(double);




/* ----------------------- */
/* --- write_trimatrix --- */
/* --- write_matrix_endline --- */
/* --- write_imatrix_endline0 --- */
/* --- write_imatrix_endline1 --- */
/* --- write_imatrix_number_endline0 --- */
/* --- write_imatrix_number_endline1 --- */
/* -- fwrite_trimatrix -- */
/* -- fread_trimatrix -- */
/* ----------------------- */

#define write_type_trimatrix(t) \
void short_name(t,write_,trimatrix)(t ** m, int32_t i0, int32_t i1, int32_t j0, int32_t j1, int32_t step, char * format, char * filename); \
void short_name(t,write_,matrix_endline)(t ** m, int32_t i0, int32_t i1, int32_t j0, int32_t j1, char * format, char * filename); \
void short_name(t,write_,matrix_endline0)(t ** m, int32_t i0, int32_t i1, int32_t j0, int32_t j1, char * format, char * filename); \
void short_name(t,write_,matrix_endline1)(t ** m, int32_t i0, int32_t i1, int32_t j0, int32_t j1, char * format, char * filename); \
void short_name(t,write_,matrix_number_endline0)(t ** m, int32_t i0, int32_t i1, int32_t j0, int32_t j1, char * format, char * filename); \
void short_name(t,write_,matrix_number_endline1)(t ** m, int32_t i0, int32_t i1, int32_t j0, int32_t j1, char * format, char * filename); \
void short_name(t,fwrite_,trimatrix)(t ** m, int32_t i0, int32_t i1, int32_t j0, int32_t j1, int32_t step, char * filename); \
void short_name(t,fread_,trimatrix)(char * filename, t ** m, int32_t i0, int32_t i1, int32_t j0, int32_t j1, int32_t step);

write_type_trimatrix(int8_t);
write_type_trimatrix(uint8_t);
write_type_trimatrix(int16_t);
write_type_trimatrix(uint16_t);
write_type_trimatrix(int32_t);
write_type_trimatrix(uint32_t);
write_type_trimatrix(int64_t);
write_type_trimatrix(uint64_t);
write_type_trimatrix(float);
write_type_trimatrix(double);



#endif /* __NRIO2X_H__ */


// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:

// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

