/* ------------------ */
/* --- nrlinalg.c --- */
/* ------------------ */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
 *
 * Distributed under the Boost Software License, Version 1.0
 * see accompanying file LICENSE.txt or copy it at
 * http://www.boost.org/LICENSE_1_0.txt
 */

#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>

#include "mypredef.h"
#include "nrtype.h"
#include "nrdef.h"
#include "nrmacro.h"
#include "nrkernel.h"

#include "nrlinalg.h"

#undef transpose_type_matrix
#define transpose_type_matrix(t) \
void short_name(t,transpose_,matrix)(t ** S, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, t ** D) \
{                                              \
	for (int32_t i = nrl; i <= nch; i++) {     \
		for (int32_t j = ncl; j <= nch; j++) { \
			D[j][i] = S[i][j];                 \
		}                                      \
	}                                          \
}

transpose_type_matrix(int8_t);
transpose_type_matrix(uint8_t);
transpose_type_matrix(int16_t);
transpose_type_matrix(uint16_t);
transpose_type_matrix(int32_t);
transpose_type_matrix(uint32_t);
transpose_type_matrix(int64_t);
transpose_type_matrix(uint64_t);
transpose_type_matrix(float);
transpose_type_matrix(double);
transpose_type_matrix(rgb8);
transpose_type_matrix(rgbx8);


#undef transpose1_type_matrix
#define transpose1_type_matrix(t) \
void short_name(t,transpose1_,matrix)(t ** S, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch) \
{                                                \
    t tmp;                                       \
	for (int32_t i = nrl; i <= nch; i++) {       \
		for (int32_t j = i + 1; j <= nch; j++) { \
			tmp = S[j][i];                       \
            S[j][i] = S[i][j];                   \
            S[i][j] = tmp;                       \
		}                                        \
	}                                            \
}

transpose1_type_matrix(int8_t);
transpose1_type_matrix(uint8_t);
transpose1_type_matrix(int16_t);
transpose1_type_matrix(uint16_t);
transpose1_type_matrix(int32_t);
transpose1_type_matrix(uint32_t);
transpose1_type_matrix(int64_t);
transpose1_type_matrix(uint64_t);
transpose1_type_matrix(float);
transpose1_type_matrix(double);
transpose1_type_matrix(rgb8);
transpose1_type_matrix(rgbx8);




// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:

// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

