/* ---------------- */
/* --- nrio2x.c --- */
/* ---------------- */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
 */

#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>

#include "nrc_os_config.h"
#include "mypredef.h"
#include "nrtype.h"
#include "nrdef.h"
#include "nrmacro.h"
#include "nrkernel.h"

#include "nrio0.h"
#include "nralloc1.h"
#include "nralloc2.h"
#include "nrio1.h"
#include "nrio2.h"
#include "nrio2x.h"



/* ------------------------------ */
/* --- display_matrix_endline --- */
/* ------------------------------ */

#undef display_type_matrix_endline
#define display_type_matrix_endline(t) \
void short_name(t,display_,matrix_endline)(t ** m, int32_t i0, int32_t i1, int32_t j0, int32_t j1, char * format, char * name) \
{                                                \
    int32_t n = (i1 - i0 + 1) * (j1 - j0 + 1);   \
    t * p = &m[i0][j0];                          \
                                                 \
    if (name != NULL) {                          \
        printf(name);                            \
    }                                            \
                                                 \
    for (int32_t i = i0; i <= i1; i++) {         \
        for (int32_t j = j0; j <= j0 + n; j++) { \
            printf(format, *p++);                \
        }                                        \
        printf("\n");                            \
    }                                            \
    printf("\n");                                \
}

display_type_matrix_endline(int8_t);
display_type_matrix_endline(uint8_t);
display_type_matrix_endline(int16_t);
display_type_matrix_endline(uint16_t);
display_type_matrix_endline(int32_t);
display_type_matrix_endline(uint32_t);
display_type_matrix_endline(int64_t);
display_type_matrix_endline(uint64_t);


/* ------------------------------- */
/* --- display_matrix_endline0 --- */
/* ------------------------------- */

#undef display_type_matrix_endline0
#define display_type_matrix_endline0(t) \
void short_name(t,display_,matrix_endline0)(t ** m, int32_t i0, int32_t i1, int32_t j0, int32_t j1, char * format, char * name) \
{                                                \
    if (name != NULL) {                          \
        printf(name);                            \
    }                                            \
                                                 \
    for (int32_t i = i0; i <= i1; i++) {         \
        int32_t n = (int32_t) m[i][j0];          \
        for (int32_t j = j0; j <= j0 + n; j++) { \
            printf(format, m[i][j]);             \
        }                                        \
        printf("\n");                            \
    }                                            \
    printf("\n");                                \
}

display_type_matrix_endline0(int8_t);
display_type_matrix_endline0(uint8_t);
display_type_matrix_endline0(int16_t);
display_type_matrix_endline0(uint16_t);
display_type_matrix_endline0(int32_t);
display_type_matrix_endline0(uint32_t);
display_type_matrix_endline0(int64_t);
display_type_matrix_endline0(uint64_t);


/* ------------------------------- */
/* --- display_matrix_endline1 --- */
/* ------------------------------- */

#undef display_type_matrix_endline1
#define display_type_matrix_endline1(t) \
void short_name(t,display_,matrix_endline1)(t ** m, int32_t i0, int32_t i1, int32_t j0, int32_t j1, char * format, char * name) \
{                                                    \
    if (name != NULL) {                              \
        printf(name);                                \
    }                                                \
                                                     \
    for (int32_t i = i0; i <= i1; i++) {             \
        int32_t n = (int32_t) m[i][j0 - 1];          \
        for (int32_t j = j0; j <= j0 + n - 1; j++) { \
            printf(format, m[i][j]);                 \
        }                                            \
        printf("\n");                                \
    }                                                \
    printf("\n");                                    \
}

display_type_matrix_endline1(int8_t);
display_type_matrix_endline1(uint8_t);
display_type_matrix_endline1(int16_t);
display_type_matrix_endline1(uint16_t);
display_type_matrix_endline1(int32_t);
display_type_matrix_endline1(uint32_t);
display_type_matrix_endline1(int64_t);
display_type_matrix_endline1(uint64_t);


/* -------------------------------------- */
/* --- display_matrix_number_endline0 --- */
/* -------------------------------------- */

#undef display_type_matrix_number_endline0
#define display_type_matrix_number_endline0(t) \
void short_name(t,display_,matrix_number_endline0)(t ** m, int32_t i0, int32_t i1, int32_t j0, int32_t j1, char * format, char * name) \
{                                                    \
    if (name != NULL) {                              \
        printf(name);                                \
    }                                                \
                                                     \
    for (int32_t i = i0; i <= i1; i++) {             \
        printf("[%3d] ", i);                         \
        int32_t n = (int32_t) m[i][j0];              \
        for (int32_t j = j0; j <= j0 + n; j++) {     \
            printf(format, m[i][j]);                 \
        }                                            \
        printf("\n");                                \
    }                                                \
    printf("\n");                                    \
}

display_type_matrix_number_endline0(int8_t);
display_type_matrix_number_endline0(uint8_t);
display_type_matrix_number_endline0(int16_t);
display_type_matrix_number_endline0(uint16_t);
display_type_matrix_number_endline0(int32_t);
display_type_matrix_number_endline0(uint32_t);
display_type_matrix_number_endline0(int64_t);
display_type_matrix_number_endline0(uint64_t);


/* -------------------------------------- */
/* --- display_matrix_number_endline1 --- */
/* -------------------------------------- */

#undef display_type_matrix_number_endline1
#define display_type_matrix_number_endline1(t) \
void short_name(t,display_,matrix_number_endline1)(t ** m, int32_t i0, int32_t i1, int32_t j0, int32_t j1, char * format, char * name) \
{                                                    \
    if (name != NULL) {                              \
        printf(name);                                \
    }                                                \
                                                     \
    for (int32_t i = i0; i <= i1; i++) {             \
        printf("[%3d] ", i);                         \
        int32_t n = (int32_t) m[i][j0 - 1];          \
        for (int32_t j = j0; j <= j0 + n - 1; j++) { \
            printf(format, m[i][j]);                 \
        }                                            \
        printf("\n");                                \
    }                                                \
    printf("\n");                                    \
}

display_type_matrix_number_endline1(int8_t);
display_type_matrix_number_endline1(uint8_t);
display_type_matrix_number_endline1(int16_t);
display_type_matrix_number_endline1(uint16_t);
display_type_matrix_number_endline1(int32_t);
display_type_matrix_number_endline1(uint32_t);
display_type_matrix_number_endline1(int64_t);
display_type_matrix_number_endline1(uint64_t);


/* ------------------------- */
/* --- display_trimatrix --- */
/* ------------------------- */

#undef display_type_trimatrix
#define display_type_trimatrix(t) \
void short_name(t,display_,trimatrix)(t ** m, int32_t i0, int32_t i1, int32_t j0, int32_t j1, int32_t step, char * format, char * name) \
{                                                    \
    if (name != NULL) {                              \
        printf(name);                                \
    }                                                \
                                                     \
    for (int32_t i = i0; i <= i1; i++) {             \
        for (int32_t j = j0; j <= j1; j++) {         \
            printf(format, m[i][j]);                 \
        }                                            \
        printf("\n");                                \
        j1 += step;                                  \
    }                                                \
    printf("\n");                                    \
}

display_type_trimatrix(int8_t);
display_type_trimatrix(uint8_t);
display_type_trimatrix(int16_t);
display_type_trimatrix(uint16_t);
display_type_trimatrix(int32_t);
display_type_trimatrix(uint32_t);
display_type_trimatrix(int64_t);
display_type_trimatrix(uint64_t);
display_type_trimatrix(float);
display_type_trimatrix(double);


// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:

// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

