/* ---------------- */
/* --- nrmem1.c --- */
/* ---------------- */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
 *
 * Distributed under the Boost Software License, Version 1.0
 * see accompanying file LICENSE.txt or copy it at
 * http://www.boost.org/LICENSE_1_0.txt
 */

#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>
#include <math.h> // fabs

#include "mypredef.h"
#include "nrtype.h"
#include "nrdef.h"
#include "nrmacro.h"
#include "nrkernel.h"

#include "nrmem1.h"

/*
 * -----------
 * --- dup ---
 * -----------
 */


#undef dup_type_vector
#define dup_type_vector(t) \
void short_name(t,dup_,vector)(t * X, int32_t nl, int32_t nh, t * Y) \
{                                        \
    for (int32_t i = nl; i <= nh; i++) { \
        Y[i] = X[i];                     \
    }                                    \
}

dup_type_vector(int8_t);
dup_type_vector(uint8_t);
dup_type_vector(int16_t);
dup_type_vector(uint16_t);
dup_type_vector(int32_t);
dup_type_vector(uint32_t);
dup_type_vector(int64_t);
dup_type_vector(uint64_t);
dup_type_vector(float);
dup_type_vector(double);
dup_type_vector(rgb8);
dup_type_vector(rgbx8);


/*
 * --------------------
 * --- split_vector ---
 * --------------------
 */


void split_rgb8vector(rgb8 * X, int32_t nl, int32_t nh, uint8_t * R, uint8_t * G, uint8_t * B)
{
    for (int32_t i = nl; i <= nh; i++) {
        R[i] = X[i].r;
        G[i] = X[i].g;
        B[i] = X[i].b;
    }
}

void split_rgb32vector(rgb32 * X, int32_t nl, int32_t nh, uint32_t * R, uint32_t * G, uint32_t * B)
{
    for (int32_t i = nl; i <= nh; i++) {
        R[i] = X[i].r;
        G[i] = X[i].g;
        B[i] = X[i].b;
    }
}

void merge_rgb8vector(uint8_t * R, uint8_t * G, uint8_t * B, int32_t nl, int32_t nh, rgb8 * X)
{
    for (int32_t i = nl; i <= nh; i++) {
        X[i].r = R[i];
        X[i].g = G[i];
        X[i].b = B[i];
    }
}


void merge_rgb32vector(uint32_t * R, uint32_t * G, uint32_t * B, int32_t nl, int32_t nh, rgb32 * X)
{
    for (int32_t i = nl; i <= nh; i++) {
        X[i].r = R[i];
        X[i].g = G[i];
        X[i].b = B[i];
    }
}

/* ---------------- */
/* -- Conversion -- */
/* ---------------- */

#undef convert_type1_vector_type2_vector
#define convert_type1_vector_type2_vector(t1, t2) \
void short_name(t1,convert_,short_name(t2,vector_,vector))(t1 * X, int32_t nl, int32_t nh, t2 * Y) \
{                                        \
    for (int32_t i = nl; i <= nh; i++) { \
        Y[i] = (t2) X[i];                \
    }                                    \
}

convert_type1_vector_type2_vector(int8_t,int16_t);
convert_type1_vector_type2_vector(int8_t,int32_t);
convert_type1_vector_type2_vector(int8_t,float);
convert_type1_vector_type2_vector(int8_t,double);
convert_type1_vector_type2_vector(uint8_t,uint16_t);
convert_type1_vector_type2_vector(uint8_t,uint32_t);
convert_type1_vector_type2_vector(uint8_t,float);
convert_type1_vector_type2_vector(uint8_t,double);
convert_type1_vector_type2_vector(int16_t,int32_t);
convert_type1_vector_type2_vector(int16_t,float);
convert_type1_vector_type2_vector(int16_t,double);
convert_type1_vector_type2_vector(uint16_t,uint32_t);
convert_type1_vector_type2_vector(uint16_t,float);
convert_type1_vector_type2_vector(uint16_t,double);
convert_type1_vector_type2_vector(int32_t,float);
convert_type1_vector_type2_vector(int32_t,double);
convert_type1_vector_type2_vector(uint32_t,float);
convert_type1_vector_type2_vector(uint32_t,double);
convert_type1_vector_type2_vector(int16_t,int8_t);
convert_type1_vector_type2_vector(uint16_t,uint8_t);
convert_type1_vector_type2_vector(int32_t,int8_t);
convert_type1_vector_type2_vector(int32_t,int16_t);
convert_type1_vector_type2_vector(uint32_t,uint8_t);
convert_type1_vector_type2_vector(uint32_t,uint16_t);
convert_type1_vector_type2_vector(float,int8_t);
convert_type1_vector_type2_vector(float,uint8_t);
convert_type1_vector_type2_vector(float,int16_t);
convert_type1_vector_type2_vector(float,uint16_t);
convert_type1_vector_type2_vector(float,int32_t);
convert_type1_vector_type2_vector(float,uint32_t);
convert_type1_vector_type2_vector(double,int8_t);
convert_type1_vector_type2_vector(double,uint8_t);
convert_type1_vector_type2_vector(double,int16_t);
convert_type1_vector_type2_vector(double,uint16_t);
convert_type1_vector_type2_vector(double,int32_t);
convert_type1_vector_type2_vector(double,uint32_t);
convert_type1_vector_type2_vector(double,float);







void convert_ui8vector_rgb8vector(uint8_t * X, int32_t nl, int32_t nh, rgb8 * Y)
{
    for (int32_t i = nl; i <= nh; i++) {
        Y[i].r = X[i];
        Y[i].g = X[i];
        Y[i].b = X[i];
    }
}

void convert_ui8vector_rgbx8vector(uint8_t * X, int32_t nl, int32_t nh, rgbx8 * Y)
{
    for (int32_t i = nl; i <= nh; i++) {
        Y[i].r = X[i];
        Y[i].g = X[i];
        Y[i].b = X[i];
        Y[i].x = 255;
    }
}


void convert_rgb8vector_ui8vector(rgb8 * X, int32_t nl, int32_t nh, uint8_t * Y)
{
    for (int32_t i = nl; i <= nh; i++) {
        Y[i] = (X[i].r + X[i].g + X[i].b) / 3;
    }
}

void convert_rgbx8vector_ui8vector(rgbx8 * X, int32_t nl, int32_t nh, uint8_t * Y)
{
    for (int32_t i = nl; i <= nh; i++) {
        Y[i] = (X[i].r + X[i].g + X[i].b) / 3;
    }
}

/*
 * ---------------
 * --- LowPart ---
 * ---------------
 */

void lowpart_ui16vector_ui8vector(uint16_t * X, int32_t nl, int32_t nh, uint8_t * Y)
{
    for(int32_t i = nl; i <= nh; i++) {
        Y[i] = X[i] & 0xff;
    }
}

void lowpart_ui32vector_ui8vector(uint32_t * X, int32_t nl, int32_t nh, uint8_t * Y)
{
    for (int32_t i = nl; i <= nh; i++) {
        Y[i] = X[i] & 0xff;
    }
}


