/* --------------- */
/* --- nrio3.c --- */
/* --------------- */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
 *
 * Distributed under the Boost Software License, Version 1.0
 * see accompanying file LICENSE.txt or copy it at
 * http://www.boost.org/LICENSE_1_0.txt
 */

#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>

#include "nrc_os_config.h"
#include "mypredef.h"
#include "nrtype.h"
#include "nrdef.h"
#include "nrmacro.h"
#include "nrkernel.h"

#include "nralloc1.h"
#include "nrio3.h"


/* -------------------- */
/* --- display_cube --- */
/* -------------------- */

#undef display_type_cube
#define display_type_cube(t) \
void short_name(t,display_,cube)(t *** c, int32_t ndl, int32_t ndh, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, char * format, char * name) \
{                                                  \
    if (name != NULL) {                            \
        printf(name);                              \
    }                                              \
    for (int32_t k = ndl; k <= ndh; k++) {         \
        for (int32_t i = nrl; i <= nrh; i++) {     \
            for (int32_t j = ncl; j <= nch; j++) { \
                printf(format, c[k][i][j]);        \
            }                                      \
            printf("\n");                          \
        }                                          \
        printf("\n");                              \
    }                                              \
}

display_type_cube(int8_t);
display_type_cube(uint8_t);
display_type_cube(int16_t);
display_type_cube(uint16_t);
display_type_cube(int32_t);
display_type_cube(uint32_t);
display_type_cube(int64_t);
display_type_cube(uint64_t);
display_type_cube(float);
display_type_cube(double);



/* ---------------- */
/* -- write_cube -- */
/* ---------------- */

#undef write_type_cube
#define write_type_cube(t) \
void short_name(t,write_,cube)(t *** c, int32_t ndl, int32_t ndh, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, char * format, char * filename) \
{                                                                \
    FILE * f = fopen(filename, "wt");                            \
    if (f == NULL) {                                             \
        nrerror("Can't open file %s in %s", filename, __func__); \
    }                                                            \
    for (int32_t k = ndl; k <= ndh; k++) {                       \
        for (int32_t i = nrl; i <= nrh; i++) {                   \
            for (int32_t j = ncl; j <= nch; j++) {               \
                fprintf(f, format, c[k][i][j]);                  \
            }                                                    \
            fprintf(f, "\n");                                    \
        }                                                        \
        fprintf(f, "\n");                                        \
    }                                                            \
    fclose(f);                                                   \
}

write_type_cube(int8_t);
write_type_cube(uint8_t);
write_type_cube(int16_t);
write_type_cube(uint16_t);
write_type_cube(int32_t);
write_type_cube(uint32_t);
write_type_cube(int64_t);
write_type_cube(uint64_t);
write_type_cube(float);
write_type_cube(double);



/* ---------------- */
/* -- fread_cube -- */
/* ---------------- */

#undef fread_type_cube
#define fread_type_cube(t) \
void short_name(t,fread_,cube)(t *** c, int32_t ndl, int32_t ndh, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, char * format, char * filename) \
{                                                                     \
    int32_t ncol = nch - ncl + 1;                                     \
    FILE * f = fopen(filename, "rb");                                 \
    if (f == NULL) {                                                  \
        nrerror("Can't open file %s in %s", filename, __func__);      \
    }                                                                 \
    for (int32_t k = ndl; k <= ndh; k++) {                            \
        for (int32_t i = nrl; i <= nrh; i++) {                        \
            int32_t nread = fread(&c[k][i][ncl], sizeof(t), ncol, f); \
            if (nread != ncol) {                                      \
                nrerror("%s: Can't write data", __func__);            \
            }                                                         \
        }                                                             \
    }                                                                 \
    fclose(f);                                                        \
}

fread_type_cube(int8_t);
fread_type_cube(uint8_t);
fread_type_cube(int16_t);
fread_type_cube(uint16_t);
fread_type_cube(int32_t);
fread_type_cube(uint32_t);
fread_type_cube(int64_t);
fread_type_cube(uint64_t);
fread_type_cube(float);
fread_type_cube(double);






// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:

// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

