/* ---------------- */
/* --- nrset3.h --- */
/* ---------------- */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
*/

#ifndef _NR_SET3_H_
#define _NR_SET3_H_

// -----------------
// --- zero_cube ---
// -----------------

#define zero_type_cube(t) \
void short_name(t,zero_,cube)(t *** c, int32_t k0, int32_t k1, int32_t i0, int32_t i1, int32_t j0, int32_t j1);

zero_type_cube(int8_t);
zero_type_cube(uint8_t);
zero_type_cube(int16_t);
zero_type_cube(uint16_t);
zero_type_cube(int32_t);
zero_type_cube(uint32_t);
zero_type_cube(int64_t);
zero_type_cube(uint64_t);
zero_type_cube(float);
zero_type_cube(double);
zero_type_cube(rgb8);
zero_type_cube(rgbx8);


// ----------------------
// --- set_cube_param ---
// ----------------------

#define set_type_cube_param(t) \
void short_name(t,set_,cube_param)(t *** c, int32_t k0, int32_t k1, int32_t i0, int32_t i1, int32_t j0, int32_t j1, t x, t xstep, t ystep, t zstep);

set_type_cube_param(int8_t);
set_type_cube_param(uint8_t);
set_type_cube_param(int16_t);
set_type_cube_param(uint16_t);
set_type_cube_param(int32_t);
set_type_cube_param(uint32_t);
set_type_cube_param(int64_t);
set_type_cube_param(uint64_t);
set_type_cube_param(float);
set_type_cube_param(double);
set_type_cube_param(rgb8);
set_type_cube_param(rgbx8);



#endif // _NR_SET3_H_

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:

// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

