/* ----------------- */
/* --- nrwrap1.h --- */
/* ----------------- */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
* 
*/


#ifndef _NR_WRAP1_H_
#define _NR_WRAP1_H_


// ------------------------------- //
// --- vector_map (allocation) --- //
// ------------------------------- //

// map allocation = nothing to do in 1D

IMAGE_EXPORT(sint8*)    si8vector_map(int nl, int nh);
IMAGE_EXPORT(uint8*)    ui8vector_map(int nl, int nh);
IMAGE_EXPORT(sint16*)  si16vector_map(int nl, int nh);
IMAGE_EXPORT(uint16*)  ui16vector_map(int nl, int nh);
IMAGE_EXPORT(sint32*)  si32vector_map(int nl, int nh);
IMAGE_EXPORT(uint32*)  ui32vector_map(int nl, int nh);

IMAGE_EXPORT(float32*)  f32vector_map(int nl, int nh);
IMAGE_EXPORT(float64*)  f64vector_map(int nl, int nh);

IMAGE_EXPORT(rgb8*)    rgb8vector_map(int nl, int nh);
IMAGE_EXPORT(rgbx8*)  rgbx8vector_map(int nl, int nh);

// ------------------ //
// --- Mapping 1D --- //
// ------------------ //

IMAGE_EXPORT(sint8*)   si8vector_map_1D_pitch(sint8   *v, int nl, int nh, void *data_1D, int pitch);
IMAGE_EXPORT(uint8*)   ui8vector_map_1D_pitch(uint8   *v, int nl, int nh, void *data_1D, int pitch);
IMAGE_EXPORT(sint16*) si16vector_map_1D_pitch(sint16  *v, int nl, int nh, void *data_1D, int pitch);
IMAGE_EXPORT(uint16*) ui16vector_map_1D_pitch(uint16  *v, int nl, int nh, void *data_1D, int pitch);
IMAGE_EXPORT(sint32*) si32vector_map_1D_pitch(sint32  *v, int nl, int nh, void *data_1D, int pitch);
IMAGE_EXPORT(uint32*) ui32vector_map_1D_pitch(uint32  *v, int nl, int nh, void *data_1D, int pitch);

IMAGE_EXPORT(float32*) f32vector_map_1D_pitch(float32 *v, int nl, int nh, void *data_1D, int pitch);
IMAGE_EXPORT(float64*) f64vector_map_1D_pitch(float64 *v, int nl, int nh, void *data_1D, int pitch);

IMAGE_EXPORT(rgb8*)   rgb8vector_map_1D_pitch(rgb8    *v, int nl, int nh, void *data_1D, int pitch);
IMAGE_EXPORT(rgbx8*) rgbx8vector_map_1D_pitch(rgbx8   *v, int nl, int nh, void *data_1D, int pitch);

#endif // _NR_WRAP1_H_

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:

// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

