/* ---------------- */
/* --- nrset1.c --- */
/* ---------------- */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
 *
 * Distributed under the Boost Software License, Version 1.0
 * see accompanying file LICENSE.txt or copy it at
 * http://www.boost.org/LICENSE_1_0.txt
 */

/* 
 * 2002/06/11 ajout des fonctions endline
 */

#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>

#include "mypredef.h"
#include "nrtype.h"
#include "nrdef.h"
#include "nrmacro.h"
#include "nrkernel.h"

#include "nrset1.h"

#define isdigit(x) ((x) >= 0x30 && (x) <= 0x39)

/*
 * -------------------
 * --- zero_vector ---
 * -------------------
 */


#undef zero_type_vector
#define zero_type_vector(t) \
void short_name(t,zero_,vector)(t * v, int32_t nl, int32_t nh) \
{                                        \
    for (int32_t i = nl; i <= nh; i++) { \
        v[i] = 0;                        \
    }                                    \
}

zero_type_vector(int8_t);
zero_type_vector(uint8_t);
zero_type_vector(int16_t);
zero_type_vector(uint16_t);
zero_type_vector(int32_t);
zero_type_vector(uint32_t);
zero_type_vector(int64_t);
zero_type_vector(uint64_t);
zero_type_vector(float);
zero_type_vector(double);


void zero_rgb8vector(rgb8 * v, int32_t nl, int32_t nh)
{
    rgb8 z = {0, 0, 0};
    for (int32_t i = nl; i <= nh; i++) {
        v[i] = z;
    }
}

void zero_rgbx8vector(rgbx8 * v, int32_t nl, int32_t nh)
{
    rgbx8 z;
    z.r = 0;
    z.g = 0;
    z.b = 0;
    z.x = 0;
    for (int32_t i = nl; i <= nh; i++) {
        v[i] = z;
    }
}


/*
 * ------------------
 * --- set_vector ---
 * ------------------
 */


#undef set_type_vector
#define set_type_vector(t) \
void short_name(t,set_,vector)(t * v, int32_t nl, int32_t nh, t x) \
{                                        \
    for (int32_t i = nl; i <= nh; i++) { \
        v[i] = x;                        \
    }                                    \
}

set_type_vector(int8_t);
set_type_vector(uint8_t);
set_type_vector(int16_t);
set_type_vector(uint16_t);
set_type_vector(int32_t);
set_type_vector(uint32_t);
set_type_vector(int64_t);
set_type_vector(uint64_t);
set_type_vector(float);
set_type_vector(double);
set_type_vector(rgb8);
set_type_vector(rgbx8);



/*
 * ------------------------
 * --- set_vector_param ---
 * ------------------------
 */


#undef set_type_vector_param
#define set_type_vector_param(t) \
void short_name(t,set_,vector_param)(t * v, int32_t nl, int32_t nh, t x, t xstep) \
{                                        \
    for (int32_t i = nl; i <= nh; i++) { \
        v[i] = x;                        \
        x += xstep;                      \
    }                                    \
}

set_type_vector_param(int8_t);
set_type_vector_param(uint8_t);
set_type_vector_param(int16_t);
set_type_vector_param(uint16_t);
set_type_vector_param(int32_t);
set_type_vector_param(uint32_t);
set_type_vector_param(int64_t);
set_type_vector_param(uint64_t);
set_type_vector_param(float);
set_type_vector_param(double);



void set_rgb8vector_param(rgb8 * v, int32_t nl, int32_t nh, rgb8 x, rgb8 xstep)
{
    for (int32_t i = nl; i <= nh; i++) {
        v[i] = x;
        RGB8_ADD(x, xstep, x);
    }
}

void set_rgbx8vector_param(rgbx8 * v, int32_t nl, int32_t nh, rgbx8 x, rgbx8 xstep)
{
    for (int32_t i = nl; i <= nh; i++) {
        v[i] = x;
        RGBX8_ADD(x, xstep, x);
    }
}


/*
 * --------------------
 * --- set_vector_j ---
 * --------------------
 */

#undef set_type_vector_j
#define set_type_vector_j(t) \
void short_name(t,set_,vector_j)(t * v, int32_t nl, int32_t nh) \
{                                                               \
    for (int32_t i = nl; i <= nh; i++) {                        \
        v[i] = (t) i;                                           \
    }                                                           \
}

set_type_vector_j(int8_t);
set_type_vector_j(uint8_t);
set_type_vector_j(int16_t);
set_type_vector_j(uint16_t);
set_type_vector_j(int32_t);
set_type_vector_j(uint32_t);
set_type_vector_j(int64_t);
set_type_vector_j(uint64_t);
set_type_vector_j(float);
set_type_vector_j(double);


void set_rgb8vector_j(rgb8 * v, int32_t nl, int32_t nh)
{
    for (int32_t i = nl; i <= nh; i++) {
        v[i].r = (uint8) i;
        v[i].g = (uint8) i;
        v[i].b = (uint8) i;
    }
}


void set_rgbx8vector_j(rgbx8 * v, int32_t nl, int32_t nh)
{
    for (int32_t i = nl; i <= nh; i++) {
        v[i].r = (uint8) i;
        v[i].g = (uint8) i;
        v[i].b = (uint8) i;
        v[i].x = (uint8) 255;
    }
}


/*
 * ----------------------
 * --- set_vector_str ---
 * ----------------------
 */


#undef set_type_vector_str
#define set_type_vector_str(t) \
void short_name(t,set_,vector_str)(t * v, int32_t nl, int32_t nh, char * str) \
{                                        \
    char c[2];                           \
    c[1] = '\0';                         \
    for (int32_t i = nl; i <= nh; i++) { \
        c[0] = *str++;                   \
        if (isdigit(c[0])) {             \
            v[i] = (t) atoi(c);          \
        }                                \
        else {                           \
            v[i] = (t) 0;                \
        }                                \
    }                                    \
}

set_type_vector_str(int8_t);
set_type_vector_str(uint8_t);
set_type_vector_str(int16_t);
set_type_vector_str(uint16_t);
set_type_vector_str(int32_t);
set_type_vector_str(uint32_t);
set_type_vector_str(int64_t);
set_type_vector_str(uint64_t);


// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:

// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

