/* ---------------- */
/* --- nrset2.h --- */
/* ---------------- */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
*/

#ifndef _NR_SET2_H_
#define _NR_SET2_H_


/* ------------------
 * --- set_matrix ---
 * --- set_matrix_param ---
 * ------------------
 */

/*
 * --------------------
 * --- set_matrix_i ---
 * --------------------
 */

/*
 *  [i0 .. i0]     [1 1 1]   
 * m[...    ...] = [2 2 2]
 *  [i1 .. i1]     [3 3 3]   
 */

/*
 * --------------------
 * --- set_matrix_j ---
 * --------------------
 */

 /*
  *  [j0 .. j1]     [1 2 3]   
  * m[... .. ...] = [1 2 3]
  *  [j0 .. j1]     [1 2 3]   
  */

#define set_type_matrix(t) \
void short_name(t,zero_,matrix)(t ** m, int32_t i0, int32_t i1, int32_t j0, int32_t j1); \
void short_name(t,set_,matrix)(t ** m, int32_t i0, int32_t i1, int32_t j0, int32_t j1, t x); \
void short_name(t,set_,matrix_param)(t ** m, int32_t i0, int32_t i1, int32_t j0, int32_t j1, t x, t xstep, t ystep); \
void short_name(t,set_,matrix_i)(t ** m, int32_t i0, int32_t i1, int32_t j0, int32_t j1); \
void short_name(t,set_,matrix_j)(t ** m, int32_t i0, int32_t i1, int32_t j0, int32_t j1);


set_type_matrix(int8_t);
set_type_matrix(uint8_t);
set_type_matrix(int16_t);
set_type_matrix(uint16_t);
set_type_matrix(int32_t);
set_type_matrix(uint32_t);
set_type_matrix(int64_t);
set_type_matrix(uint64_t);
set_type_matrix(float);
set_type_matrix(double);
set_type_matrix(rgb8);
set_type_matrix(rgbx8);



/*
 * Initialisation des bords
 */

#define set_type_matrix_border(t) \
void short_name(t,set_,matrix_border)(t ** m, int32_t i0, int32_t i1, int32_t j0, int32_t j1, int32_t n, t x); \
void short_name(t,set_,matrix_border1)(t ** m, int32_t i0, int32_t i1, int32_t j0, int32_t j1, t x);

set_type_matrix_border(int8_t);
set_type_matrix_border(uint8_t);
set_type_matrix_border(int16_t);
set_type_matrix_border(uint16_t);
set_type_matrix_border(int32_t);
set_type_matrix_border(uint32_t);
set_type_matrix_border(int64_t);
set_type_matrix_border(uint64_t);
set_type_matrix_border(float);
set_type_matrix_border(double);



#endif // _NR_SET2_H_

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:

// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

