/* ----------------- */
/* --- nrset2X.c --- */
/* ----------------- */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
 *
 * Distributed under the Boost Software License, Version 1.0
 * see accompanying file LICENSE.txt or copy it at
 * http://www.boost.org/LICENSE_1_0.txt
 */


#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>

#include "mypredef.h"
#include "nrtype.h"
#include "nrtypex.h"
#include "nrdef.h"
#include "nrmacro.h"
#include "nrkernel.h"

#include "nrset1.h"
#include "nrset2.h"
#include "nrset2x.h"


#undef zero_type_matrix
#define zero_type_matrix(t) \
void short_name(t,zero_,matrix)(t ** m, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch) \
{                                              \
    t * mi;                                    \
    for (int32_t i = nrl; i <= nrh; i++) {     \
        mi = m[i];                             \
        for (int32_t j = ncl; j <= nch; j++) { \
            mi[j].x = 0;                       \
            mi[j].y = 0;                       \
            INIT_Z;                            \
        }                                      \
    }                                          \
}

#define INIT_Z
zero_type_matrix(si16Point);
zero_type_matrix(ui16Point);
zero_type_matrix(si32Point);
zero_type_matrix(ui32Point);
zero_type_matrix(f32Point);
#undef INIT_Z
#define INIT_Z ({ mi[j].z = 0; })
zero_type_matrix(si16Triplet);
zero_type_matrix(ui16Triplet);
zero_type_matrix(si32Triplet);
zero_type_matrix(ui32Triplet);
zero_type_matrix(f32Triplet);



// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:

// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

