#!/dsk/l1/misc/meunier/tools/bin/python3
# -*- coding: utf-8 -*-

# Note:
# This code requires python 3, and I haven't found
# a proper way of mixing python 2 and 3 without using
# the she/bang line at the top, which includes a local
# path...

from __future__ import print_function
import os
import sys
import re
import subprocess
import shutil
import filecmp
import random
import math

from stack import Stack

from common import *

# Creates graphes for random images with a density varying from 0 to 100%


with_features = True

threads = [1, 4, 16, 64]
use_dsk = True
img_size = 2048
granularities = [1, 4, 16]
rand_seed = 7

top_path = os.path.abspath(os.path.join(os.path.dirname(os.path.realpath(__file__)), ".."))
scripts_path  = os.path.join(top_path, 'scripts')
pyconf_file   = os.path.join(scripts_path, "config.py")

base_data_dir  = "data_2016_09_21"    # For timing information extracted
base_graph_dir = "graphes" # For storing generated graphes


# if with_features, each of these configuration must have been run with both features activated and deactivated
configs = [
        #{'SLOW':'1', 'FAST':'0', 'PARMERGE':'0', 'ARSP':'0'},
        {'SLOW':'0', 'FAST':'1', 'PARMERGE':'0', 'ARSP':'0'},
        {'SLOW':'0', 'FAST':'1', 'PARMERGE':'1', 'ARSP':'0'},
        {'SLOW':'0', 'FAST':'1', 'PARMERGE':'1', 'ARSP':'1'},
]


# Loading config file
with open(pyconf_file) as f:
    code = compile(f.read(), pyconf_file, 'exec')
    exec(code)

nb_step = 0

if use_dsk:
    try:
        dsk_dir
        if not os.path.exists(dsk_dir):
            print("*** Warning: variable dsk_dir is not defined in %s file; using current directory for reading data files" % (short_path(pyconf_file)))
            use_dsk = False
    except OSError:
        print("*** Warning: directory %s does not exist; using current directory for reading data files" % (dsk_dir))
        use_dsk = False

# Updating output directories
if use_dsk:
    data_dir     = os.path.join(dsk_dir, base_data_dir)
    graph_dir    = os.path.join(dsk_dir, base_graph_dir)
else:
    data_dir   = os.path.join(scripts_path, base_data_dir)
    graph_dir  = os.path.join(scripts_path, base_graph_dir)



if not os.path.exists(graph_dir):
    my_mkdir(graph_dir)



if with_features:
    features = ["FT", "NF"] # Features and No-Features
else:
    features = ["NF"] # No features only


# Phase 1: Extracting execution times
exec_time = {}
for config in configs:
    fconfig = frozenset(config.items())
    exec_time[fconfig] = {}
    for thread in threads:
        exec_time[fconfig][thread] = {}
        for granularity in granularities:
            exec_time[fconfig][thread][granularity] = {}
            for ftrs in features: # Features or No features
                exec_time[fconfig][thread][granularity][ftrs] = {}
                for density in range(0, 101):
                    exec_time[fconfig][thread][granularity][ftrs][density] = {}
                    random_img_file = get_random_img_file(density, img_size, img_size, granularity, rand_seed)
                    #random_img_file = get_short_random_img_file(density, granularity)
                    img_basename = os.path.splitext(random_img_file)[0]
                    log_file = get_filename(data_dir, thread, config, ftrs == "FT", img_basename)
                    lines = open(log_file, 'r')
                    for line in lines:
                        tokens = line.split()
                        if len(tokens) == 0:
                            continue
                        tag = tokens[0]
                        pattern = re.compile('\[STEP_([0-9]+)\]')
                        match = pattern.match(tag)
                        if match:
                            step = int(match.group(1))
                            nb_step = max(int(step) + 1, nb_step)
                            value = tokens[len(tokens) - 1]
                            exec_time[fconfig][thread][granularity][ftrs][density][step] = value
                            #print("exec_time[fconfig][%d][%d][%s][%d][%s] = %s" % (thread, granularity, ftrs, density, step, exec_time[fconfig][thread][granularity][ftrs][density][step]))

                    

# Phase 2: Creating plots
for config in configs:
    fconfig = frozenset(config.items())
    for thread in threads:
        for granularity in granularities:
            plotter = Stack(["red", "blue", "green", "orange", "pink", "purple"], "Légende", "X", "Y")
            X = [x for x in range(0, 101)]
            plotter.add_x(X)
            assert(nb_step == 5)
            # Parallel Labeling
            YPAR1 = [float(int(exec_time[fconfig][thread][granularity]["NF"][density][0]) / math.pow(img_size, 2)) for density in range(0, 101)]
            # Merging (Parallel or Pyramidal)
            YPAR2 = [float(int(exec_time[fconfig][thread][granularity]["NF"][density][1]) / math.pow(img_size, 2)) for density in range(0, 101)]
            # Parallel Transitive Closure
            YPTC2 = [float(int(exec_time[fconfig][thread][granularity]["NF"][density][2]) / math.pow(img_size, 2)) for density in range(0, 101)]
            # Propagate Features if Features and ARSP, nothing otherwise
            YPRF2 = [float(int(exec_time[fconfig][thread][granularity]["NF"][density][3]) / math.pow(img_size, 2)) for density in range(0, 101)]
            # Parallel Relabelling
            YPAR3 = [float(int(exec_time[fconfig][thread][granularity]["NF"][density][4]) / math.pow(img_size, 2)) for density in range(0, 101)]

            plotter.add_y(YPAR1)
            plotter.add_y(YPAR2)
            plotter.add_y(YPTC2)
            plotter.add_y(YPRF2)
            # displaying PAR3
            plotter.add_y(YPAR3)

            if with_features:
                YPAR1F = [float(int(exec_time[fconfig][thread][granularity]["FT"][density][0]) / math.pow(img_size, 2)) for density in range(0, 101)]
                YPAR2F = [float(int(exec_time[fconfig][thread][granularity]["FT"][density][1]) / math.pow(img_size, 2)) for density in range(0, 101)]
                YPTC2F = [float(int(exec_time[fconfig][thread][granularity]["FT"][density][2]) / math.pow(img_size, 2)) for density in range(0, 101)]
                YPRF2F = [float(int(exec_time[fconfig][thread][granularity]["FT"][density][3]) / math.pow(img_size, 2)) for density in range(0, 101)]
                YPAR3F = [float(int(exec_time[fconfig][thread][granularity]["FT"][density][4]) / math.pow(img_size, 2)) for density in range(0, 101)]
                TotalNF = [x + y + z + t + u for x, y, z, t, u in zip(YPAR1, YPAR2, YPTC2, YPRF2, YPAR3)]     # Total No Features
                TotalFT = [x + y + z + t + u for x, y, z, t, u in zip(YPAR1F, YPAR2F, YPTC2F, YPRF2F, YPAR3F)] # Total with Features
                YFCT = [max(0, x - y) for x, y in zip(TotalFT, TotalNF)] # Difference = Features Computation Time
                plotter.add_y(YFCT)

            plotter.plot()
            graph_name = get_graph_filename(graph_dir, thread, granularity, config, ".pdf")
            print("# Creating graph %s" % short_path(graph_name))
            plotter.save(graph_name)






