
/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
*/

#ifndef _NRMEM2XX_H_
#define _NRMEM2XX_H_


/* ----------------------- */
/* -- Rotation and Flip -- */
/* ----------------------- */

// no check performed on size, S and D must be different


#define rotate_flip_type_matrix(t) \
void short_name(t,lrotate_,matrix)(t ** S, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, t ** D); \
void short_name(t,rrotate_,matrix)(t ** S, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, t ** D); \
void short_name(t,lrotate1_,matrix)(t ** S, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch); \
void short_name(t,rrotate1_,matrix)(t ** S, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch); \
void short_name(t,hflip_,matrix)(t ** S, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, t ** D); \
void short_name(t,vflip_,matrix)(t ** S, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, t ** D); \
void short_name(t,hflip1_,matrix)(t ** S, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch); \
void short_name(t,vflip1_,matrix)(t ** S, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch);

rotate_flip_type_matrix(int8_t);
rotate_flip_type_matrix(uint8_t);
rotate_flip_type_matrix(int16_t);
rotate_flip_type_matrix(uint16_t);
rotate_flip_type_matrix(int32_t);
rotate_flip_type_matrix(uint32_t);
rotate_flip_type_matrix(int64_t);
rotate_flip_type_matrix(uint64_t);
rotate_flip_type_matrix(float);
rotate_flip_type_matrix(double);
rotate_flip_type_matrix(rgb8);
rotate_flip_type_matrix(rgbx8);


#endif /* _NRMEM2XX_H_ */

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:

// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

