/* ---------------- */
/* --- nrset1.h --- */
/* ---------------- */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
*/

#ifndef _NRSET1_H_
#define _NRSET1_H_


/*
 * ------------
 * --- Zero ---
 * --- set_vector ---
 * --- set_vector_param ---
 * --- set_vector_j ---
 * ------------
 */

#define zero_set_type_vector(t) \
void short_name(t,zero_,vector)(t * v, int32_t nl, int32_t nh); \
void short_name(t,set_,vector)(t * v, int32_t nl, int32_t nh, t x); \
void short_name(t,set_,vector_param)(t * v, int32_t nl, int32_t nh, t x, t xstep); \
void short_name(t,set_,vector_j)(t * v, int32_t nl, int32_t nh);

zero_set_type_vector(int8_t);
zero_set_type_vector(uint8_t);
zero_set_type_vector(int16_t);
zero_set_type_vector(uint16_t);
zero_set_type_vector(int32_t);
zero_set_type_vector(uint32_t);
zero_set_type_vector(int64_t);
zero_set_type_vector(uint64_t);
zero_set_type_vector(float);
zero_set_type_vector(double);
zero_set_type_vector(rgb8);
zero_set_type_vector(rgbx8);


/*
 * ----------------------
 * --- set_vector_str ---
 * ----------------------
 */

#define set_type_vector_str(t) \
void short_name(t,set_,vector_str)(t * v, int32_t nl, int32_t nh, char * str);

set_type_vector_str(int8_t);
set_type_vector_str(uint8_t);
set_type_vector_str(int16_t);
set_type_vector_str(uint16_t);
set_type_vector_str(int32_t);
set_type_vector_str(uint32_t);
set_type_vector_str(int64_t);
set_type_vector_str(uint64_t);


#endif /* __NRSET1_H__ */

