/* ---------------- */
/* --- nrmem2.h --- */
/* ---------------- */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
*/

#ifndef _NRMEM2_H_
#define _NRMEM2_H_

/*
 * ------------------
 * --- dup_matrix ---
 * ------------------
 */

#define dup_type_matrix(t) \
void short_name(t,dup_,matrix)(t ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, t ** Y);

dup_type_matrix(int8_t);
dup_type_matrix(uint8_t);
dup_type_matrix(int16_t);
dup_type_matrix(uint16_t);
dup_type_matrix(int32_t);
dup_type_matrix(uint32_t);
dup_type_matrix(int64_t);
dup_type_matrix(uint64_t);
dup_type_matrix(float);
dup_type_matrix(double);
dup_type_matrix(rgb8);
dup_type_matrix(rgbx8);



/*
 * --------------
 * --- resize ---
 * --------------
 */

#undef resize_type_matrix
#define resize_type_matrix(t) \
void short_name(t,resize_,matrix)(t ** m, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch);

resize_type_matrix(int8_t);
resize_type_matrix(uint8_t);
resize_type_matrix(int16_t);
resize_type_matrix(uint16_t);
resize_type_matrix(int32_t);
resize_type_matrix(uint32_t);
resize_type_matrix(int64_t);
resize_type_matrix(uint64_t);
resize_type_matrix(float);
resize_type_matrix(double);
resize_type_matrix(rgb8);
resize_type_matrix(rgbx8);



/*
 * ----------------------
 * --- convert matrix ---
 * ----------------------
 */

#define convert_type_matrix(t1,t2) \
void short_name(t1,convert_,short_name(t2,matrix_,matrix))(t1 ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, t2 ** Y);

convert_type_matrix(int8_t,int16_t);
convert_type_matrix(int8_t,int32_t);
convert_type_matrix(int8_t,float);
convert_type_matrix(int8_t,double);
convert_type_matrix(uint8_t,uint16_t);
convert_type_matrix(uint8_t,uint32_t);
convert_type_matrix(uint8_t,float);
convert_type_matrix(uint8_t,double);
convert_type_matrix(uint8_t,rgb8);
convert_type_matrix(uint8_t,rgbx8);
convert_type_matrix(int16_t,int32_t);
convert_type_matrix(int16_t,float);
convert_type_matrix(int16_t,double);
convert_type_matrix(uint16_t,uint32_t);
convert_type_matrix(uint16_t,float);
convert_type_matrix(uint16_t,double);
convert_type_matrix(int32_t,float);
convert_type_matrix(int32_t,double);
convert_type_matrix(uint32_t,float);
convert_type_matrix(uint32_t,double);

convert_type_matrix(int16_t,int8_t);
convert_type_matrix(uint16_t,uint8_t);
convert_type_matrix(int32_t,int8_t);
convert_type_matrix(uint32_t,uint8_t);
convert_type_matrix(int32_t,int16_t);
convert_type_matrix(uint32_t,uint16_t);
convert_type_matrix(float,int8_t);
convert_type_matrix(float,uint8_t);
convert_type_matrix(float,int16_t);
convert_type_matrix(float,uint16_t);
convert_type_matrix(float,int32_t);
convert_type_matrix(float,uint32_t);
convert_type_matrix(double,int8_t);
convert_type_matrix(double,uint8_t);
convert_type_matrix(double,int16_t);
convert_type_matrix(double,uint16_t);
convert_type_matrix(double,int32_t);
convert_type_matrix(double,uint32_t);
convert_type_matrix(double,float);
convert_type_matrix(rgb8,uint8_t);



/*
 * ----------------------
 * --- lowpart_matrix ---
 * ----------------------
 */

void lowpart_ui16matrix_ui8matrix(uint16_t ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, uint8_t ** Y);
void lowpart_ui32matrix_ui8matrix(uint32_t ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, uint8_t ** Y);


/*
 * -------------------
 * --- split-merge ---
 * -------------------
 */

void split_rgb8matrix(rgb8 ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, uint8_t ** R, uint8_t ** G, uint8_t ** B);
void merge_rgb8matrix(uint8_t ** R, uint8_t ** G, uint8_t ** B, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, rgb8 ** X);

#endif /* _NRMEM2_H_ */

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:

// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

