/* ----------------- */
/* --- nrmem2x.h --- */
/* ----------------- */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
* 
*/

#ifndef _NRMEM2X_H_
#define _NRMEM2X_H_


/* ------------------------------------------ */
/* --- ATTENTION ---------------------------- */
/* ------------------------------------------ */
/* l'utilisation des fonctions endline        */
/* necessite l'allocation d'une ligne de plus */
/* (a cause du m[i+1]                         */
/* ------------------------------------------ */

#define reset_endline_type_matrix(t) \
void short_name(t,reset_endline_,matrix)(t ** m, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch); \
void short_name(t,endline_,matrix)(t ** m, int32_t i, int32_t l); \
void short_name(t,endline0_,matrix)(t ** m, int32_t i, int32_t l, int32_t ncl); \
void short_name(t,endline1_,matrix)(t ** m, int32_t i, int32_t l, int32_t ncl);

reset_endline_type_matrix(int8_t);
reset_endline_type_matrix(uint8_t);
reset_endline_type_matrix(int16_t);
reset_endline_type_matrix(uint16_t);
reset_endline_type_matrix(int32_t);
reset_endline_type_matrix(uint32_t);
reset_endline_type_matrix(int64_t);
reset_endline_type_matrix(uint64_t);


#undef resize_type_matrix
#define resize_type_matrix(t) \
void short_name(t,resize_,matrix)(t ** m, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch);

resize_type_matrix(si16Point);
resize_type_matrix(ui16Point);
resize_type_matrix(si32Point);
resize_type_matrix(ui32Point);
resize_type_matrix(f32Point);
resize_type_matrix(si16Triplet);
resize_type_matrix(ui16Triplet);
resize_type_matrix(si32Triplet);
resize_type_matrix(ui32Triplet);
resize_type_matrix(f32Triplet);


#define type_matrix_reverse(t) \
void short_name(t,,matrix_reverse)(t ** m, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch);

type_matrix_reverse(int8_t);
type_matrix_reverse(uint8_t);
type_matrix_reverse(int16_t);
type_matrix_reverse(uint16_t);
type_matrix_reverse(int32_t);
type_matrix_reverse(uint32_t);
type_matrix_reverse(int64_t);
type_matrix_reverse(uint64_t);
type_matrix_reverse(float);
type_matrix_reverse(double);



#define desinterlace_type_matrix(t) \
void short_name(t,desinterlace_,matrix)(t ** S, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, t ** D0, t ** D1);

desinterlace_type_matrix(int8_t);
desinterlace_type_matrix(uint8_t);
desinterlace_type_matrix(int16_t);
desinterlace_type_matrix(uint16_t);
desinterlace_type_matrix(int32_t);
desinterlace_type_matrix(uint32_t);
desinterlace_type_matrix(int64_t);
desinterlace_type_matrix(uint64_t);
desinterlace_type_matrix(float);
desinterlace_type_matrix(double);
desinterlace_type_matrix(rgb8);
desinterlace_type_matrix(rgbx8);


#define interlace_type_matrix(t) \
void short_name(t,interlace_,matrix)(t ** S0, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, t ** S1, t ** D);

interlace_type_matrix(int8_t);
interlace_type_matrix(uint8_t);
interlace_type_matrix(int16_t);
interlace_type_matrix(uint16_t);
interlace_type_matrix(int32_t);
interlace_type_matrix(uint32_t);
interlace_type_matrix(int64_t);
interlace_type_matrix(uint64_t);
interlace_type_matrix(float);
interlace_type_matrix(double);
interlace_type_matrix(rgb8);
interlace_type_matrix(rgbx8);


#define copyc_type_matrix(t) \
void short_name(t,copyc_,matrix)(t ** src, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, t ** cond, t c, t ** dst) \

/*
 * copie dans src->dst si la condition est remplie
 * dst(i,j) = src(i,j) si cond(i,j) == c
 */

copyc_type_matrix(int8_t);
copyc_type_matrix(uint8_t);
copyc_type_matrix(int16_t);
copyc_type_matrix(uint16_t);
copyc_type_matrix(int32_t);
copyc_type_matrix(uint32_t);
copyc_type_matrix(int64_t);
copyc_type_matrix(uint64_t);
copyc_type_matrix(float);
copyc_type_matrix(double);
copyc_type_matrix(rgb8);
copyc_type_matrix(rgbx8);


#define complete_border_type_matrix(t) \
void short_name(t,complete_border_,matrix)(t ** m, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, int32_t n); \
void short_name(t,complete_border1_,matrix)(t ** m, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch); \
void short_name(t,complete_border2_,matrix)(t ** m, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch);

complete_border_type_matrix(int8_t);
complete_border_type_matrix(uint8_t);
complete_border_type_matrix(int16_t);
complete_border_type_matrix(uint16_t);
complete_border_type_matrix(int32_t);
complete_border_type_matrix(uint32_t);
complete_border_type_matrix(int64_t);
complete_border_type_matrix(uint64_t);
complete_border_type_matrix(float);
complete_border_type_matrix(double);
complete_border_type_matrix(rgb8);
complete_border_type_matrix(rgbx8);


#define copy1c_type_matrix(t) \
void short_name(t,copy1c_,matrix)(t ** X, int32_t nc, t ** Y, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch); \
void short_name(t,copy1r_,matrix)(t ** X, int32_t nr, t ** Y, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch);

copy1c_type_matrix(int8_t);
copy1c_type_matrix(uint8_t);
copy1c_type_matrix(int16_t);
copy1c_type_matrix(uint16_t);
copy1c_type_matrix(int32_t);
copy1c_type_matrix(uint32_t);
copy1c_type_matrix(int64_t);
copy1c_type_matrix(uint64_t);
copy1c_type_matrix(float);
copy1c_type_matrix(double);
copy1c_type_matrix(rgb8);
copy1c_type_matrix(rgbx8);


#endif /* _NRMEM2X_H_ */

