/* ----------------- */
/* --- nrsort1.h --- */
/* ----------------- */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
*/

#ifndef _NRSORT1_H_
#define _NRSORT1_H_

#define extractnz_boundaries_type_vector(t) \
void short_name(t,extractnz_boundaries_,vector)(t * v, int32_t nl, int32_t nh, int32_t * nlnz, int32_t * nhnz);

extractnz_boundaries_type_vector(int8_t);
extractnz_boundaries_type_vector(uint8_t);
extractnz_boundaries_type_vector(int16_t);
extractnz_boundaries_type_vector(uint16_t);
extractnz_boundaries_type_vector(int32_t);
extractnz_boundaries_type_vector(uint32_t);
extractnz_boundaries_type_vector(int64_t);
extractnz_boundaries_type_vector(uint64_t);
extractnz_boundaries_type_vector(float);
extractnz_boundaries_type_vector(double);



void sort_index_f64vector_selection(double * key, int32_t nl, int32_t nh, int32_t * index);
void sort_index_ivector_selection_min(int32_t * key, int32_t nl, int32_t nh, int32_t * index);
void sort_index_ivector_selection_max(int32_t * key, int32_t nl, int32_t nh, int32_t * index);
void sort_index_vector_selection_min(float * key, int32_t nl, int32_t nh, int32_t * index);
void sort_index_vector_selection_max(float * key, int32_t nl, int32_t nh, int32_t * index);
void sort_index_vector_selection_kmin(float * key, int32_t nl, int32_t nh, int32_t * index, int32_t k);
void sort_index_ivector_selection_kmin(int32_t * key, int32_t nl, int32_t nh, int32_t * index, int32_t k);
void sort_index_vector_selection_kmax(float * key, int32_t nl, int32_t nh, int32_t * index, int32_t k);
void sort_index_ivector_selection_kmax(int32_t * key, int32_t nl, int32_t nh, int32_t * index, int32_t k);
void sort_bvector_selection_min(int8_t * v, int32_t nl, int32_t nh);

/*
 * ATTENTION le tableau index DOIT etre initialise (et alloue)
 */


/* ======================================================================== */
/* == Select = order/rank filter = median ================================= */
/* ======================================================================== */
int8_t select_bvector(int8_t * v, int32_t nl, int32_t nh, int32_t k);
rgb8 select_rgb8vector(rgb8 * v, int32_t nl, int32_t nh, int32_t k);



#endif /* _NRSORT1_H_ */

