/* ----------------- */
/* --- nrmem1x.c --- */
/* ----------------- */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
 */

#include <stdlib.h>
#include <stdio.h>
#include <stddef.h>
#include <string.h>

#include "mypredef.h"
#include "nrtype.h"
#include "nrdef.h"
#include "nrmacro.h"
#include "nrkernel.h"

#include "nrmem1x.h"

void roll_si16vector(int16_t * v, int32_t nl, int32_t nh)
/* 
 * left rotate a uint16 vector with subscript range v[nl..nh]
 * nl & nh can be, respectively bigger and smaller than the
 * values used to allocate the vector (svector)
 * no check on nl and nh is done
 */
{
    sint16 tmp;
    tmp = v[nl];
    for (int32_t i = nl; i < nh; i++) {
        v[i] = v[i + 1];
    }
    v[nh] = tmp;
}


void roll_ui16vector(uint16_t * v, int32_t nl, int32_t nh)
/* 
 * left rotate a uint16 vector with subscript range v[nl..nh]
 * nl & nh can be, respectively bigger and smaller than the
 * values used to allocate the vector (svector)
 * no check on nl and nh is done
 */
{
    uint16 tmp;
    tmp = v[nl];
    for (int32_t i = nl; i < nh; i++) {
        v[i] = v[i + 1];
    }
    v[nh] = tmp;
}

/*
 * -------------------
 * --- copy_vector ---
 * -------------------
 */

#undef copy_type_vector
#define copy_type_vector(t) \
void short_name(t,copy_,vector)(t * src, int32_t nl1, int32_t nh1, t * dst, int32_t nl2, int32_t nh2) \
{                                                  \
    int32_t len = nh1 - nl1 + 1;                   \
    memcpy(dst + nl2, src + nl1, len * sizeof(t)); \
}

copy_type_vector(int8_t);
copy_type_vector(uint8_t);
copy_type_vector(int16_t);
copy_type_vector(uint16_t);
copy_type_vector(int32_t);
copy_type_vector(uint32_t);
copy_type_vector(float);
copy_type_vector(double);
copy_type_vector(rgb8);
copy_type_vector(rgbx8);


#undef copy1c_type_vector
#define copy1c_type_vector(t) \
void short_name(t,copy1c_,vector)(t * src, int32_t nc, t * dst, int32_t nl, int32_t nh) \
{                                       \
    t c = src[nc];                      \
    for (int32_t j = nl; j < nh; j++) { \
        dst[j] = c;                     \
    }                                   \
}

copy1c_type_vector(int8_t);
copy1c_type_vector(uint8_t);
copy1c_type_vector(int16_t);
copy1c_type_vector(uint16_t);
copy1c_type_vector(int32_t);
copy1c_type_vector(uint32_t);
copy1c_type_vector(float);
copy1c_type_vector(double);
copy1c_type_vector(rgb8);
copy1c_type_vector(rgbx8);



#undef copy_type_vector_mod
#define copy_type_vector_mod(t) \
void short_name(t,copy_,vector_mod)(t * src, int32_t nl, int32_t nh, int32_t m, t * dst) \
{                                                       \
    if (nh > nl) {                                      \
        int32_t len = nh - nl + 1;                      \
        memcpy(dst, src + nl, len * sizeof(t));         \
    }                                                   \
    else {                                              \
        int32_t len1 = m - nl;                          \
        int32_t len2 = nh + 1;                          \
        memcpy(dst, src + nl, len1 * sizeof(t));        \
        memcpy(dst + len1, src + nh, len2 * sizeof(t)); \
    }                                                   \
}


copy_type_vector_mod(int8_t);
copy_type_vector_mod(uint8_t);
copy_type_vector_mod(int16_t);
copy_type_vector_mod(uint16_t);
copy_type_vector_mod(int32_t);
copy_type_vector_mod(uint32_t);
copy_type_vector_mod(float);
copy_type_vector_mod(double);
copy_type_vector_mod(rgb8);
copy_type_vector_mod(rgbx8);



// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:

// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

