/* ----------------- */
/* --- nrsort2.h --- */
/* ----------------- */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
*/

#ifndef _NRSORT2_H_
#define _NRSORT2_H_

#define extractnz_boundaries_type_matrix(t) \
void short_name(t,extractnz_boundaries_,matrix)(t ** m, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, int32_t * nclnz, int32_t * nchnz);

extractnz_boundaries_type_matrix(int8_t);
extractnz_boundaries_type_matrix(uint8_t);
extractnz_boundaries_type_matrix(int16_t);
extractnz_boundaries_type_matrix(uint16_t);
extractnz_boundaries_type_matrix(int32_t);
extractnz_boundaries_type_matrix(uint32_t);
extractnz_boundaries_type_matrix(int64_t);
extractnz_boundaries_type_matrix(uint64_t);
extractnz_boundaries_type_matrix(float);
extractnz_boundaries_type_matrix(double);


void sort_si32matrix_selection2(int32_t ** m, int32_t nl, int32_t nh);
void sort_f64matrix_selection(double * m, int32_t nl, int32_t nh);
void sort_si32matrix_selection(int32_t ** m, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, int32_t nrow);
void sort_si32matrix_leftpart_selection2(int32_t ** m, int32_t nl, int32_t nh, int32_t len);

/*
 * Sort the first len item of a 2-row matrix
 */

void sort_index_si32matrix_selection_kmin(int32_t ** key, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, int32_t ** index, int32_t k);
void sort_index_si32matrix_selection_kmax(int32_t ** key, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, int32_t ** index, int32_t k);

/*
 * appel de "sort_index_ivector_selection_k" pour chaque ligne
 * ATTENTION L'initialisation du tableau index est fait ici
 */

void sortv_si32matrix_selection_min(int32_t ** m, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, int32_t nc);
void sortv_si32matrix_selection_max(int32_t ** m, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, int32_t nc);
void sortv_si32matrix_selection_kmin(int32_t ** m, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, int32_t nc, int32_t k);
void sortv_si32matrix_selection_kmax(int32_t ** m, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, int32_t nc, int32_t k);

/*
 * tri vertical, de toutes les lignes
 * tri vertical, d'une partie des lignes
 */

void sortv_index_imatrix_selection_max(int ** key, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, int32_t * index, int32_t nc);
void sortv_index_imatrix_selection_min(int32_t ** key, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, int32_t * index, int32_t nc);

/*
 * trie de la colonne nc de la matrice key, nc[ncl..nch]
 * la matrice reste inchangee, seule l'index est modifie
 */

#endif /* _NRSORT2_H_ */

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:

// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

