/* ----------------- */
/* --- nrmem2X.c --- */
/* ----------------- */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
 * 
 */

/* 
 * 2002/06/11 ajout des fonctions endline
 */
#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>

#include "mypredef.h"
#include "nrtype.h"
#include "nrdef.h"
#include "nrmacro.h"
#include "nrkernel.h"

#include "nrtypex.h"

#include "nrmem1.h"
#include "nrmem2.h"
#include "nrmem2x.h"


/* ------------------------------------------ */
/* --- ATTENTION ---------------------------- */
/* ------------------------------------------ */
/* l'utilisation des fonctions endline        */
/* necessite l'allocation d'une ligne de plus */
/* (a cause du m[i + 1]                       */
/* ------------------------------------------ */

#undef reset_endline_type_matrix
#define reset_endline_type_matrix(t) \
void short_name(t,reset_endline_,matrix)(t ** m, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch) \
{                                              \
    int32_t ncol = nch - ncl + 1;              \
    for (int32_t i = nrl + 1; i <= nrh; i++) { \
        m[i] = m[i - 1] + ncol;                \
    }                                          \
}

reset_endline_type_matrix(int8_t);
reset_endline_type_matrix(uint8_t);
reset_endline_type_matrix(int16_t);
reset_endline_type_matrix(uint16_t);
reset_endline_type_matrix(int32_t);
reset_endline_type_matrix(uint32_t);
reset_endline_type_matrix(int64_t);
reset_endline_type_matrix(uint64_t);


#undef endline_type_matrix
#define endline_type_matrix(t) \
void short_name(t,endline_,matrix)(t ** m, int32_t i, int32_t l) \
{                        \
    m[i + 1] = m[i] + l; \
}                        \
void short_name(t,endline0_,matrix)(t ** m, int32_t i, int32_t l, int32_t ncl) \
{                            \
    m[i + 1] = m[i] + l + 1; \
    m[i][ncl] = (t) l;       \
}                            \
void short_name(t,endline1_,matrix)(t ** m, int32_t i, int32_t l, int32_t ncl) \
{                            \
    m[i + 1] = m[i] + l + 1; \
    m[i][ncl - 1] = (t) l;   \
}

endline_type_matrix(int8_t);
endline_type_matrix(uint8_t);
endline_type_matrix(int16_t);
endline_type_matrix(uint16_t);
endline_type_matrix(int32_t);
endline_type_matrix(uint32_t);
endline_type_matrix(int64_t);
endline_type_matrix(uint64_t);


#undef resize_type_matrix
#define resize_type_matrix(t) \
void short_name(t,resize_,matrix)(t ** m, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch) \
{                                              \
    int32_t ncol = nch - ncl + 1;              \
    for (int32_t i = nrl + 1; i <= nrh; i++) { \
        m[i] = m[i - 1] + ncol;                \
    }                                          \
}

resize_type_matrix(si16Point);
resize_type_matrix(ui16Point);
resize_type_matrix(si32Point);
resize_type_matrix(ui32Point);
resize_type_matrix(f32Point);
resize_type_matrix(si16Triplet);
resize_type_matrix(ui16Triplet);
resize_type_matrix(si32Triplet);
resize_type_matrix(ui32Triplet);
resize_type_matrix(f32Triplet);


/*
 * --------------
 * matrix_reverse
 * --------------
 */

#undef type_matrix_reverse
#define type_matrix_reverse(t) \
void short_name(t,,matrix_reverse)(t ** m, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch) \
{                                          \
    int32_t mrow = (nrl + nrh + 1) / 2;    \
    t * temp;                              \
    for (int32_t i = nrl; i < mrow; i++) { \
        temp = m[i];                       \
        m[i] = m[nrh - i];                 \
        m[nrh - i] = temp;                 \
    }                                      \
}

type_matrix_reverse(int8_t);
type_matrix_reverse(uint8_t);
type_matrix_reverse(int16_t);
type_matrix_reverse(uint16_t);
type_matrix_reverse(int32_t);
type_matrix_reverse(uint32_t);
type_matrix_reverse(int64_t);
type_matrix_reverse(uint64_t);
type_matrix_reverse(float);
type_matrix_reverse(double);


#undef desinterlace_type_matrix
#define desinterlace_type_matrix(t) \
void short_name(t,desinterlace_,matrix)(t ** S, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, t ** D0, t ** D1) \
{                                                  \
    int32_t i0, i1;                                \
    i0 = i1 = nrl;                                 \
    if ((nrl & 1) == 0) {                          \
        /* nrl is even */                          \
        for (int32_t i = nrl; i <= nrh; i += 2) {  \
            for (int32_t j = ncl; j <= nch; j++) { \
                D0[i0][j] = S[i][j];               \
            }                                      \
            i0++;                                  \
            for (int32_t j = ncl; j <= nch; j++) { \
                D1[i1][j] = S[i][j];               \
            }                                      \
            i1++;                                  \
        }                                          \
        /* epilog */                               \
        if ((nrh & 1) == 0) {                      \
            for (int32_t j = ncl; j <= nch; j++) { \
                D0[i0][j] = S[nrh][j];             \
            }                                      \
            i0++;                                  \
        }                                          \
    }                                              \
    else {                                         \
        /* nrl is odd */                           \
        for (int32_t i = nrl; i <= nrh; i += 2) {  \
            for (int32_t j = ncl; j <= nch; j++) { \
                D1[i1][j] = S[i][j];               \
            }                                      \
            i1++;                                  \
            for (int32_t j = ncl; j <= nch; j++) { \
                D0[i0][j] = S[i][j];               \
            }                                      \
            i0++;                                  \
        }                                          \
        /* epilog */                               \
        if ((nrh & 1) == 1) {                      \
            for (int32_t j = ncl; j <= nch; j++) { \
                D1[i1][j] = S[nrh][j];             \
            }                                      \
            i1++;                                  \
        }                                          \
    }                                              \
}

desinterlace_type_matrix(int8_t);
desinterlace_type_matrix(uint8_t);
desinterlace_type_matrix(int16_t);
desinterlace_type_matrix(uint16_t);
desinterlace_type_matrix(int32_t);
desinterlace_type_matrix(uint32_t);
desinterlace_type_matrix(int64_t);
desinterlace_type_matrix(uint64_t);
desinterlace_type_matrix(float);
desinterlace_type_matrix(double);
desinterlace_type_matrix(rgb8);
desinterlace_type_matrix(rgbx8);



#undef interlace_type_matrix
#define interlace_type_matrix(t) \
void short_name(t,interlace_,matrix)(t ** S0, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, t ** S1, t ** D) \
{                                                      \
    /* S1 & S2 are supposed to have the same height */ \
    int i0, i1;                                        \
    i0 = i1 = nrl;                                     \
    for (int32_t i = nrl; i <= nrh;) {                 \
        for (int32_t j = ncl; j <= nch; j++) {         \
            D[i][j] = S0[i0][j];                       \
        }                                              \
        i++;                                           \
        i0++;                                          \
        for (int32_t j = ncl; j <= nch; j++) {         \
            D[i][j] = S0[i1][j];                       \
        }                                              \
        i++;                                           \
        i1++;                                          \
    }                                                  \
}

interlace_type_matrix(int8_t);
interlace_type_matrix(uint8_t);
interlace_type_matrix(int16_t);
interlace_type_matrix(uint16_t);
interlace_type_matrix(int32_t);
interlace_type_matrix(uint32_t);
interlace_type_matrix(int64_t);
interlace_type_matrix(uint64_t);
interlace_type_matrix(float);
interlace_type_matrix(double);
interlace_type_matrix(rgb8);
interlace_type_matrix(rgbx8);


#undef copyc_type_matrix
#define copyc_type_matrix(t) \
void short_name(t,copyc_,matrix)(t ** src, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, t ** cond, t c, t ** dst) \
{                                              \
    t * Xi;                                    \
    t * Yi;                                    \
    t * Ci;                                    \
    for (int32_t i = nrl; i <= nrh; i++) {     \
        Xi = src [i];                          \
        Yi = dst [i];                          \
        Ci = cond[i];                          \
        for (int32_t j = ncl; j <= nch; j++) { \
            if (Ci[j] == c) {                  \
                Yi[j] = Xi[j];                 \
            }                                  \
            else {                             \
                Yi[j] = 0;                     \
            }                                  \
        }                                      \
    }                                          \
}

copyc_type_matrix(int8_t);
copyc_type_matrix(uint8_t);
copyc_type_matrix(int16_t);
copyc_type_matrix(uint16_t);
copyc_type_matrix(int32_t);
copyc_type_matrix(uint32_t);
copyc_type_matrix(int64_t);
copyc_type_matrix(uint64_t);
copyc_type_matrix(float);
copyc_type_matrix(double);


#undef complete_border_type_matrix
#define complete_border_type_matrix(t) \
void short_name(t,complete_border_,matrix)(t ** m, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, int32_t n) \
{                                                                        \
    t * Xi;                                                              \
    for (int32_t i = nrl; i <= nrh; i++) {                               \
        Xi = m[i];                                                       \
        for (int32_t j = 1; j <= n; j++) {                               \
            Xi[ncl - j] = Xi[ncl];                                       \
            Xi[nch + j] = Xi[nch];                                       \
        }                                                                \
    }                                                                    \
    for (int32_t i = 1; i <= n; i++) {                                   \
        short_name(t,dup_,vector)(m[nrl], ncl - n, nch + n, m[nrl - i]); \
    }                                                                    \
    for (int32_t i = 1; i <= n; i++) {                                   \
        short_name(t,dup_,vector)(m[nrh], ncl - n, nch + n, m[nrh + i]); \
    }                                                                    \
}

complete_border_type_matrix(int8_t);
complete_border_type_matrix(uint8_t);
complete_border_type_matrix(int16_t);
complete_border_type_matrix(uint16_t);
complete_border_type_matrix(int32_t);
complete_border_type_matrix(uint32_t);
complete_border_type_matrix(int64_t);
complete_border_type_matrix(uint64_t);
complete_border_type_matrix(float);
complete_border_type_matrix(double);
complete_border_type_matrix(rgb8);
complete_border_type_matrix(rgbx8);


#undef complete_border1_type_matrix
#define complete_border1_type_matrix(t) \
void short_name(t,complete_border1_,matrix)(t ** m, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch) \
{                                                            \
    t * Xi;                                                  \
    short_name(t,dup_,vector)(m[nrl + 1], ncl, nch, m[nrl]); \
    for (int32_t i = nrl; i <= nrh; i++) {                   \
        Xi = m[i];                                           \
        Xi[nrl] = Xi[nrl + 1];                               \
        Xi[nrh] = Xi[nrh - 1];                               \
    }                                                        \
    short_name(t,dup_,vector)(m[nrh - 1], ncl, nch, m[nrh]); \
}

complete_border1_type_matrix(int8_t);
complete_border1_type_matrix(uint8_t);
complete_border1_type_matrix(int16_t);
complete_border1_type_matrix(uint16_t);
complete_border1_type_matrix(int32_t);
complete_border1_type_matrix(uint32_t);
complete_border1_type_matrix(int64_t);
complete_border1_type_matrix(uint64_t);
complete_border1_type_matrix(float);
complete_border1_type_matrix(double);
complete_border1_type_matrix(rgb8);
complete_border1_type_matrix(rgbx8);


#undef complete_border2_type_matrix
#define complete_border2_type_matrix(t) \
void short_name(t,complete_border2_,matrix)(t ** m, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch) \
{                                                                \
    t * Xi;                                                      \
    short_name(t,dup_,vector)(m[nrl + 2], ncl, nch, m[nrl + 0]); \
    short_name(t,dup_,vector)(m[nrl + 2], ncl, nch, m[nrl + 1]); \
    for (int32_t i = nrl; i <= nrh; i++) {                       \
        Xi = m[i];                                               \
        Xi[nrl] = Xi[nrl + 1] = Xi[nrl + 2];                     \
        Xi[nrh] = Xi[nrh - 1] = Xi[nrh - 2];                     \
    }                                                            \
    short_name(t,dup_,vector)(m[nrh - 2], ncl, nch, m[nrh - 1]); \
    short_name(t,dup_,vector)(m[nrh - 2], ncl, nch, m[nrh - 0]); \
}

complete_border2_type_matrix(int8_t);
complete_border2_type_matrix(uint8_t);
complete_border2_type_matrix(int16_t);
complete_border2_type_matrix(uint16_t);
complete_border2_type_matrix(int32_t);
complete_border2_type_matrix(uint32_t);
complete_border2_type_matrix(int64_t);
complete_border2_type_matrix(uint64_t);
complete_border2_type_matrix(float);
complete_border2_type_matrix(double);
complete_border2_type_matrix(rgb8);
complete_border2_type_matrix(rgbx8);


#undef copy1c_type_matrix
#define copy1c_type_matrix(t) \
void short_name(t,copy1c_,matrix)(t ** X, int32_t nc, t ** Y, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch) \
{                                                         \
    for (int32_t i = nrl; i <= nrh; i++) {                \
        /* copy1c_ui8vector(X[i], nc, Y[i], ncl, nch); */ \
    }                                                     \
}

copy1c_type_matrix(int8_t);
copy1c_type_matrix(uint8_t);
copy1c_type_matrix(int16_t);
copy1c_type_matrix(uint16_t);
copy1c_type_matrix(int32_t);
copy1c_type_matrix(uint32_t);
copy1c_type_matrix(int64_t);
copy1c_type_matrix(uint64_t);
copy1c_type_matrix(float);
copy1c_type_matrix(double);
copy1c_type_matrix(rgb8);
copy1c_type_matrix(rgbx8);


#undef copy1r_type_matrix
#define copy1r_type_matrix(t) \
void short_name(t,copy1r_,matrix)(t ** X, int32_t nr, t ** Y, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch) \
{                                                         \
    for (int32_t i = nrl; i <= nrh; i++) {                \
        short_name(t,dup_,vector)(X[nr], ncl, nch, Y[i]); \
    }                                                     \
}

copy1r_type_matrix(int8_t);
copy1r_type_matrix(uint8_t);
copy1r_type_matrix(int16_t);
copy1r_type_matrix(uint16_t);
copy1r_type_matrix(int32_t);
copy1r_type_matrix(uint32_t);
copy1r_type_matrix(int64_t);
copy1r_type_matrix(uint64_t);
copy1r_type_matrix(float);
copy1r_type_matrix(double);
copy1r_type_matrix(rgb8);
copy1r_type_matrix(rgbx8);


// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:

// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

