/* ---------------- */
/* --- nrset2.c --- */
/* ---------------- */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
 *
 * Distributed under the Boost Software License, Version 1.0
 * see accompanying file LICENSE.txt or copy it at
 * http://www.boost.org/LICENSE_1_0.txt
 */


#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>

#include "mypredef.h"
#include "nrtype.h"
#include "nrdef.h"
#include "nrmacro.h"
#include "nrkernel.h"

#include "nrset1.h"
#include "nrset2.h"

/*
 * ------------
 * --- Zero ---
 * ------------
 */


#undef zero_type_matrix
#define zero_type_matrix(t) \
void short_name(t,zero_,matrix)(t ** m, int32_t i0, int32_t i1, int32_t j0, int32_t j1) \
{                                                 \
    for (int32_t i = i0; i <= i1; i++) {          \
        short_name(t,zero_,vector)(m[i], j0, j1); \
    }                                             \
}

zero_type_matrix(int8_t);
zero_type_matrix(uint8_t);
zero_type_matrix(int16_t);
zero_type_matrix(uint16_t);
zero_type_matrix(int32_t);
zero_type_matrix(uint32_t);
zero_type_matrix(int64_t);
zero_type_matrix(uint64_t);
zero_type_matrix(float);
zero_type_matrix(double);
zero_type_matrix(rgb8);
zero_type_matrix(rgbx8);

/*
 * ------------------
 * --- set_matrix ---
 * ------------------
 */

#undef set_type_matrix
#define set_type_matrix(t) \
void short_name(t,set_,matrix)(t ** m, int32_t i0, int32_t i1, int32_t j0, int32_t j1, t x) \
{                                                    \
    for (int32_t i = i0; i <= i1; i++) {             \
        short_name(t,set_,vector)(m[i], j0, j1, x);  \
    }                                                \
}

set_type_matrix(int8_t);
set_type_matrix(uint8_t);
set_type_matrix(int16_t);
set_type_matrix(uint16_t);
set_type_matrix(int32_t);
set_type_matrix(uint32_t);
set_type_matrix(int64_t);
set_type_matrix(uint64_t);
set_type_matrix(float);
set_type_matrix(double);
set_type_matrix(rgb8);
set_type_matrix(rgbx8);



/*
 * ----------------
 * set_matrix_param
 * ----------------
 */

#undef set_type_matrix_param
#define set_type_matrix_param(t) \
void short_name(t,set_,matrix_param)(t ** m, int32_t i0, int32_t i1, int32_t j0, int32_t j1, t x, t xstep, t ystep) \
{                                                                \
    for (int32_t i = i0; i <= i1; i++) {                         \
        short_name(t,set_,vector_param)(m[i], j0, j1, x, xstep); \
        x += ystep;                                              \
    }                                                            \
}

set_type_matrix_param(int8_t);
set_type_matrix_param(uint8_t);
set_type_matrix_param(int16_t);
set_type_matrix_param(uint16_t);
set_type_matrix_param(int32_t);
set_type_matrix_param(uint32_t);
set_type_matrix_param(int64_t);
set_type_matrix_param(uint64_t);
set_type_matrix_param(float);
set_type_matrix_param(double);


void set_rgb8matrix_param(rgb8 ** m, int32_t i0, int32_t i1, int32_t j0, int32_t j1, rgb8 x, rgb8 xstep, rgb8 ystep)
{
    for (int32_t i = i0; i <= i1; i++) {
        set_rgb8vector_param(m[i], j0, j1, x, xstep);
        x.r += ystep.r;
        x.g += ystep.g;
        x.b += ystep.b;
    }
}

void set_rgbx8matrix_param(rgbx8 ** m, int32_t i0, int32_t i1, int32_t j0, int32_t j1, rgbx8 x, rgbx8 xstep, rgbx8 ystep)
{
    x.x = 0;
    for (int32_t i = i0; i <= i1; i++) {
        set_rgbx8vector_param(m[i], j0, j1, x, xstep);
        x.r += ystep.r;
        x.g += ystep.g;
        x.b += ystep.b;
        x.x += ystep.x;
    }
}


/*
 * --------------------
 * --- set_matrix_i ---
 * --------------------
 */

#undef set_type_matrix_i
#define set_type_matrix_i(t) \
void short_name(t,set_,matrix_i)(t ** m, int32_t i0, int32_t i1, int32_t j0, int32_t j1) \
{                                                                 \
    short_name(t,set_,matrix_param)(m, i0, i1, j0, j1, i0, 0, 1); \
}

set_type_matrix_i(int8_t);
set_type_matrix_i(uint8_t);
set_type_matrix_i(int16_t);
set_type_matrix_i(uint16_t);
set_type_matrix_i(int32_t);
set_type_matrix_i(uint32_t);
set_type_matrix_i(int64_t);
set_type_matrix_i(uint64_t);
set_type_matrix_i(float);
set_type_matrix_i(double);


void set_rgb8matrix_i(rgb8 ** m, int32_t i0, int32_t i1, int32_t j0, int32_t j1)
{
    rgb8 x0;
    rgb8 xstep;
    rgb8 ystep;

    x0.r    = x0.g    = x0.b    = i0;
    xstep.r = xstep.g = xstep.b = 0;
    ystep.r = ystep.g = ystep.b = 1;

    set_rgb8matrix_param(m, i0, i1, j0, j1, x0, xstep, ystep);
}


void set_rgbx8matrix_i(rgbx8 ** m, int32_t i0, int32_t i1, int32_t j0, int32_t j1)
{
    rgbx8 x;
    rgbx8 xstep;
    rgbx8 ystep;

    x.r     = x.g     = x.b     = i0;
    x.x     = 255;
    xstep.r = xstep.g = xstep.b = 0;
    xstep.x = 255;
    ystep.r = ystep.g = ystep.b = 1;
    ystep.x = 255;

    set_rgbx8matrix_param(m, i0, i1, j0, j1, x, xstep, ystep);
}


/*
 * --------------------
 * --- set_matrix_j ---
 * --------------------
 */

#undef set_type_matrix_j
#define set_type_matrix_j(t) \
void short_name(t,set_,matrix_j)(t ** m, int32_t i0, int32_t i1, int32_t j0, int32_t j1) \
{                                                                 \
    short_name(t,set_,matrix_param)(m, i0, i1, j0, j1, j0, 1, 0); \
}

set_type_matrix_j(int8_t);
set_type_matrix_j(uint8_t);
set_type_matrix_j(int16_t);
set_type_matrix_j(uint16_t);
set_type_matrix_j(int32_t);
set_type_matrix_j(uint32_t);
set_type_matrix_j(int64_t);
set_type_matrix_j(uint64_t);
set_type_matrix_j(float);
set_type_matrix_j(double);



void set_rgb8matrix_j(rgb8 ** m, int32_t i0, int32_t i1, int32_t j0, int32_t j1)
{
    rgb8 x;
    rgb8 xstep;
    rgb8 ystep;

    x.r     = x.g     = x.b     = j0;
    xstep.r = xstep.g = xstep.b = 1;
    ystep.r = ystep.g = ystep.b = 0;

    set_rgb8matrix_param(m, i0, i1, j0, j1, x, xstep, ystep);
}

void set_rgbx8matrix_j(rgbx8 ** m, int32_t i0, int32_t i1, int32_t j0, int32_t j1)
{
    rgbx8 x, xstep, ystep;

    x.r     = x.g     = x.b     = j0;
    x.x     = 255;
    xstep.r = xstep.g = xstep.b = 1;
    xstep.x = 255;
    ystep.r = ystep.g = ystep.b = 0;
    ystep.x = 255;

    set_rgbx8matrix_param(m, i0, i1, j0, j1, x, xstep, ystep);
}

/*
 * --------------
 * --- autres ---
 * --------------
 */

#undef set_type_matrix_border1
#define set_type_matrix_border1(t) \
void short_name(t,set_,matrix_border1)(t ** m, int32_t i0, int32_t i1, int32_t j0, int32_t j1, t x) \
{                                                \
    short_name(t,set_,vector)(m[i0], j0, j1, x); \
    for (int32_t i = i0 + 1; i <= i1 - 1; i++) { \
        m[i][j0] = x;                            \
        m[i][j1] = x;                            \
    }                                            \
    short_name(t,set_,vector)(m[i0], j0, j1, x); \
}


set_type_matrix_border1(int8_t);
set_type_matrix_border1(uint8_t);
set_type_matrix_border1(int16_t);
set_type_matrix_border1(uint16_t);
set_type_matrix_border1(int32_t);
set_type_matrix_border1(uint32_t);
set_type_matrix_border1(int64_t);
set_type_matrix_border1(uint64_t);
set_type_matrix_border1(float);
set_type_matrix_border1(double);


#undef set_type_matrix_border
#define set_type_matrix_border(t) \
void short_name(t,set_,matrix_border)(t ** m, int32_t i0, int32_t i1, int32_t j0, int32_t j1, int32_t n, t x) \
{                                                \
    t * Xi = NULL;                               \
    for (int32_t i = i0; i < i0 + n; i++) {      \
        Xi = m[i];                               \
        for (int32_t j = j0; j <= j1; j++) {     \
            Xi[j] = x;                           \
        }                                        \
    }                                            \
    for (int32_t i = i0 + n; i < i1; i++) {      \
        Xi = m[i];                               \
        for (int32_t j = 0; j < n; j++) {        \
            Xi[j0 + j] = x;                      \
            Xi[j1 - j] = x;                      \
        }                                        \
    }                                            \
    for (int32_t i = i1 - n + 1; i <= i1; i++) { \
        Xi = m[i];                               \
        for (int32_t j = j0; j <= j1; j++) {     \
            Xi[j] = x;                           \
        }                                        \
    }                                            \
}


set_type_matrix_border(int8_t);
set_type_matrix_border(uint8_t);
set_type_matrix_border(int16_t);
set_type_matrix_border(uint16_t);
set_type_matrix_border(int32_t);
set_type_matrix_border(uint32_t);
set_type_matrix_border(int64_t);
set_type_matrix_border(uint64_t);
set_type_matrix_border(float);
set_type_matrix_border(double);


// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:

// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

