

#define GIETVM 1
#define LINUX 2

#if TARGET_OS == GIETVM
    #define tokenize(x) #x
    #define printf(...)  giet_tty_printf(__VA_ARGS__)
    #define assert(x)    giet_pthread_assert(x, "Assert failed.")

    #define open(x, y)         giet_fat_open(x, y)
    #define close(x)           giet_fat_close(x)
    #define read(x, y, z)      giet_fat_read(x, y, z)
    #define write(x, y, z)     giet_fat_write(x, y, z)
    #define fprintf(x, ...)    giet_fat_fprintf(x, __VA_ARGS__)
    //#define fscanf(x, ...)  ;
    #define exit(x)            giet_pthread_exit(NULL)

    #define pthread_barrier_t           giet_barrier_t
    #define pthread_spinlock_t          user_lock_t
    #define pthread_spin_lock(x)        lock_acquire(x)
    #define pthread_spin_unlock(x)      lock_release(x)
    #define pthread_spin_init(x, y)     lock_init(x)
    #define pthread_mutex_t             user_lock_t
    #define pthread_mutex_lock(x)       lock_acquire(x)
    #define pthread_mutex_unlock(x)     lock_release(x)
    #define pthread_mutex_init(x, y)    lock_init(x)
    #define pthread_barrier_init(x,y,z) barrier_init(x, z)
    #define pthread_barrier_wait(x)     barrier_wait(x)
    #define pthread_barrier_destroy(x)
    #define pthread_create(x,y,z,t)     giet_pthread_create(x,y,z,t)
    #define pthread_join(x,y)           giet_pthread_join(x,y)
#endif


