/* ---------------- */
/* --- nrmem2.c --- */
/* ---------------- */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
 *
 * Distributed under the Boost Software License, Version 1.0
 * see accompanying file LICENSE.txt or copy it at
 * http://www.boost.org/LICENSE_1_0.txt
 */

#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>
#include <math.h> // fabs

#include "mypredef.h"
#include "nrtype.h"
#include "nrdef.h"
#include "nrmacro.h"
#include "nrkernel.h"

#include "nrmem1.h"
#include "nrmem2.h"

/*
 * ------------------
 * --- dup_matrix ---
 * ------------------
 */


#undef dup_type_matrix
#define dup_type_matrix(t) \
void short_name(t,dup_,matrix)(t ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, t ** Y) \
{                                                        \
    for (int32_t i = nrl; i <= nrh; i++) {               \
        short_name(t,dup_,vector)(X[i], ncl, nch, Y[i]); \
    }                                                    \
}

dup_type_matrix(int8_t);
dup_type_matrix(uint8_t);
dup_type_matrix(int16_t);
dup_type_matrix(uint16_t);
dup_type_matrix(int32_t);
dup_type_matrix(uint32_t);
dup_type_matrix(int64_t);
dup_type_matrix(uint64_t);
dup_type_matrix(float);
dup_type_matrix(double);
dup_type_matrix(rgb8);
dup_type_matrix(rgbx8);


/*
 * --------------
 * --- resize ---
 * --------------
 */

#undef resize_type_matrix
#define resize_type_matrix(t) \
void short_name(t,resize_,matrix)(t ** m, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch) \
{                                              \
    int32_t ncol = nch - ncl + 1;              \
    for (int32_t i = nrl + 1; i <= nrh; i++) { \
        m[i] = m[i - 1] + ncol;                \
    }                                          \
}

resize_type_matrix(int8_t);
resize_type_matrix(uint8_t);
resize_type_matrix(int16_t);
resize_type_matrix(uint16_t);
resize_type_matrix(int32_t);
resize_type_matrix(uint32_t);
resize_type_matrix(int64_t);
resize_type_matrix(uint64_t);
resize_type_matrix(float);
resize_type_matrix(double);
resize_type_matrix(rgb8);
resize_type_matrix(rgbx8);



/* ---------------- */
/* -- Conversion -- */
/* ---------------- */

#undef convert_type_matrix
#define convert_type_matrix(t1,t2) \
void short_name(t1,convert_,short_name(t2,matrix_,matrix))(t1 ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, t2 ** Y) \
{                                                                                    \
    for (int32_t i = nrl; i <= nrh; i++) {                                           \
        short_name(t1,convert_,short_name(t2,vector_,vector))(X[i], ncl, nch, Y[i]); \
    }                                                                                \
}

convert_type_matrix(int8_t,int16_t);
convert_type_matrix(int8_t,int32_t);
convert_type_matrix(int8_t,float);
convert_type_matrix(int8_t,double);
convert_type_matrix(uint8_t,uint16_t);
convert_type_matrix(uint8_t,uint32_t);
convert_type_matrix(uint8_t,float);
convert_type_matrix(uint8_t,double);
convert_type_matrix(uint8_t,rgb8);
convert_type_matrix(uint8_t,rgbx8);
convert_type_matrix(int16_t,int32_t);
convert_type_matrix(int16_t,float);
convert_type_matrix(int16_t,double);
convert_type_matrix(uint16_t,uint32_t);
convert_type_matrix(uint16_t,float);
convert_type_matrix(uint16_t,double);
convert_type_matrix(int32_t,float);
convert_type_matrix(int32_t,double);
convert_type_matrix(uint32_t,float);
convert_type_matrix(uint32_t,double);

convert_type_matrix(int16_t,int8_t);
convert_type_matrix(uint16_t,uint8_t);
convert_type_matrix(int32_t,int8_t);
convert_type_matrix(uint32_t,uint8_t);
convert_type_matrix(int32_t,int16_t);
convert_type_matrix(uint32_t,uint16_t);
convert_type_matrix(float,int8_t);
convert_type_matrix(float,uint8_t);
convert_type_matrix(float,int16_t);
convert_type_matrix(float,uint16_t);
convert_type_matrix(float,int32_t);
convert_type_matrix(float,uint32_t);
convert_type_matrix(double,int8_t);
convert_type_matrix(double,uint8_t);
convert_type_matrix(double,int16_t);
convert_type_matrix(double,uint16_t);
convert_type_matrix(double,int32_t);
convert_type_matrix(double,uint32_t);
convert_type_matrix(double,float);
convert_type_matrix(rgb8,uint8_t);


/*
 * ----------------------
 * --- lowpart_matrix ---
 * ----------------------
 */

void lowpart_ui16matrix_ui8matrix(uint16_t ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, uint8_t ** Y)
{
    for (int32_t i = nrl; i <= nrh; i++) {
        lowpart_ui16vector_ui8vector(X[i], ncl, nch, Y[i]);
    }
}

void lowpart_ui32matrix_ui8matrix(uint32_t ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, uint8_t ** Y)
{
    for (int32_t i = nrl; i <= nrh; i++) {
        lowpart_ui32vector_ui8vector(X[i], ncl,nch, Y[i]);
    }
}

/*
 * -------------------
 * --- split-merge ---
 * -------------------
 */

void split_rgb8matrix(rgb8 ** X, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, uint8_t ** R, uint8_t ** G, uint8_t ** B)
{
    for (int32_t i = nrl; i <= nrh; i++) {
        for (int32_t j = ncl; j <= nch; j++) {
            split_rgb8vector(X[i], ncl, nch, R[i], G[i], B[i]);
        }
    }
}

void merge_rgb8matrix(uint8_t ** R, uint8_t ** G, uint8_t ** B, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, rgb8 ** X)
{
    for (int32_t i = nrl; i <= nrh; i++) {
        for (int32_t j = ncl; j <= nch; j++) {
            merge_rgb8vector(R[i], G[i], B[i], ncl, nch, X[i]);
        }
    }
}


// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:

// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

