/* ---------------- */
/* --- nrset3.c --- */
/* ---------------- */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
 *
 * Distributed under the Boost Software License, Version 1.0
 * see accompanying file LICENSE.txt or copy it at
 * http://www.boost.org/LICENSE_1_0.txt
 */

#include "mypredef.h"
#include "nrtype.h"
#include "nrdef.h"
#include "nrmacro.h"
#include "nrkernel.h"

#include "nrset2.h"
#include "nrset3.h"


#undef zero_type_cube
#define zero_type_cube(t) \
void short_name(t,zero_,cube)(t *** c, int32_t k0, int32_t k1, int32_t i0, int32_t i1, int32_t j0, int32_t j1) \
{                                                         \
    for (int32_t k = k0; k <= k1; k++) {                  \
        short_name(t,zero_,matrix)(c[k], i0, i1, j0, j1); \
    }                                                     \
}

zero_type_cube(int8_t);
zero_type_cube(uint8_t);
zero_type_cube(int16_t);
zero_type_cube(uint16_t);
zero_type_cube(int32_t);
zero_type_cube(uint32_t);
zero_type_cube(int64_t);
zero_type_cube(uint64_t);
zero_type_cube(float);
zero_type_cube(double);
zero_type_cube(rgb8);
zero_type_cube(rgbx8);

#undef set_type_cube_param
#define set_type_cube_param(t) \
void short_name(t,set_,cube_param)(t *** c, int32_t k0, int32_t k1, int32_t i0, int32_t i1, int32_t j0, int32_t j1, t x, t xstep, t ystep, t zstep) \
{                                        \
    for (int32_t k = k0; k <= k1; k++) { \
        short_name(t,set_,matrix_param)(c[k], i0, i1, j0, j1, x, xstep, ystep); \
        x += zstep;                      \
    }                                    \
}

set_type_cube_param(int8_t);
set_type_cube_param(uint8_t);
set_type_cube_param(int16_t);
set_type_cube_param(uint16_t);
set_type_cube_param(int32_t);
set_type_cube_param(uint32_t);
set_type_cube_param(int64_t);
set_type_cube_param(uint64_t);
set_type_cube_param(float);
set_type_cube_param(double);


void set_rgb8cube_param(rgb8 *** c, int32_t k0, int32_t k1, int32_t i0, int32_t i1, int32_t j0, int32_t j1, rgb8 x, rgb8 xstep, rgb8 ystep, rgb8 zstep)
{
    for (int32_t k = k0; k <= k1; k++) {
        set_rgb8matrix_param(c[k], i0, i1, j0, j1, x, xstep, ystep);
        RGB8_ADD(x, xstep, x);
    }
}

void set_rgbx8cube_param(rgbx8 *** c, int32_t k0, int32_t k1, int32_t i0, int32_t i1, int32_t j0, int32_t j1, rgbx8 x, rgbx8 xstep, rgbx8 ystep, rgbx8 zstep)
{
    for (int32_t k = k0; k <= k1; k++) {
        set_rgbx8matrix_param(c[k], i0, i1, j0, j1, x, xstep, ystep);
        RGBX8_ADD(x, xstep, x);
    }
}


// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:

// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

