
from __future__ import print_function
import os
import subprocess
import sys
import shutil
import random


def short_path(name):
    abs_path = os.path.abspath(name)
    rel_path = os.path.relpath(name)
    if len(abs_path) < len(rel_path):
        return abs_path
    else:
        return rel_path


def check_pyconf_file(pyconf_file):
    if not os.path.isfile(pyconf_file):
        help_str = '''
You should create a file named %s in this directory with the following definitions:
 - ... (to complete)
Optional definitions:
 - dsk_dir: path to a local storage (typically in /dsk/l1/misc) to store generated data and images
*** Stopping execution
''' % (short_path(pyconf_file))
        print(help_str)
        sys.exit()


    
def my_mkdir(abs_dirname):
    dirname = short_path(abs_dirname)
    try:
        print("mkdir %s" % (dirname))
        os.mkdir(dirname)
    except OSError:
        print("*** Error: impossible to create directory %s" % (dirname), file = sys.stderr)
        sys.exit(1)

def my_chdir(abs_dirname):
    dirname = short_path(abs_dirname)
    print("cd %s" % (dirname));
    os.chdir(dirname)

def my_cp(abs_src, abs_dst):
    src = short_path(abs_src)
    dst = short_path(abs_dst)
    print("cp %s %s" % (src, dst))
    shutil.copy(src, dst)

def my_symlink(target, link_name):
    if not os.path.exists(link_name):
        print("ln -s %s %s" % (short_path(target), short_path(link_name)))
        os.symlink(target, link_name)


def get_random_img_file(density, x, y, granularity, seed):
    density_str = str(density)
    if density < 10:
        density_str = "0" + density_str
    if density < 100:
        density_str = "0" + density_str

    return "rand_" + str(x) + "_" + str(y) + "_" + density_str + "_G" + str(granularity) + ".pgm"


# for the HDD constraint of 8 chars
def get_short_random_img_file(density, granularity):
    density_str = str(density)
    granularity_str = str(granularity)
    if density < 10:
        density_str = "0" + density_str
    if density < 100:
        density_str = "0" + density_str
    if granularity < 10:
        granularity_str = "0" + granularity_str

    return "G" + granularity_str + "_D" + density_str + ".pgm"



def get_dirname(dir, nthreads, config, ftrs, granularity, start_den, end_den, basename):
    start_den_str = str(start_den)
    end_den_str = str(end_den)
    if start_den < 10:
        start_den_str = "0" + start_den_str
    if start_den < 100:
        start_den_str = "0" + start_den_str
    if end_den < 10:
        end_den_str = "0" + end_den_str
    if end_den < 100:
        end_den_str = "0" + end_den_str

    if ftrs:
        ftrs_str = "_FEATURES_1"
    else:
        ftrs_str = "_FEATURES_0"

    config_keys = list(config.keys()) # duplicates list
    try:
        config_keys.remove('FEATURES')
    except:
        pass
    config_keys = sorted(config_keys)
    dirname = os.path.join(dir, basename + "_T" + str(nthreads) + "_G" + str(granularity) + "_D" + start_den_str + "-" + end_den_str + "_" + "_".join(map(lambda x:'%s_%s' % (x, config[x]), config_keys)) + ftrs_str)
    
    return dirname


def get_graph_filename(dir, nthreads, granularity, config, ext):
    config_keys = list(config.keys()) # duplicates list
    config_keys = sorted(config_keys)
    filename = os.path.join(dir, "random_T" + str(nthreads) + "_G" + str(granularity) + "_" + "_".join(map(lambda x:'%s_%s' % (x, config[x]), config_keys)) + ext)
    
    return filename



def get_filename(dir, nthreads, config, ftrs, basename):
    if ftrs:
        ftrs_str = "_FEATURES_1"
    else:
        ftrs_str = "_FEATURES_0"

    config_keys = list(config.keys()) # duplicates list
    try:
        config_keys.remove('FEATURES')
    except:
        pass
    config_keys = sorted(config_keys)
    filename = os.path.join(dir, basename + "_T" + str(nthreads) + "_" + "_".join(map(lambda x:'%s_%s' % (x, config[x]), config_keys)) + ftrs_str + ".txt")
    
    return filename


def print_and_call(cmd):
    print(subprocess.list2cmdline(cmd))
    retval = subprocess.call(cmd)
    return retval


def print_call_and_check(cmd):
    retval = print_and_call(cmd)
    if retval != 0:
        print("*** Error: command '%s' returned %d\n" % (subprocess.list2cmdline(cmd), retval))
        sys.exit(1)


def print_and_popen(cmd, abs_outfile):
    outfile = short_path(abs_outfile)
    print(subprocess.list2cmdline(cmd), end = "")
    print(" >", outfile)
    child = subprocess.Popen(cmd, stdout = subprocess.PIPE, stderr = subprocess.STDOUT)
    output = child.communicate()[0]
    retval = child.returncode
                
    # Write simulation results to log file
    file = open(outfile, 'w')
    file.write(output)
    file.close()

    if retval != 0:
        print("*** Error while executing command '%s'" % subprocess.list2cmdline(cmd))
        sys.exit(1)

    return output


def gen_random_image(filename, x, y, granularity, density, seed):
    random.seed(seed)
    img = [[0 for a in range(x)] for b in range(y)] 
    for i in range(0, x, granularity):
        for j in range(0, y, granularity):
            r = random.random();
            if r < density:
                px = 255
            else:
                px = 0

            for di in range(0, granularity):
                for dj in range(0, granularity):
                    if i + di < x and j + dj < y:
                        img[i + di][j + dj] = px;

    f = open(filename, 'wb')
    f.write("P5\n%d %d\n255\n" % (x, y))
    for j in range(0, y):
        bimg = bytearray(img[j])
        f.write(bimg)
    f.close()


