
#ifndef __CONFIG_H_
#define __CONFIG_H_

#define SLOW 0
#define FEATURES 1
#define FAST 1
#define PYR_BARRIERS 0
#define PARMERGE 1
#define ARSP 1

#if FAST && SLOW
#error "FAST and SLOW cannot be defined at the same time"
#endif

#if PYR_BARRIERS && PARMERGE
#error "PYR_BARRIERS and PARMERGE are exclusive"
#endif


#if FAST
    #if   !FEATURES && !PARMERGE && !ARSP
        #define vuse2_Rosenfeld(e, f,    T, D, alpha, F)  vuse2_Rosenfeld_Dist(e, f,    T, D, alpha)
        #define vuse3_Rosenfeld(e, f, g, T, D, alpha, F)  vuse3_Rosenfeld_Dist(e, f, g, T, D, alpha)
    #elif !FEATURES && !PARMERGE &&  ARSP
        #define vuse2_Rosenfeld(e, f,    T, D, alpha, F)  vuse2_Arsp_Rosenfeld_Dist(e, f,    T, D, alpha)
        #define vuse3_Rosenfeld(e, f, g, T, D, alpha, F)  vuse3_Arsp_Rosenfeld_Dist(e, f, g, T, D, alpha)
        #error "Configuration Not implemented"
    #elif !FEATURES &&  PARMERGE && !ARSP
        #define vuse2_Rosenfeld(e, f,    T, D, alpha, F)  vuse2_Parallel_Rosenfeld_Dist(e, f,    T, D, alpha, F)
        #define vuse3_Rosenfeld(e, f, g, T, D, alpha, F)  vuse3_Parallel_Rosenfeld_Dist(e, f, g, T, D, alpha, F)
        #define SetRoot_Parallel_FNF(D, rl, rd, alpha, F) SetRoot_Parallel_Rosenfeld_Dist(D, rl, rd, alpha, F)
    #elif !FEATURES &&  PARMERGE &&  ARSP
        #define vuse2_Rosenfeld(e, f,    T, D, alpha, F)  vuse2_Parallel_Arsp_Rosenfeld_Dist(e, f,    T, D, alpha, F)
        #define vuse3_Rosenfeld(e, f, g, T, D, alpha, F)  vuse3_Parallel_Arsp_Rosenfeld_Dist(e, f, g, T, D, alpha, F)
    #elif  FEATURES && !PARMERGE && !ARSP
        #define vuse2_Rosenfeld(e, f,    T, D, alpha, F)  vuse2_Features_Rosenfeld_Dist(e, f,    T, D, alpha, F)
        #define vuse3_Rosenfeld(e, f, g, T, D, alpha, F)  vuse3_Features_Rosenfeld_Dist(e, f, g, T, D, alpha, F)
    #elif  FEATURES && !PARMERGE &&  ARSP
        #define vuse2_Rosenfeld(e, f,    T, D, alpha, F)  vuse2_Features_Arsp_Rosenfeld_Dist(e, f,    T, D, alpha, F)
        #define vuse3_Rosenfeld(e, f, g, T, D, alpha, F)  vuse3_Features_Arsp_Rosenfeld_Dist(e, f, g, T, D, alpha, F)
        #error "Configuration Not implemented"
    #elif  FEATURES &&  PARMERGE && !ARSP
        #define vuse2_Rosenfeld(e, f,    T, D, alpha, F)  vuse2_Parallel_Rosenfeld_Dist(e, f,    T, D, alpha, F)
        #define vuse3_Rosenfeld(e, f, g, T, D, alpha, F)  vuse3_Parallel_Rosenfeld_Dist(e, f, g, T, D, alpha, F)
        #define SetRoot_Parallel_FNF(D, rl, rd, alpha, F) SetRoot_Parallel_Features_Rosenfeld_Dist(D, rl, rd, alpha, F)
    #elif  FEATURES &&  PARMERGE &&  ARSP
        #define vuse2_Rosenfeld(e, f,    T, D, alpha, F)  vuse2_Parallel_Arsp_Rosenfeld_Dist(e, f,    T, D, alpha, F)
        #define vuse3_Rosenfeld(e, f, g, T, D, alpha, F)  vuse3_Parallel_Arsp_Rosenfeld_Dist(e, f, g, T, D, alpha, F)
    #endif
#endif

#if SLOW
    #if FEATURES
        #define SetRoot_Rosenfeld(D, r, eps, alpha, F) SetRoot_Features_Rosenfeld_Dist(D, r, eps, alpha, F)
    #else
        #define SetRoot_Rosenfeld(D, r, eps, alpha, F) SetRoot_Rosenfeld_Dist(D, r, eps, alpha)
    #endif
    #if PARMERGE
        #error "Configuration SLOW and PARMERGE Not implemented"
    #endif
    #if ARSP
        #error "Configuration SLOW and ARSP Not implemented"
    #endif
#endif

// Verbose level
// 0 : No trace at all
// 1 : Traces compatible with execution times measurements,
//     in particular, there must not be any traces in the
//     "compute" sections
// 2 : Standard level
// 3 : Maximum (debug) level
#define MCA_VERBOSE_LEVEL 1


#endif

