/* ------------------ */
/* --- nrmem2XX.c --- */
/* ------------------ */

/*
 * Copyright (c) 2000-2014, Lionel Lacassagne, All rights reserved
 * Univ Paris Sud XI, CNRS
 */

#include "def.h"
#include "nrmem1.h"
#include "nrmem2.h"
#include "nrmem2X.h"
#include "nrmem2XX.h"

/* ---------------------------- */
/* --- Left & right Rotate  --- */
/* ---------------------------- */
// (i,j) -> (n-j,i) -> (n-i,n-j) -> (j,n-i) ->


#undef rotate_type_matrix
#define rotate_type_matrix(t) \
void short_name(t,lrotate_,matrix)(t ** S, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, t ** D) \
{                                              \
	int32_t n = nrl + nrh;                     \
	for (int32_t i = nrl; i <= nrh; i++) {     \
		for (int32_t j = ncl; j <= nch; j++) { \
			D[n - j][i] = S[i][j];             \
		}                                      \
	}                                          \
}                                              \
void short_name(t,rrotate_,matrix)(t ** S, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, t ** D) \
{                                              \
	int32_t n = nrl + nrh;                     \
	for (int32_t i = nrl; i <= nrh; i++) {     \
		for (int32_t j = ncl; j <= nch; j++) { \
			D[i][j] = S[n - j][i];             \
		}                                      \
	}                                          \
}                                              \
void short_name(t,lrotate1_,matrix)(t ** S, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch) \
	int32_t n = nrl + nrh;                     \
	t temp;                                    \
	for (int32_t i = nrl; i <= nrh; i++) {     \
		for (int32_t j = ncl; j <= nch; j++) { \
			temp = S[n - j][i];                \
			S[n - j][i] = S[i][j];             \
			S[i][j] = temp;                    \
		}                                      \
	}                                          \
}                                              \
void short_name(t,rrotate1_,matrix)(t ** S, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch) \
{                                              \
	int32_t n = nrl + nrh;                     \
	t temp;                                    \
	for (int32_t i = nrl; i <= nrh; i++) {     \
		for (int32_t j = ncl; j <= nch; j++) { \
			temp = S[i][j];                    \
			S[i][j] = S[n - j][i];             \
			S[n - j][i] = temp;                \
		}                                      \
	}                                          \
}

rotate_type_matrix(int8_t);
rotate_type_matrix(uint8_t);
rotate_type_matrix(int16_t);
rotate_type_matrix(uint16_t);
rotate_type_matrix(int32_t);
rotate_type_matrix(uint32_t);
rotate_type_matrix(int64_t);
rotate_type_matrix(uint64_t);
rotate_type_matrix(float);
rotate_type_matrix(double);
rotate_type_matrix(rgb8);
rotate_type_matrix(rgbx8);



/* ---------------------------------- */
/* --- Horizontal & Vertical Flip --- */
/* ---------------------------------- */


#undef flip_type_matrix
#define flip_type_matrix(t) \
void short_name(t,hflip_,matrix)(t ** S, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, t ** D) \
{                                              \
	int32_t n = ncl + nch;                     \
	for (int32_t i = nrl; i <= nrh; i++) {     \
		for (int32_t j = ncl; j <= nch; j++) { \
			D[i][n - j] = S[i][j];             \
		}                                      \
	}                                          \
}                                              \
void short_name(t,vflip_,matrix)(t ** S, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch, t ** D) \
{                                              \
	int32_t n = nrl + nrh;                     \
	for (int32_t i = nrl; i <= nrh; i++) {     \
		for (int32_t j = ncl; j <= nch; j++) { \
			D[n - i][j] = S[i][j];             \
		}                                      \
	}                                          \
}                                              \
void short_name(t,hflip1_,matrix)(t ** S, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch) \
{                                              \
	int32_t n = ncl + nch;                     \
	t temp;                                    \
	for (int32_t i = nrl; i <= nrh; i++) {     \
		for (int32_t j = ncl; j <= nch; j++) { \
			temp = S[i][n - j];                \
			S[i][n - j] = S[i][j];             \
			S[i][j] = temp;                    \
		}                                      \
	}                                          \
}                                              \
void short_name(t,vflip1_,matrix)(t ** S, int32_t nrl, int32_t nrh, int32_t ncl, int32_t nch) \
{                                              \
	int32_t n = ncl + nch;                     \
	t temp;                                    \
	for (int32_t i = nrl; i <= nrh; i++) {     \
		for (int32_t j = ncl; j <= nch; j++) { \
			temp = S[n - i][j];                \
			S[n - i][j] = S[i][j];             \
			S[i][j] = temp;                    \
		}                                      \
	}                                          \
}

flip_type_matrix(int8_t);
flip_type_matrix(uint8_t);
flip_type_matrix(int16_t);
flip_type_matrix(uint16_t);
flip_type_matrix(int32_t);
flip_type_matrix(uint32_t);
flip_type_matrix(int64_t);
flip_type_matrix(uint64_t);
flip_type_matrix(float);
flip_type_matrix(double);
flip_type_matrix(rgb8);
flip_type_matrix(rgbx8);



// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:

// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=4:softtabstop=4

